/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.shader;

import com.mojang.blaze3d.platform.GlStateManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import net.coderbot.iris.gl.GlResource;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.shader.ShaderConstants;
import net.coderbot.iris.gl.shader.ShaderType;
import net.coderbot.iris.gl.shader.ShaderWorkarounds;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GlShader
extends GlResource {
    private static final Logger LOGGER = LogManager.getLogger(GlShader.class);
    private final String name;

    public GlShader(ShaderType shaderType, String string, String string2, ShaderConstants shaderConstants) {
        super(GlShader.createShader(shaderType, string, string2, shaderConstants));
        this.name = string;
    }

    private static int createShader(ShaderType shaderType, String string, String string2, ShaderConstants shaderConstants) {
        int n;
        string2 = GlShader.processShader(string2, shaderConstants);
        int n2 = GlStateManager.glCreateShader((int)shaderType.id);
        ShaderWorkarounds.safeShaderSource(n2, string2);
        GlStateManager.glCompileShader((int)n2);
        String string3 = IrisRenderSystem.getShaderInfoLog(n2);
        if (!string3.isEmpty()) {
            LOGGER.warn("Shader compilation log for " + string + ": " + string3);
        }
        if ((n = GlStateManager.glGetShaderi((int)n2, (int)35713)) != 1) {
            throw new RuntimeException("Shader compilation failed, see log for details");
        }
        return n2;
    }

    public static String processShader(String string, ShaderConstants shaderConstants) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        boolean bl = false;
        try (BufferedReader bufferedReader = new BufferedReader(new StringReader(string));){
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2).append("\n");
                if (bl || !string2.startsWith("#version")) continue;
                for (String string3 : shaderConstants.getDefineStrings()) {
                    stringBuilder.append(string3).append('\n');
                }
                bl = true;
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not process shader source", iOException);
        }
        return stringBuilder.toString();
    }

    public String getName() {
        return this.name;
    }

    public int getHandle() {
        return this.getGlId();
    }

    @Override
    protected void destroyInternal() {
        GlStateManager.glDeleteShader((int)this.getGlId());
    }
}

