/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.shader;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ShaderConstants {
    private final List<String> defines;

    private ShaderConstants(List<String> list) {
        this.defines = list;
    }

    public List<String> getDefineStrings() {
        return this.defines;
    }

    public static ShaderConstants fromStringList(List<String> list) {
        Builder builder = new Builder();
        builder.defineAll(list);
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private static final String EMPTY_VALUE = "";
        private final HashMap<String, String> constants = new HashMap();

        private Builder() {
        }

        public Builder define(String string) {
            this.define(Objects.requireNonNull(string), EMPTY_VALUE);
            return this;
        }

        public Builder define(String string, String string2) {
            String string3 = this.constants.get(string);
            if (string3 != null) {
                throw new IllegalArgumentException("Constant " + string + " is already defined with value " + string3);
            }
            this.constants.put(Objects.requireNonNull(string), Objects.requireNonNull(string2));
            return this;
        }

        public Builder defineAll(List<String> list) {
            list.forEach(this::define);
            return this;
        }

        public Builder defineAll(Map<String, String> map) {
            map.forEach(this::define);
            return this;
        }

        public ShaderConstants build() {
            ArrayList<CallSite> arrayList = new ArrayList<CallSite>(this.constants.size());
            for (Map.Entry<String, String> entry : this.constants.entrySet()) {
                String string = entry.getKey();
                String string2 = entry.getValue();
                if (string2.length() <= 0) {
                    arrayList.add((CallSite)((Object)("#define " + string)));
                    continue;
                }
                arrayList.add((CallSite)((Object)("#define " + string + " " + string2)));
            }
            return new ShaderConstants(Collections.unmodifiableList(arrayList));
        }
    }
}

