/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui.element;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.coderbot.iris.gui.GuiUtil;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public class IrisElementRow {
    private final Map<Element, Integer> elements = new HashMap<Element, Integer>();
    private final List<Element> orderedElements = new ArrayList<Element>();
    private final int spacing;
    private int x;
    private int y;
    private int width;
    private int height;

    public IrisElementRow(int n) {
        this.spacing = n;
    }

    public IrisElementRow() {
        this(1);
    }

    public IrisElementRow add(Element element, int n) {
        if (!this.orderedElements.contains(element)) {
            this.orderedElements.add(element);
        }
        this.elements.put(element, n);
        this.width += n + this.spacing;
        return this;
    }

    public void setWidth(Element element, int n) {
        if (!this.elements.containsKey(element)) {
            return;
        }
        this.width -= this.elements.get(element) + 2;
        this.add(element, n);
    }

    public void render(class_4587 class_45872, int n, int n2, int n3, int n4, int n5, float f, boolean bl) {
        this.x = n;
        this.y = n2;
        this.height = n3;
        int n6 = n;
        for (Element element : this.orderedElements) {
            int n7 = this.elements.get(element);
            element.render(class_45872, n6, n2, n7, n3, n4, n5, f, bl && this.sectionHovered(n6, n7, n4, n5));
            n6 += n7 + this.spacing;
        }
    }

    public void renderRightAligned(class_4587 class_45872, int n, int n2, int n3, int n4, int n5, float f, boolean bl) {
        this.render(class_45872, n - this.width, n2, n3, n4, n5, f, bl);
    }

    private boolean sectionHovered(int n, int n2, double d, double d2) {
        return d > (double)n && d < (double)(n + n2) && d2 > (double)this.y && d2 < (double)(this.y + this.height);
    }

    private Optional<Element> getHovered(double d, double d2) {
        int n = this.x;
        for (Element element : this.orderedElements) {
            int n2 = this.elements.get(element);
            if (this.sectionHovered(n, n2, d, d2)) {
                return Optional.of(element);
            }
            n += n2 + this.spacing;
        }
        return Optional.empty();
    }

    public boolean mouseClicked(double d, double d2, int n) {
        return this.getHovered(d, d2).map(element -> element.mouseClicked(d, d2, n)).orElse(false);
    }

    public boolean mouseReleased(double d, double d2, int n) {
        return this.getHovered(d, d2).map(element -> element.mouseReleased(d, d2, n)).orElse(false);
    }

    public static abstract class Element {
        public boolean disabled = false;
        private boolean hovered = false;

        public void render(class_4587 class_45872, int n, int n2, int n3, int n4, int n5, int n6, float f, boolean bl) {
            GuiUtil.bindIrisWidgetsTexture();
            GuiUtil.drawButton(class_45872, n, n2, n3, n4, bl, this.disabled);
            this.hovered = bl;
            this.renderLabel(class_45872, n, n2, n3, n4, n5, n6, f, bl);
        }

        public abstract void renderLabel(class_4587 var1, int var2, int var3, int var4, int var5, int var6, int var7, float var8, boolean var9);

        public boolean mouseClicked(double d, double d2, int n) {
            return false;
        }

        public boolean mouseReleased(double d, double d2, int n) {
            return false;
        }

        public boolean isHovered() {
            return this.hovered;
        }
    }

    public static class TextButtonElement
    extends ButtonElement<TextButtonElement> {
        protected final class_327 font;
        public class_2561 text;

        public TextButtonElement(class_2561 class_25612, Function<TextButtonElement, Boolean> function) {
            super(function);
            this.font = class_310.method_1551().field_1772;
            this.text = class_25612;
        }

        @Override
        public void renderLabel(class_4587 class_45872, int n, int n2, int n3, int n4, int n5, int n6, float f, boolean bl) {
            int n7 = n + (int)((double)(n3 - this.font.method_27525((class_5348)this.text)) * 0.5);
            int n8 = n2 + (int)((double)(n4 - 8) * 0.5);
            this.font.method_30881(class_45872, this.text, (float)n7, (float)n8, 0xFFFFFF);
        }
    }

    public static class IconButtonElement
    extends ButtonElement<IconButtonElement> {
        public GuiUtil.Icon icon;
        public GuiUtil.Icon hoveredIcon;

        public IconButtonElement(GuiUtil.Icon icon, GuiUtil.Icon icon2, Function<IconButtonElement, Boolean> function) {
            super(function);
            this.icon = icon;
            this.hoveredIcon = icon2;
        }

        public IconButtonElement(GuiUtil.Icon icon, Function<IconButtonElement, Boolean> function) {
            this(icon, icon, function);
        }

        @Override
        public void renderLabel(class_4587 class_45872, int n, int n2, int n3, int n4, int n5, int n6, float f, boolean bl) {
            int n7 = n + (int)((double)(n3 - this.icon.getWidth()) * 0.5);
            int n8 = n2 + (int)((double)(n4 - this.icon.getHeight()) * 0.5);
            GuiUtil.bindIrisWidgetsTexture();
            if (!this.disabled && bl) {
                this.hoveredIcon.draw(class_45872, n7, n8);
            } else {
                this.icon.draw(class_45872, n7, n8);
            }
        }
    }

    public static abstract class ButtonElement<T extends ButtonElement<T>>
    extends Element {
        private final Function<T, Boolean> onClick;

        protected ButtonElement(Function<T, Boolean> function) {
            this.onClick = function;
        }

        @Override
        public boolean mouseClicked(double d, double d2, int n) {
            if (this.disabled) {
                return false;
            }
            if (n == 0) {
                return this.onClick.apply(this);
            }
            return super.mouseClicked(d, d2, n);
        }
    }
}

