/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.newshader;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.coderbot.iris.gl.blending.AlphaTest;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.shader.ShaderType;
import net.coderbot.iris.pipeline.newshader.ExtendedShader;
import net.coderbot.iris.pipeline.newshader.FogMode;
import net.coderbot.iris.pipeline.newshader.NewWorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.ShaderAttributeInputs;
import net.coderbot.iris.pipeline.newshader.TriforcePatcher;
import net.coderbot.iris.pipeline.newshader.fallback.FallbackShader;
import net.coderbot.iris.pipeline.newshader.fallback.ShaderSynthesizer;
import net.coderbot.iris.shaderpack.PackRenderTargetDirectives;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.uniforms.CommonUniforms;
import net.coderbot.iris.uniforms.FrameUpdateNotifier;
import net.coderbot.iris.uniforms.builtin.BuiltinReplacementUniforms;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_3270;
import net.minecraft.class_3298;
import net.minecraft.class_5912;
import org.jetbrains.annotations.Nullable;

public class NewShaderTests {
    public static ExtendedShader create(String string, ProgramSource programSource, GlFramebuffer glFramebuffer, GlFramebuffer glFramebuffer2, GlFramebuffer glFramebuffer3, AlphaTest alphaTest, class_293 class_2932, FrameUpdateNotifier frameUpdateNotifier, NewWorldRenderingPipeline newWorldRenderingPipeline, FogMode fogMode, boolean bl, boolean bl2) throws IOException {
        AlphaTest alphaTest2 = programSource.getDirectives().getAlphaTestOverride().orElse(alphaTest);
        BlendModeOverride blendModeOverride = programSource.getDirectives().getBlendModeOverride();
        ShaderAttributeInputs shaderAttributeInputs = new ShaderAttributeInputs(class_2932, bl2);
        String string2 = TriforcePatcher.patchVanilla(programSource.getVertexSource().orElseThrow(RuntimeException::new), ShaderType.VERTEX, alphaTest2, true, shaderAttributeInputs);
        String string3 = null;
        if (programSource.getGeometrySource().isPresent()) {
            string3 = TriforcePatcher.patchVanilla(programSource.getGeometrySource().get(), ShaderType.GEOMETRY, alphaTest2, true, shaderAttributeInputs);
        }
        String string4 = TriforcePatcher.patchVanilla(programSource.getFragmentSource().orElseThrow(RuntimeException::new), ShaderType.FRAGMENT, alphaTest2, true, shaderAttributeInputs);
        StringBuilder stringBuilder = new StringBuilder("{\n    \"blend\": {\n        \"func\": \"add\",\n        \"srcrgb\": \"srcalpha\",\n        \"dstrgb\": \"1-srcalpha\"\n    },\n    \"vertex\": \"" + string + "\",\n    \"fragment\": \"" + string + "\",\n    \"attributes\": [\n        \"Position\",\n        \"Color\",\n        \"UV0\",\n        \"UV1\",\n        \"UV2\",\n        \"Normal\"\n    ],\n    \"samplers\": [\n        { \"name\": \"gtexture\" },\n        { \"name\": \"texture\" },\n        { \"name\": \"tex\" },\n        { \"name\": \"iris_overlay\" },\n        { \"name\": \"lightmap\" },\n        { \"name\": \"normals\" },\n        { \"name\": \"specular\" },\n        { \"name\": \"shadow\" },\n        { \"name\": \"watershadow\" },\n        { \"name\": \"shadowtex0\" },\n        { \"name\": \"shadowtex1\" },\n        { \"name\": \"depthtex0\" },\n        { \"name\": \"depthtex1\" },\n        { \"name\": \"noisetex\" },\n");
        Object object = PackRenderTargetDirectives.BASELINE_SUPPORTED_RENDER_TARGETS.iterator();
        while (object.hasNext()) {
            int n = object.next();
            if (n >= 4 && n < PackRenderTargetDirectives.LEGACY_RENDER_TARGETS.size()) {
                stringBuilder.append("        { \"name\": \"");
                stringBuilder.append((String)PackRenderTargetDirectives.LEGACY_RENDER_TARGETS.get(n));
                stringBuilder.append("\" },\n");
            }
            stringBuilder.append("        { \"name\": \"colortex");
            stringBuilder.append(n);
            stringBuilder.append("\" },\n");
        }
        stringBuilder.append("        { \"name\": \"shadowcolor\" },\n        { \"name\": \"shadowcolor0\" },\n        { \"name\": \"shadowcolor1\" }\n    ],\n    \"uniforms\": [\n        { \"name\": \"iris_TextureMat\", \"type\": \"matrix4x4\", \"count\": 16, \"values\": [ 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0 ] },\n        { \"name\": \"iris_ModelViewMat\", \"type\": \"matrix4x4\", \"count\": 16, \"values\": [ 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0 ] },\n        { \"name\": \"iris_ProjMat\", \"type\": \"matrix4x4\", \"count\": 16, \"values\": [ 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0 ] },\n        { \"name\": \"iris_ChunkOffset\", \"type\": \"float\", \"count\": 3, \"values\": [ 0.0, 0.0, 0.0 ] },\n        { \"name\": \"iris_ColorModulator\", \"type\": \"float\", \"count\": 4, \"values\": [ 1.0, 1.0, 1.0, 1.0 ] },\n        { \"name\": \"iris_FogStart\", \"type\": \"float\", \"count\": 1, \"values\": [ 0.0 ] },\n        { \"name\": \"iris_FogEnd\", \"type\": \"float\", \"count\": 1, \"values\": [ 1.0 ] },\n        { \"name\": \"iris_LineWidth\", \"type\": \"float\", \"count\": 1, \"values\": [ 1.0 ] },\n        { \"name\": \"iris_ScreenSize\", \"type\": \"float\", \"count\": 2, \"values\": [ 1.0, 1.0 ] },\n        { \"name\": \"iris_FogColor\", \"type\": \"float\", \"count\": 4, \"values\": [ 0.0, 0.0, 0.0, 0.0 ] }\n    ]\n}");
        object = stringBuilder.toString();
        IrisProgramResourceFactory irisProgramResourceFactory = new IrisProgramResourceFactory((String)object, string2, string3, string4);
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            Path path = FabricLoader.getInstance().getGameDir().resolve("patched_shaders");
            Files.write(path.resolve(string + ".vsh"), string2.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            Files.write(path.resolve(string + ".fsh"), string4.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            if (string3 != null) {
                Files.write(path.resolve(string + ".gsh"), string3.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            Files.write(path.resolve(string + ".json"), ((String)object).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        return new ExtendedShader(irisProgramResourceFactory, string, class_2932, glFramebuffer, glFramebuffer2, glFramebuffer3, blendModeOverride, dynamicUniformHolder -> {
            CommonUniforms.addCommonUniforms(dynamicUniformHolder, programSource.getParent().getPack().getIdMap(), programSource.getParent().getPackDirectives(), frameUpdateNotifier, fogMode);
            BuiltinReplacementUniforms.addBuiltinReplacementUniforms(dynamicUniformHolder);
        }, bl2, newWorldRenderingPipeline);
    }

    public static FallbackShader createFallback(String string, GlFramebuffer glFramebuffer, GlFramebuffer glFramebuffer2, AlphaTest alphaTest, class_293 class_2932, BlendModeOverride blendModeOverride, NewWorldRenderingPipeline newWorldRenderingPipeline, FogMode fogMode, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws IOException {
        ShaderAttributeInputs shaderAttributeInputs = new ShaderAttributeInputs(class_2932, bl4);
        String string2 = ShaderSynthesizer.vsh(true, shaderAttributeInputs, fogMode, bl, bl3);
        String string3 = ShaderSynthesizer.fsh(shaderAttributeInputs, fogMode, alphaTest, bl2, bl3);
        String string4 = "{\n    \"blend\": {\n        \"func\": \"add\",\n        \"srcrgb\": \"srcalpha\",\n        \"dstrgb\": \"1-srcalpha\"\n    },\n    \"vertex\": \"" + string + "\",\n    \"fragment\": \"" + string + "\",\n    \"attributes\": [\n        \"Position\",\n        \"Color\",\n        \"UV0\",\n        \"UV1\",\n        \"UV2\",\n        \"Normal\"\n    ],\n    \"samplers\": [\n        { \"name\": \"Sampler0\" },\n        { \"name\": \"Sampler1\" },\n        { \"name\": \"Sampler2\" }\n    ],\n    \"uniforms\": [\n        { \"name\": \"TextureMat\", \"type\": \"matrix4x4\", \"count\": 16, \"values\": [ 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0 ] },\n        { \"name\": \"ModelViewMat\", \"type\": \"matrix4x4\", \"count\": 16, \"values\": [ 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0 ] },\n        { \"name\": \"ProjMat\", \"type\": \"matrix4x4\", \"count\": 16, \"values\": [ 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0 ] },\n        { \"name\": \"ChunkOffset\", \"type\": \"float\", \"count\": 3, \"values\": [ 0.0, 0.0, 0.0 ] },\n        { \"name\": \"ColorModulator\", \"type\": \"float\", \"count\": 4, \"values\": [ 1.0, 1.0, 1.0, 1.0 ] },\n        { \"name\": \"Light0_Direction\", \"type\": \"float\", \"count\": 3, \"values\": [0.0, 0.0, 0.0] },\n        { \"name\": \"Light1_Direction\", \"type\": \"float\", \"count\": 3, \"values\": [0.0, 0.0, 0.0] },\n        { \"name\": \"FogStart\", \"type\": \"float\", \"count\": 1, \"values\": [ 0.0 ] },\n        { \"name\": \"FogEnd\", \"type\": \"float\", \"count\": 1, \"values\": [ 1.0 ] },\n        { \"name\": \"FogDensity\", \"type\": \"float\", \"count\": 1, \"values\": [ 1.0 ] },\n        { \"name\": \"FogIsExp2\", \"type\": \"int\", \"count\": 1, \"values\": [ 0 ] },\n        { \"name\": \"LineWidth\", \"type\": \"float\", \"count\": 1, \"values\": [ 1.0 ] },\n        { \"name\": \"ScreenSize\", \"type\": \"float\", \"count\": 2, \"values\": [ 1.0, 1.0 ] },\n        { \"name\": \"FogColor\", \"type\": \"float\", \"count\": 4, \"values\": [ 0.0, 0.0, 0.0, 0.0 ] }\n    ]\n}";
        IrisProgramResourceFactory irisProgramResourceFactory = new IrisProgramResourceFactory(string4, string2, null, string3);
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            Path path = FabricLoader.getInstance().getGameDir().resolve("patched_shaders");
            Files.write(path.resolve(string + ".vsh"), string2.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            Files.write(path.resolve(string + ".fsh"), string3.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            Files.write(path.resolve(string + ".json"), string4.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        return new FallbackShader(irisProgramResourceFactory, string, class_2932, glFramebuffer, glFramebuffer2, blendModeOverride, newWorldRenderingPipeline);
    }

    private static class IrisProgramResourceFactory
    implements class_5912 {
        private final String json;
        private final String vertex;
        private final String geometry;
        private final String fragment;

        public IrisProgramResourceFactory(String string, String string2, String string3, String string4) {
            this.json = string;
            this.vertex = string2;
            this.geometry = string3;
            this.fragment = string4;
        }

        public class_3298 method_14486(class_2960 class_29602) throws IOException {
            String string = class_29602.method_12832();
            if (string.endsWith("json")) {
                return new StringResource(class_29602, this.json);
            }
            if (string.endsWith("vsh")) {
                return new StringResource(class_29602, this.vertex);
            }
            if (string.endsWith("gsh")) {
                if (this.geometry == null) {
                    return null;
                }
                return new StringResource(class_29602, this.geometry);
            }
            if (string.endsWith("fsh")) {
                return new StringResource(class_29602, this.fragment);
            }
            throw new IOException("Couldn't load " + class_29602);
        }
    }

    private static class StringResource
    implements class_3298 {
        private final class_2960 id;
        private final String content;

        private StringResource(class_2960 class_29602, String string) {
            this.id = class_29602;
            this.content = string;
        }

        public class_2960 method_14483() {
            return this.id;
        }

        public InputStream method_14482() {
            return new ByteArrayInputStream(this.content.getBytes(StandardCharsets.UTF_8));
        }

        public boolean method_14484() {
            return false;
        }

        @Nullable
        public <T> T method_14481(class_3270<T> class_32702) {
            return null;
        }

        public String method_14480() {
            return "<iris shaderpack shaders>";
        }

        public void close() throws IOException {
        }
    }
}

