/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack.include;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import net.coderbot.iris.shaderpack.include.AbsolutePackPath;
import net.coderbot.iris.shaderpack.include.FileNode;
import net.coderbot.iris.shaderpack.transform.line.LineTransform;

public class IncludeGraph {
    private final ImmutableMap<AbsolutePackPath, FileNode> nodes;
    private final ImmutableMap<AbsolutePackPath, IOException> failures;

    private IncludeGraph(ImmutableMap<AbsolutePackPath, FileNode> immutableMap, ImmutableMap<AbsolutePackPath, IOException> immutableMap2) {
        this.nodes = immutableMap;
        this.failures = immutableMap2;
    }

    public IncludeGraph(Path path, ImmutableList<AbsolutePackPath> immutableList) {
        HashMap<AbsolutePackPath, FileNode> hashMap = new HashMap<AbsolutePackPath, FileNode>();
        HashMap<AbsolutePackPath, IOException> hashMap2 = new HashMap<AbsolutePackPath, IOException>();
        ArrayList<AbsolutePackPath> arrayList = new ArrayList<AbsolutePackPath>((Collection<AbsolutePackPath>)immutableList);
        HashSet<AbsolutePackPath> hashSet = new HashSet<AbsolutePackPath>((Collection<AbsolutePackPath>)immutableList);
        while (!arrayList.isEmpty()) {
            String string;
            AbsolutePackPath absolutePackPath = (AbsolutePackPath)arrayList.remove(arrayList.size() - 1);
            try {
                string = IncludeGraph.readFile(absolutePackPath.resolved(path));
            }
            catch (IOException iOException) {
                hashMap2.put(absolutePackPath, iOException);
                continue;
            }
            ImmutableList immutableList2 = ImmutableList.copyOf((Object[])string.split("\\R"));
            FileNode fileNode = new FileNode(absolutePackPath, (ImmutableList<String>)immutableList2);
            hashMap.put(absolutePackPath, fileNode);
            ImmutableCollection immutableCollection = fileNode.getIncludes().values();
            for (AbsolutePackPath absolutePackPath2 : immutableCollection) {
                if (hashSet.contains(absolutePackPath2)) continue;
                arrayList.add(absolutePackPath2);
                hashSet.add(absolutePackPath2);
            }
        }
        this.nodes = ImmutableMap.copyOf(hashMap);
        this.failures = ImmutableMap.copyOf(hashMap2);
    }

    public ImmutableMap<AbsolutePackPath, FileNode> getNodes() {
        return this.nodes;
    }

    public List<IncludeGraph> computeWeaklyConnectedSubgraphs() {
        return Collections.singletonList(this);
    }

    public IncludeGraph map(Function<AbsolutePackPath, LineTransform> function) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.nodes.forEach((absolutePackPath, fileNode) -> builder.put(absolutePackPath, (Object)fileNode.map((LineTransform)function.apply((AbsolutePackPath)absolutePackPath))));
        return new IncludeGraph((ImmutableMap<AbsolutePackPath, FileNode>)builder.build(), this.failures);
    }

    public ImmutableMap<AbsolutePackPath, IOException> getFailures() {
        return this.failures;
    }

    private static String readFile(Path path) throws IOException {
        return new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
    }
}

