/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack.preprocessor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.shader.StandardMacros;
import net.coderbot.iris.shaderpack.option.ShaderPackOptions;
import net.coderbot.iris.shaderpack.preprocessor.PropertiesCommentListener;
import net.coderbot.iris.shaderpack.preprocessor.PropertyCollectingListener;
import org.anarres.cpp.Feature;
import org.anarres.cpp.LexerException;
import org.anarres.cpp.Preprocessor;
import org.anarres.cpp.PreprocessorListener;
import org.anarres.cpp.Source;
import org.anarres.cpp.StringLexerSource;
import org.anarres.cpp.Token;

public class PropertiesPreprocessor {
    public static String preprocessSource(String string3, ShaderPackOptions shaderPackOptions) {
        if (string3.contains("#warning IRIS_PASSTHROUGH ")) {
            throw new RuntimeException("Some shader author is trying to exploit internal Iris implementation details, stop!");
        }
        List<String> list = PropertiesPreprocessor.getBooleanValues(shaderPackOptions);
        Map<String, String> map = PropertiesPreprocessor.getStringValues(shaderPackOptions);
        Preprocessor preprocessor = new Preprocessor();
        try {
            for (String string4 : list) {
                preprocessor.addMacro(string4);
            }
            preprocessor.addMacro("MC_VERSION", StandardMacros.getMcVersion());
        }
        catch (LexerException lexerException) {
            lexerException.printStackTrace();
        }
        map.forEach((string, string2) -> {
            try {
                preprocessor.addMacro(string, string2);
            }
            catch (LexerException lexerException) {
                lexerException.printStackTrace();
            }
        });
        return PropertiesPreprocessor.process(preprocessor, string3);
    }

    public static String preprocessSource(String string) {
        if (string.contains("#warning IRIS_PASSTHROUGH ")) {
            throw new RuntimeException("Some shader author is trying to exploit internal Iris implementation details, stop!");
        }
        Preprocessor preprocessor = new Preprocessor();
        try {
            preprocessor.addMacro("MC_VERSION", StandardMacros.getMcVersion());
        }
        catch (LexerException lexerException) {
            lexerException.printStackTrace();
        }
        return PropertiesPreprocessor.process(preprocessor, string);
    }

    private static String process(Preprocessor preprocessor, String string) {
        preprocessor.setListener((PreprocessorListener)new PropertiesCommentListener());
        PropertyCollectingListener propertyCollectingListener = new PropertyCollectingListener();
        string = string.replaceAll("([a-zA-Z]+\\.[a-zA-Z0-9]+)", "#warning IRIS_PASSTHROUGH $1");
        preprocessor.setListener((PreprocessorListener)propertyCollectingListener);
        string = Arrays.stream(string.split("\\R")).map(String::trim).collect(Collectors.joining("\n"));
        preprocessor.addInput((Source)new StringLexerSource(string, true));
        preprocessor.addFeature(Feature.KEEPCOMMENTS);
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Token token;
            while ((token = preprocessor.token()) != null && token.getType() != 265) {
                stringBuilder.append(token.getText());
            }
        }
        catch (Exception exception) {
            Iris.logger.error("Properties pre-processing failed", exception);
        }
        string = stringBuilder.toString();
        return propertyCollectingListener.collectLines() + string;
    }

    private static List<String> getBooleanValues(ShaderPackOptions shaderPackOptions) {
        ArrayList<String> arrayList = new ArrayList<String>();
        shaderPackOptions.getOptionSet().getBooleanOptions().forEach((string, mergedBooleanOption) -> {
            boolean bl = shaderPackOptions.getOptionValues().getBooleanValueOrDefault((String)string);
            if (bl) {
                arrayList.add((String)string);
            }
        });
        return arrayList;
    }

    private static Map<String, String> getStringValues(ShaderPackOptions shaderPackOptions) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        shaderPackOptions.getOptionSet().getStringOptions().forEach((string, mergedStringOption) -> hashMap.put((String)string, shaderPackOptions.getOptionValues().getStringValueOrDefault((String)string)));
        return hashMap;
    }
}

