/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.vendored.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.NumberFormat;
import net.coderbot.iris.vendored.joml.AxisAngle4f;
import net.coderbot.iris.vendored.joml.Math;
import net.coderbot.iris.vendored.joml.Matrix3d;
import net.coderbot.iris.vendored.joml.Matrix3dc;
import net.coderbot.iris.vendored.joml.Matrix3f;
import net.coderbot.iris.vendored.joml.Matrix3fc;
import net.coderbot.iris.vendored.joml.Matrix4d;
import net.coderbot.iris.vendored.joml.Matrix4dc;
import net.coderbot.iris.vendored.joml.Matrix4f;
import net.coderbot.iris.vendored.joml.Matrix4fc;
import net.coderbot.iris.vendored.joml.Matrix4x3fc;
import net.coderbot.iris.vendored.joml.Options;
import net.coderbot.iris.vendored.joml.Quaterniond;
import net.coderbot.iris.vendored.joml.Quaterniondc;
import net.coderbot.iris.vendored.joml.Quaternionf;
import net.coderbot.iris.vendored.joml.Quaternionfc;
import net.coderbot.iris.vendored.joml.Runtime;
import net.coderbot.iris.vendored.joml.Vector3d;
import net.coderbot.iris.vendored.joml.Vector3dc;
import net.coderbot.iris.vendored.joml.Vector3f;
import net.coderbot.iris.vendored.joml.Vector3fc;
import net.coderbot.iris.vendored.joml.Vector4d;
import net.coderbot.iris.vendored.joml.Vector4dc;

public class AxisAngle4d
implements Externalizable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public double angle;
    public double x;
    public double y;
    public double z;

    public AxisAngle4d() {
        this.z = 1.0;
    }

    public AxisAngle4d(AxisAngle4d axisAngle4d) {
        this.x = axisAngle4d.x;
        this.y = axisAngle4d.y;
        this.z = axisAngle4d.z;
        this.angle = (axisAngle4d.angle < 0.0 ? java.lang.Math.PI * 2 + axisAngle4d.angle % (java.lang.Math.PI * 2) : axisAngle4d.angle) % (java.lang.Math.PI * 2);
    }

    public AxisAngle4d(AxisAngle4f axisAngle4f) {
        this.x = axisAngle4f.x;
        this.y = axisAngle4f.y;
        this.z = axisAngle4f.z;
        this.angle = ((double)axisAngle4f.angle < 0.0 ? java.lang.Math.PI * 2 + (double)axisAngle4f.angle % (java.lang.Math.PI * 2) : (double)axisAngle4f.angle) % (java.lang.Math.PI * 2);
    }

    public AxisAngle4d(Quaternionfc quaternionfc) {
        float f = Math.safeAcos(quaternionfc.w());
        float f2 = Math.invsqrt(1.0f - quaternionfc.w() * quaternionfc.w());
        if (Float.isInfinite(f2)) {
            this.x = 0.0;
            this.y = 0.0;
            this.z = 1.0;
        } else {
            this.x = quaternionfc.x() * f2;
            this.y = quaternionfc.y() * f2;
            this.z = quaternionfc.z() * f2;
        }
        this.angle = f + f;
    }

    public AxisAngle4d(Quaterniondc quaterniondc) {
        double d = Math.safeAcos(quaterniondc.w());
        double d2 = Math.invsqrt(1.0 - quaterniondc.w() * quaterniondc.w());
        if (Double.isInfinite(d2)) {
            this.x = 0.0;
            this.y = 0.0;
            this.z = 1.0;
        } else {
            this.x = quaterniondc.x() * d2;
            this.y = quaterniondc.y() * d2;
            this.z = quaterniondc.z() * d2;
        }
        this.angle = d + d;
    }

    public AxisAngle4d(double d, double d2, double d3, double d4) {
        this.x = d2;
        this.y = d3;
        this.z = d4;
        this.angle = (d < 0.0 ? java.lang.Math.PI * 2 + d % (java.lang.Math.PI * 2) : d) % (java.lang.Math.PI * 2);
    }

    public AxisAngle4d(double d, Vector3dc vector3dc) {
        this(d, vector3dc.x(), vector3dc.y(), vector3dc.z());
    }

    public AxisAngle4d(double d, Vector3f vector3f) {
        this(d, vector3f.x, vector3f.y, vector3f.z);
    }

    public AxisAngle4d set(AxisAngle4d axisAngle4d) {
        this.x = axisAngle4d.x;
        this.y = axisAngle4d.y;
        this.z = axisAngle4d.z;
        this.angle = (axisAngle4d.angle < 0.0 ? java.lang.Math.PI * 2 + axisAngle4d.angle % (java.lang.Math.PI * 2) : axisAngle4d.angle) % (java.lang.Math.PI * 2);
        return this;
    }

    public AxisAngle4d set(AxisAngle4f axisAngle4f) {
        this.x = axisAngle4f.x;
        this.y = axisAngle4f.y;
        this.z = axisAngle4f.z;
        this.angle = ((double)axisAngle4f.angle < 0.0 ? java.lang.Math.PI * 2 + (double)axisAngle4f.angle % (java.lang.Math.PI * 2) : (double)axisAngle4f.angle) % (java.lang.Math.PI * 2);
        return this;
    }

    public AxisAngle4d set(double d, double d2, double d3, double d4) {
        this.x = d2;
        this.y = d3;
        this.z = d4;
        this.angle = (d < 0.0 ? java.lang.Math.PI * 2 + d % (java.lang.Math.PI * 2) : d) % (java.lang.Math.PI * 2);
        return this;
    }

    public AxisAngle4d set(double d, Vector3dc vector3dc) {
        return this.set(d, vector3dc.x(), vector3dc.y(), vector3dc.z());
    }

    public AxisAngle4d set(double d, Vector3f vector3f) {
        return this.set(d, vector3f.x, vector3f.y, vector3f.z);
    }

    public AxisAngle4d set(Quaternionfc quaternionfc) {
        float f = Math.safeAcos(quaternionfc.w());
        float f2 = Math.invsqrt(1.0f - quaternionfc.w() * quaternionfc.w());
        if (Float.isInfinite(f2)) {
            this.x = 0.0;
            this.y = 0.0;
            this.z = 1.0;
        } else {
            this.x = quaternionfc.x() * f2;
            this.y = quaternionfc.y() * f2;
            this.z = quaternionfc.z() * f2;
        }
        this.angle = f + f;
        return this;
    }

    public AxisAngle4d set(Quaterniondc quaterniondc) {
        double d = Math.safeAcos(quaterniondc.w());
        double d2 = Math.invsqrt(1.0 - quaterniondc.w() * quaterniondc.w());
        if (Double.isInfinite(d2)) {
            this.x = 0.0;
            this.y = 0.0;
            this.z = 1.0;
        } else {
            this.x = quaterniondc.x() * d2;
            this.y = quaterniondc.y() * d2;
            this.z = quaterniondc.z() * d2;
        }
        this.angle = d + d;
        return this;
    }

    public AxisAngle4d set(Matrix3fc matrix3fc) {
        double d = matrix3fc.m00();
        double d2 = matrix3fc.m01();
        double d3 = matrix3fc.m02();
        double d4 = matrix3fc.m10();
        double d5 = matrix3fc.m11();
        double d6 = matrix3fc.m12();
        double d7 = matrix3fc.m20();
        double d8 = matrix3fc.m21();
        double d9 = matrix3fc.m22();
        double d10 = Math.invsqrt(matrix3fc.m00() * matrix3fc.m00() + matrix3fc.m01() * matrix3fc.m01() + matrix3fc.m02() * matrix3fc.m02());
        double d11 = Math.invsqrt(matrix3fc.m10() * matrix3fc.m10() + matrix3fc.m11() * matrix3fc.m11() + matrix3fc.m12() * matrix3fc.m12());
        double d12 = Math.invsqrt(matrix3fc.m20() * matrix3fc.m20() + matrix3fc.m21() * matrix3fc.m21() + matrix3fc.m22() * matrix3fc.m22());
        d *= d10;
        d2 *= d10;
        d3 *= d10;
        d4 *= d11;
        d5 *= d11;
        d6 *= d11;
        d7 *= d12;
        d8 *= d12;
        d9 *= d12;
        double d13 = 1.0E-4;
        double d14 = 0.001;
        if (Math.abs(d4 - d2) < d13 && Math.abs(d7 - d3) < d13 && Math.abs(d8 - d6) < d13) {
            if (Math.abs(d4 + d2) < d14 && Math.abs(d7 + d3) < d14 && Math.abs(d8 + d6) < d14 && Math.abs(d + d5 + d9 - 3.0) < d14) {
                this.x = 0.0;
                this.y = 0.0;
                this.z = 1.0;
                this.angle = 0.0;
                return this;
            }
            this.angle = java.lang.Math.PI;
            double d15 = (d + 1.0) / 2.0;
            double d16 = (d5 + 1.0) / 2.0;
            double d17 = (d9 + 1.0) / 2.0;
            double d18 = (d4 + d2) / 4.0;
            double d19 = (d7 + d3) / 4.0;
            double d20 = (d8 + d6) / 4.0;
            if (d15 > d16 && d15 > d17) {
                this.x = Math.sqrt(d15);
                this.y = d18 / this.x;
                this.z = d19 / this.x;
            } else if (d16 > d17) {
                this.y = Math.sqrt(d16);
                this.x = d18 / this.y;
                this.z = d20 / this.y;
            } else {
                this.z = Math.sqrt(d17);
                this.x = d19 / this.z;
                this.y = d20 / this.z;
            }
            return this;
        }
        double d21 = Math.sqrt((d6 - d8) * (d6 - d8) + (d7 - d3) * (d7 - d3) + (d2 - d4) * (d2 - d4));
        this.angle = Math.safeAcos((d + d5 + d9 - 1.0) / 2.0);
        this.x = (d6 - d8) / d21;
        this.y = (d7 - d3) / d21;
        this.z = (d2 - d4) / d21;
        return this;
    }

    public AxisAngle4d set(Matrix3dc matrix3dc) {
        double d = matrix3dc.m00();
        double d2 = matrix3dc.m01();
        double d3 = matrix3dc.m02();
        double d4 = matrix3dc.m10();
        double d5 = matrix3dc.m11();
        double d6 = matrix3dc.m12();
        double d7 = matrix3dc.m20();
        double d8 = matrix3dc.m21();
        double d9 = matrix3dc.m22();
        double d10 = Math.invsqrt(matrix3dc.m00() * matrix3dc.m00() + matrix3dc.m01() * matrix3dc.m01() + matrix3dc.m02() * matrix3dc.m02());
        double d11 = Math.invsqrt(matrix3dc.m10() * matrix3dc.m10() + matrix3dc.m11() * matrix3dc.m11() + matrix3dc.m12() * matrix3dc.m12());
        double d12 = Math.invsqrt(matrix3dc.m20() * matrix3dc.m20() + matrix3dc.m21() * matrix3dc.m21() + matrix3dc.m22() * matrix3dc.m22());
        d *= d10;
        d2 *= d10;
        d3 *= d10;
        d4 *= d11;
        d5 *= d11;
        d6 *= d11;
        d7 *= d12;
        d8 *= d12;
        d9 *= d12;
        double d13 = 1.0E-4;
        double d14 = 0.001;
        if (Math.abs(d4 - d2) < d13 && Math.abs(d7 - d3) < d13 && Math.abs(d8 - d6) < d13) {
            if (Math.abs(d4 + d2) < d14 && Math.abs(d7 + d3) < d14 && Math.abs(d8 + d6) < d14 && Math.abs(d + d5 + d9 - 3.0) < d14) {
                this.x = 0.0;
                this.y = 0.0;
                this.z = 1.0;
                this.angle = 0.0;
                return this;
            }
            this.angle = java.lang.Math.PI;
            double d15 = (d + 1.0) / 2.0;
            double d16 = (d5 + 1.0) / 2.0;
            double d17 = (d9 + 1.0) / 2.0;
            double d18 = (d4 + d2) / 4.0;
            double d19 = (d7 + d3) / 4.0;
            double d20 = (d8 + d6) / 4.0;
            if (d15 > d16 && d15 > d17) {
                this.x = Math.sqrt(d15);
                this.y = d18 / this.x;
                this.z = d19 / this.x;
            } else if (d16 > d17) {
                this.y = Math.sqrt(d16);
                this.x = d18 / this.y;
                this.z = d20 / this.y;
            } else {
                this.z = Math.sqrt(d17);
                this.x = d19 / this.z;
                this.y = d20 / this.z;
            }
            return this;
        }
        double d21 = Math.sqrt((d6 - d8) * (d6 - d8) + (d7 - d3) * (d7 - d3) + (d2 - d4) * (d2 - d4));
        this.angle = Math.safeAcos((d + d5 + d9 - 1.0) / 2.0);
        this.x = (d6 - d8) / d21;
        this.y = (d7 - d3) / d21;
        this.z = (d2 - d4) / d21;
        return this;
    }

    public AxisAngle4d set(Matrix4fc matrix4fc) {
        double d = matrix4fc.m00();
        double d2 = matrix4fc.m01();
        double d3 = matrix4fc.m02();
        double d4 = matrix4fc.m10();
        double d5 = matrix4fc.m11();
        double d6 = matrix4fc.m12();
        double d7 = matrix4fc.m20();
        double d8 = matrix4fc.m21();
        double d9 = matrix4fc.m22();
        double d10 = Math.invsqrt(matrix4fc.m00() * matrix4fc.m00() + matrix4fc.m01() * matrix4fc.m01() + matrix4fc.m02() * matrix4fc.m02());
        double d11 = Math.invsqrt(matrix4fc.m10() * matrix4fc.m10() + matrix4fc.m11() * matrix4fc.m11() + matrix4fc.m12() * matrix4fc.m12());
        double d12 = Math.invsqrt(matrix4fc.m20() * matrix4fc.m20() + matrix4fc.m21() * matrix4fc.m21() + matrix4fc.m22() * matrix4fc.m22());
        d *= d10;
        d2 *= d10;
        d3 *= d10;
        d4 *= d11;
        d5 *= d11;
        d6 *= d11;
        d7 *= d12;
        d8 *= d12;
        d9 *= d12;
        double d13 = 1.0E-4;
        double d14 = 0.001;
        if (Math.abs(d4 - d2) < d13 && Math.abs(d7 - d3) < d13 && Math.abs(d8 - d6) < d13) {
            if (Math.abs(d4 + d2) < d14 && Math.abs(d7 + d3) < d14 && Math.abs(d8 + d6) < d14 && Math.abs(d + d5 + d9 - 3.0) < d14) {
                this.x = 0.0;
                this.y = 0.0;
                this.z = 1.0;
                this.angle = 0.0;
                return this;
            }
            this.angle = java.lang.Math.PI;
            double d15 = (d + 1.0) / 2.0;
            double d16 = (d5 + 1.0) / 2.0;
            double d17 = (d9 + 1.0) / 2.0;
            double d18 = (d4 + d2) / 4.0;
            double d19 = (d7 + d3) / 4.0;
            double d20 = (d8 + d6) / 4.0;
            if (d15 > d16 && d15 > d17) {
                this.x = Math.sqrt(d15);
                this.y = d18 / this.x;
                this.z = d19 / this.x;
            } else if (d16 > d17) {
                this.y = Math.sqrt(d16);
                this.x = d18 / this.y;
                this.z = d20 / this.y;
            } else {
                this.z = Math.sqrt(d17);
                this.x = d19 / this.z;
                this.y = d20 / this.z;
            }
            return this;
        }
        double d21 = Math.sqrt((d6 - d8) * (d6 - d8) + (d7 - d3) * (d7 - d3) + (d2 - d4) * (d2 - d4));
        this.angle = Math.safeAcos((d + d5 + d9 - 1.0) / 2.0);
        this.x = (d6 - d8) / d21;
        this.y = (d7 - d3) / d21;
        this.z = (d2 - d4) / d21;
        return this;
    }

    public AxisAngle4d set(Matrix4x3fc matrix4x3fc) {
        double d = matrix4x3fc.m00();
        double d2 = matrix4x3fc.m01();
        double d3 = matrix4x3fc.m02();
        double d4 = matrix4x3fc.m10();
        double d5 = matrix4x3fc.m11();
        double d6 = matrix4x3fc.m12();
        double d7 = matrix4x3fc.m20();
        double d8 = matrix4x3fc.m21();
        double d9 = matrix4x3fc.m22();
        double d10 = Math.invsqrt(matrix4x3fc.m00() * matrix4x3fc.m00() + matrix4x3fc.m01() * matrix4x3fc.m01() + matrix4x3fc.m02() * matrix4x3fc.m02());
        double d11 = Math.invsqrt(matrix4x3fc.m10() * matrix4x3fc.m10() + matrix4x3fc.m11() * matrix4x3fc.m11() + matrix4x3fc.m12() * matrix4x3fc.m12());
        double d12 = Math.invsqrt(matrix4x3fc.m20() * matrix4x3fc.m20() + matrix4x3fc.m21() * matrix4x3fc.m21() + matrix4x3fc.m22() * matrix4x3fc.m22());
        d *= d10;
        d2 *= d10;
        d3 *= d10;
        d4 *= d11;
        d5 *= d11;
        d6 *= d11;
        d7 *= d12;
        d8 *= d12;
        d9 *= d12;
        double d13 = 1.0E-4;
        double d14 = 0.001;
        if (Math.abs(d4 - d2) < d13 && Math.abs(d7 - d3) < d13 && Math.abs(d8 - d6) < d13) {
            if (Math.abs(d4 + d2) < d14 && Math.abs(d7 + d3) < d14 && Math.abs(d8 + d6) < d14 && Math.abs(d + d5 + d9 - 3.0) < d14) {
                this.x = 0.0;
                this.y = 0.0;
                this.z = 1.0;
                this.angle = 0.0;
                return this;
            }
            this.angle = java.lang.Math.PI;
            double d15 = (d + 1.0) / 2.0;
            double d16 = (d5 + 1.0) / 2.0;
            double d17 = (d9 + 1.0) / 2.0;
            double d18 = (d4 + d2) / 4.0;
            double d19 = (d7 + d3) / 4.0;
            double d20 = (d8 + d6) / 4.0;
            if (d15 > d16 && d15 > d17) {
                this.x = Math.sqrt(d15);
                this.y = d18 / this.x;
                this.z = d19 / this.x;
            } else if (d16 > d17) {
                this.y = Math.sqrt(d16);
                this.x = d18 / this.y;
                this.z = d20 / this.y;
            } else {
                this.z = Math.sqrt(d17);
                this.x = d19 / this.z;
                this.y = d20 / this.z;
            }
            return this;
        }
        double d21 = Math.sqrt((d6 - d8) * (d6 - d8) + (d7 - d3) * (d7 - d3) + (d2 - d4) * (d2 - d4));
        this.angle = Math.safeAcos((d + d5 + d9 - 1.0) / 2.0);
        this.x = (d6 - d8) / d21;
        this.y = (d7 - d3) / d21;
        this.z = (d2 - d4) / d21;
        return this;
    }

    public AxisAngle4d set(Matrix4dc matrix4dc) {
        double d = matrix4dc.m00();
        double d2 = matrix4dc.m01();
        double d3 = matrix4dc.m02();
        double d4 = matrix4dc.m10();
        double d5 = matrix4dc.m11();
        double d6 = matrix4dc.m12();
        double d7 = matrix4dc.m20();
        double d8 = matrix4dc.m21();
        double d9 = matrix4dc.m22();
        double d10 = Math.invsqrt(matrix4dc.m00() * matrix4dc.m00() + matrix4dc.m01() * matrix4dc.m01() + matrix4dc.m02() * matrix4dc.m02());
        double d11 = Math.invsqrt(matrix4dc.m10() * matrix4dc.m10() + matrix4dc.m11() * matrix4dc.m11() + matrix4dc.m12() * matrix4dc.m12());
        double d12 = Math.invsqrt(matrix4dc.m20() * matrix4dc.m20() + matrix4dc.m21() * matrix4dc.m21() + matrix4dc.m22() * matrix4dc.m22());
        d *= d10;
        d2 *= d10;
        d3 *= d10;
        d4 *= d11;
        d5 *= d11;
        d6 *= d11;
        d7 *= d12;
        d8 *= d12;
        d9 *= d12;
        double d13 = 1.0E-4;
        double d14 = 0.001;
        if (Math.abs(d4 - d2) < d13 && Math.abs(d7 - d3) < d13 && Math.abs(d8 - d6) < d13) {
            if (Math.abs(d4 + d2) < d14 && Math.abs(d7 + d3) < d14 && Math.abs(d8 + d6) < d14 && Math.abs(d + d5 + d9 - 3.0) < d14) {
                this.x = 0.0;
                this.y = 0.0;
                this.z = 1.0;
                this.angle = 0.0;
                return this;
            }
            this.angle = java.lang.Math.PI;
            double d15 = (d + 1.0) / 2.0;
            double d16 = (d5 + 1.0) / 2.0;
            double d17 = (d9 + 1.0) / 2.0;
            double d18 = (d4 + d2) / 4.0;
            double d19 = (d7 + d3) / 4.0;
            double d20 = (d8 + d6) / 4.0;
            if (d15 > d16 && d15 > d17) {
                this.x = Math.sqrt(d15);
                this.y = d18 / this.x;
                this.z = d19 / this.x;
            } else if (d16 > d17) {
                this.y = Math.sqrt(d16);
                this.x = d18 / this.y;
                this.z = d20 / this.y;
            } else {
                this.z = Math.sqrt(d17);
                this.x = d19 / this.z;
                this.y = d20 / this.z;
            }
            return this;
        }
        double d21 = Math.sqrt((d6 - d8) * (d6 - d8) + (d7 - d3) * (d7 - d3) + (d2 - d4) * (d2 - d4));
        this.angle = Math.safeAcos((d + d5 + d9 - 1.0) / 2.0);
        this.x = (d6 - d8) / d21;
        this.y = (d7 - d3) / d21;
        this.z = (d2 - d4) / d21;
        return this;
    }

    public Quaternionf get(Quaternionf quaternionf) {
        return quaternionf.set(this);
    }

    public Quaterniond get(Quaterniond quaterniond) {
        return quaterniond.set(this);
    }

    public Matrix4f get(Matrix4f matrix4f) {
        return matrix4f.set(this);
    }

    public Matrix3f get(Matrix3f matrix3f) {
        return matrix3f.set(this);
    }

    public Matrix4d get(Matrix4d matrix4d) {
        return matrix4d.set(this);
    }

    public Matrix3d get(Matrix3d matrix3d) {
        return matrix3d.set(this);
    }

    public AxisAngle4d get(AxisAngle4d axisAngle4d) {
        return axisAngle4d.set(this);
    }

    public AxisAngle4f get(AxisAngle4f axisAngle4f) {
        return axisAngle4f.set(this);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeDouble(this.angle);
        objectOutput.writeDouble(this.x);
        objectOutput.writeDouble(this.y);
        objectOutput.writeDouble(this.z);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.angle = objectInput.readDouble();
        this.x = objectInput.readDouble();
        this.y = objectInput.readDouble();
        this.z = objectInput.readDouble();
    }

    public AxisAngle4d normalize() {
        double d = Math.invsqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        this.x *= d;
        this.y *= d;
        this.z *= d;
        return this;
    }

    public AxisAngle4d rotate(double d) {
        this.angle += d;
        this.angle = (this.angle < 0.0 ? java.lang.Math.PI * 2 + this.angle % (java.lang.Math.PI * 2) : this.angle) % (java.lang.Math.PI * 2);
        return this;
    }

    public Vector3d transform(Vector3d vector3d) {
        return this.transform(vector3d, vector3d);
    }

    public Vector3d transform(Vector3dc vector3dc, Vector3d vector3d) {
        double d = Math.sin(this.angle);
        double d2 = Math.cosFromSin(d, this.angle);
        double d3 = this.x * vector3dc.x() + this.y * vector3dc.y() + this.z * vector3dc.z();
        vector3d.set(vector3dc.x() * d2 + d * (this.y * vector3dc.z() - this.z * vector3dc.y()) + (1.0 - d2) * d3 * this.x, vector3dc.y() * d2 + d * (this.z * vector3dc.x() - this.x * vector3dc.z()) + (1.0 - d2) * d3 * this.y, vector3dc.z() * d2 + d * (this.x * vector3dc.y() - this.y * vector3dc.x()) + (1.0 - d2) * d3 * this.z);
        return vector3d;
    }

    public Vector3f transform(Vector3f vector3f) {
        return this.transform(vector3f, vector3f);
    }

    public Vector3f transform(Vector3fc vector3fc, Vector3f vector3f) {
        double d = Math.sin(this.angle);
        double d2 = Math.cosFromSin(d, this.angle);
        double d3 = this.x * (double)vector3fc.x() + this.y * (double)vector3fc.y() + this.z * (double)vector3fc.z();
        vector3f.set((float)((double)vector3fc.x() * d2 + d * (this.y * (double)vector3fc.z() - this.z * (double)vector3fc.y()) + (1.0 - d2) * d3 * this.x), (float)((double)vector3fc.y() * d2 + d * (this.z * (double)vector3fc.x() - this.x * (double)vector3fc.z()) + (1.0 - d2) * d3 * this.y), (float)((double)vector3fc.z() * d2 + d * (this.x * (double)vector3fc.y() - this.y * (double)vector3fc.x()) + (1.0 - d2) * d3 * this.z));
        return vector3f;
    }

    public Vector4d transform(Vector4d vector4d) {
        return this.transform(vector4d, vector4d);
    }

    public Vector4d transform(Vector4dc vector4dc, Vector4d vector4d) {
        double d = Math.sin(this.angle);
        double d2 = Math.cosFromSin(d, this.angle);
        double d3 = this.x * vector4dc.x() + this.y * vector4dc.y() + this.z * vector4dc.z();
        vector4d.set(vector4dc.x() * d2 + d * (this.y * vector4dc.z() - this.z * vector4dc.y()) + (1.0 - d2) * d3 * this.x, vector4dc.y() * d2 + d * (this.z * vector4dc.x() - this.x * vector4dc.z()) + (1.0 - d2) * d3 * this.y, vector4dc.z() * d2 + d * (this.x * vector4dc.y() - this.y * vector4dc.x()) + (1.0 - d2) * d3 * this.z, vector4d.w);
        return vector4d;
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat numberFormat) {
        return "(" + Runtime.format(this.x, numberFormat) + " " + Runtime.format(this.y, numberFormat) + " " + Runtime.format(this.z, numberFormat) + " <| " + Runtime.format(this.angle, numberFormat) + ")";
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits((this.angle < 0.0 ? java.lang.Math.PI * 2 + this.angle % (java.lang.Math.PI * 2) : this.angle) % (java.lang.Math.PI * 2));
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.x);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.y);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.z);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AxisAngle4d axisAngle4d = (AxisAngle4d)object;
        if (Double.doubleToLongBits((this.angle < 0.0 ? java.lang.Math.PI * 2 + this.angle % (java.lang.Math.PI * 2) : this.angle) % (java.lang.Math.PI * 2)) != Double.doubleToLongBits((axisAngle4d.angle < 0.0 ? java.lang.Math.PI * 2 + axisAngle4d.angle % (java.lang.Math.PI * 2) : axisAngle4d.angle) % (java.lang.Math.PI * 2))) {
            return false;
        }
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(axisAngle4d.x)) {
            return false;
        }
        if (Double.doubleToLongBits(this.y) != Double.doubleToLongBits(axisAngle4d.y)) {
            return false;
        }
        return Double.doubleToLongBits(this.z) == Double.doubleToLongBits(axisAngle4d.z);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

