/*
 * Decompiled with CFR 0.152.
 */
package carpet.logging;

import carpet.CarpetServer;
import carpet.CarpetSettings;
import carpet.logging.LoggerRegistry;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2554;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class Logger {
    private Map<String, String> subscribedOnlinePlayers = new HashMap<String, String>();
    private Map<String, String> subscribedOfflinePlayers = new HashMap<String, String>();
    private String logName;
    private String default_option;
    private String[] options;
    private Field acceleratorField;
    private boolean strictOptions;

    static Logger stardardLogger(String logName, String def, String[] options) {
        return Logger.stardardLogger(logName, def, options, false);
    }

    static Logger stardardLogger(String logName, String def, String[] options, boolean strictOptions) {
        try {
            return new Logger(LoggerRegistry.class.getField("__" + logName), logName, def, options, strictOptions);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Failed to create logger " + logName);
        }
    }

    @Deprecated
    public Logger(Field acceleratorField, String logName, String def, String[] options) {
        this(acceleratorField, logName, def, options, false);
    }

    public Logger(Field acceleratorField, String logName, String def, String[] options, boolean strictOptions) {
        this.acceleratorField = acceleratorField;
        this.logName = logName;
        this.default_option = def;
        this.options = options;
        this.strictOptions = strictOptions;
        if (acceleratorField == null) {
            CarpetSettings.LOG.error("[CM] Logger " + this.getLogName() + " is missing a specified accelerator");
        }
    }

    public String getDefault() {
        return this.default_option;
    }

    public String[] getOptions() {
        if (this.options == null) {
            return new String[0];
        }
        return this.options;
    }

    public String getLogName() {
        return this.logName;
    }

    public void addPlayer(String playerName, String option) {
        if (this.playerFromName(playerName) != null) {
            this.subscribedOnlinePlayers.put(playerName, option);
        } else {
            this.subscribedOfflinePlayers.put(playerName, option);
        }
        LoggerRegistry.setAccess(this);
    }

    public void removePlayer(String playerName) {
        this.subscribedOnlinePlayers.remove(playerName);
        this.subscribedOfflinePlayers.remove(playerName);
        LoggerRegistry.setAccess(this);
    }

    public boolean hasOnlineSubscribers() {
        return this.subscribedOnlinePlayers.size() > 0;
    }

    public void serverStopped() {
        this.subscribedOnlinePlayers.clear();
        this.subscribedOfflinePlayers.clear();
    }

    public Field getField() {
        return this.acceleratorField;
    }

    public void log(lMessage messagePromise) {
        for (Map.Entry<String, String> en : this.subscribedOnlinePlayers.entrySet()) {
            class_2554[] messages;
            class_3222 player = this.playerFromName(en.getKey());
            if (player == null || (messages = messagePromise.get(en.getValue(), (class_1657)player)) == null) continue;
            this.sendPlayerMessage(player, messages);
        }
    }

    public void log(lMessageIgnorePlayer messagePromise) {
        HashMap<String, class_2554[]> cannedMessages = new HashMap<String, class_2554[]>();
        for (Map.Entry<String, String> en : this.subscribedOnlinePlayers.entrySet()) {
            class_2554[] messages;
            class_3222 player = this.playerFromName(en.getKey());
            if (player == null) continue;
            String option = en.getValue();
            if (!cannedMessages.containsKey(option)) {
                cannedMessages.put(option, messagePromise.get(option));
            }
            if ((messages = (class_2554[])cannedMessages.get(option)) == null) continue;
            this.sendPlayerMessage(player, messages);
        }
    }

    public void log(Supplier<class_2554[]> messagePromise) {
        class_2554[] cannedMessages = null;
        for (Map.Entry<String, String> en : this.subscribedOnlinePlayers.entrySet()) {
            class_3222 player = this.playerFromName(en.getKey());
            if (player == null) continue;
            if (cannedMessages == null) {
                cannedMessages = messagePromise.get();
            }
            this.sendPlayerMessage(player, cannedMessages);
        }
    }

    public void sendPlayerMessage(class_3222 player, class_2554 ... messages) {
        Arrays.stream(messages).forEach(message -> player.method_9203((class_2561)message, class_156.field_25140));
    }

    protected class_3222 playerFromName(String name) {
        return CarpetServer.minecraft_server.method_3760().method_14566(name);
    }

    public void onPlayerConnect(class_1657 player, boolean firstTime) {
        HashSet<String> loggingOptions;
        String playerName = player.method_5477().getString();
        if (this.subscribedOfflinePlayers.containsKey(playerName)) {
            this.subscribedOnlinePlayers.put(playerName, this.subscribedOfflinePlayers.get(playerName));
            this.subscribedOfflinePlayers.remove(playerName);
        } else if (firstTime && (loggingOptions = new HashSet<String>(Arrays.asList(CarpetSettings.defaultLoggers.split(",")))).contains(this.getLogName())) {
            LoggerRegistry.subscribePlayer(playerName, this.getLogName(), this.getDefault());
        }
        LoggerRegistry.setAccess(this);
    }

    public void onPlayerDisconnect(class_1657 player) {
        String playerName = player.method_5477().getString();
        if (this.subscribedOnlinePlayers.containsKey(playerName)) {
            this.subscribedOfflinePlayers.put(playerName, this.subscribedOnlinePlayers.get(playerName));
            this.subscribedOnlinePlayers.remove(playerName);
        }
        LoggerRegistry.setAccess(this);
    }

    public String getAcceptedOption(String arg) {
        if (this.options != null && Arrays.asList(this.options).contains(arg)) {
            return arg;
        }
        return null;
    }

    public boolean isOptionValid(String option) {
        if (this.strictOptions) {
            return Arrays.asList(this.options).contains(option);
        }
        return true;
    }

    @FunctionalInterface
    public static interface lMessage {
        public class_2554[] get(String var1, class_1657 var2);
    }

    @FunctionalInterface
    public static interface lMessageIgnorePlayer {
        public class_2554[] get(String var1);
    }
}

