/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.annotation;

import carpet.script.LazyValue;
import carpet.script.value.EntityValue;
import carpet.script.value.FormattedTextValue;
import carpet.script.value.NBTSerializableValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import carpet.script.value.ValueConversions;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4208;
import org.apache.commons.lang3.ClassUtils;

public final class OutputConverter<T> {
    private static final Map<Class<?>, OutputConverter<?>> byResult = new HashMap();
    private static final OutputConverter<Value> VALUE = new OutputConverter<Value>(v -> (c, t) -> v);
    private final Function<T, LazyValue> converter;

    private OutputConverter(Function<T, LazyValue> converter) {
        this.converter = converter;
    }

    public static <T> OutputConverter<T> get(Class<T> returnType) {
        if (Value.class.isAssignableFrom(returnType)) {
            return VALUE;
        }
        returnType = ClassUtils.primitiveToWrapper(returnType);
        return Objects.requireNonNull(byResult.get(returnType), "Unregistered output type: " + returnType + ". Register in OutputConverter");
    }

    public LazyValue convert(T input) {
        return input == null ? LazyValue.NULL : this.converter.apply(input);
    }

    public static <T> void register(Class<T> inputType, Function<T, LazyValue> converter) {
        OutputConverter<T> instance = new OutputConverter<T>(converter);
        if (byResult.containsKey(inputType)) {
            throw new IllegalArgumentException(inputType + " already has a registered OutputConverter");
        }
        byResult.put(inputType, instance);
    }

    public static <T> void registerToValue(Class<T> inputType, Function<T, Value> converter) {
        OutputConverter<T> instance = new OutputConverter<T>(converter.andThen(v -> (c, t) -> v));
        if (byResult.containsKey(inputType)) {
            throw new IllegalArgumentException(inputType + " already has a registered OutputConverter");
        }
        byResult.put(inputType, instance);
    }

    static {
        OutputConverter.register(LazyValue.class, Function.identity());
        OutputConverter.register(Boolean.class, v -> v != false ? LazyValue.TRUE : LazyValue.FALSE);
        OutputConverter.register(Void.TYPE, v -> LazyValue.NULL);
        OutputConverter.registerToValue(Integer.class, NumericValue::of);
        OutputConverter.registerToValue(Double.class, NumericValue::of);
        OutputConverter.registerToValue(Float.class, NumericValue::of);
        OutputConverter.registerToValue(Long.class, NumericValue::of);
        OutputConverter.registerToValue(String.class, StringValue::new);
        OutputConverter.registerToValue(class_1297.class, EntityValue::new);
        OutputConverter.registerToValue(class_2561.class, FormattedTextValue::new);
        OutputConverter.registerToValue(class_2520.class, NBTSerializableValue::new);
        OutputConverter.registerToValue(class_2338.class, ValueConversions::of);
        OutputConverter.registerToValue(class_243.class, ValueConversions::of);
        OutputConverter.registerToValue(class_1799.class, ValueConversions::of);
        OutputConverter.registerToValue(class_2960.class, ValueConversions::of);
        OutputConverter.registerToValue(class_4208.class, ValueConversions::of);
    }
}

