/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.api;

import carpet.script.CarpetContext;
import carpet.script.Context;
import carpet.script.Expression;
import carpet.script.Fluff;
import carpet.script.LazyValue;
import carpet.script.argument.BlockArgument;
import carpet.script.argument.Vector3Argument;
import carpet.script.exception.BreakStatement;
import carpet.script.exception.ContinueStatement;
import carpet.script.exception.InternalExpressionException;
import carpet.script.value.BlockValue;
import carpet.script.value.LazyListValue;
import carpet.script.value.ListValue;
import carpet.script.value.NumericValue;
import carpet.script.value.Value;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3218;
import net.minecraft.class_3532;

public class BlockIterators {
    public static void apply(Expression expression) {
        expression.addLazyFunction("scan", (c, t, llv) -> {
            if (llv.size() < 3) {
                throw new InternalExpressionException("'scan' needs many more arguments");
            }
            List<Value> lv = Fluff.AbstractFunction.unpackLazy(llv.subList(0, llv.size() - 1), c, Context.NONE);
            CarpetContext cc = (CarpetContext)c;
            BlockArgument centerLocator = BlockArgument.findIn(cc, lv, 0);
            Vector3Argument rangeLocator = Vector3Argument.findIn(lv, centerLocator.offset);
            class_2338 center = centerLocator.block.getPos();
            class_2382 range = rangeLocator.fromBlock ? new class_2382(Math.abs(rangeLocator.vec.field_1352 - (double)center.method_10263()), Math.abs(rangeLocator.vec.field_1351 - (double)center.method_10264()), Math.abs(rangeLocator.vec.field_1350 - (double)center.method_10260())) : new class_2382(Math.abs(rangeLocator.vec.field_1352), Math.abs(rangeLocator.vec.field_1351), Math.abs(rangeLocator.vec.field_1350));
            class_2382 upperRange = range;
            if (lv.size() > rangeLocator.offset + 1) {
                rangeLocator = Vector3Argument.findIn(lv, rangeLocator.offset);
                upperRange = rangeLocator.fromBlock ? new class_2382(Math.abs(rangeLocator.vec.field_1352 - (double)center.method_10263()), Math.abs(rangeLocator.vec.field_1351 - (double)center.method_10264()), Math.abs(rangeLocator.vec.field_1350 - (double)center.method_10260())) : new class_2382(Math.abs(rangeLocator.vec.field_1352), Math.abs(rangeLocator.vec.field_1351), Math.abs(rangeLocator.vec.field_1350));
            }
            if (llv.size() != rangeLocator.offset + 1) {
                throw new InternalExpressionException("'scan' takes two, or three block positions, and an expression: " + lv.size() + " " + rangeLocator.offset);
            }
            LazyValue expr = (LazyValue)llv.get(rangeLocator.offset);
            int cx = center.method_10263();
            int cy = center.method_10264();
            int cz = center.method_10260();
            int xrange = range.method_10263();
            int yrange = range.method_10264();
            int zrange = range.method_10260();
            int xprange = upperRange.method_10263();
            int yprange = upperRange.method_10264();
            int zprange = upperRange.method_10260();
            LazyValue _x = c.getVariable("_x");
            LazyValue _y = c.getVariable("_y");
            LazyValue _z = c.getVariable("_z");
            LazyValue __ = c.getVariable("_");
            int sCount = 0;
            block3: for (int y = cy - yrange; y <= cy + yprange; ++y) {
                int yFinal = y;
                c.setVariable("_y", (c_, t_) -> new NumericValue(yFinal).bindTo("_y"));
                for (int x = cx - xrange; x <= cx + xprange; ++x) {
                    int xFinal = x;
                    c.setVariable("_x", (c_, t_) -> new NumericValue(xFinal).bindTo("_x"));
                    for (int z = cz - zrange; z <= cz + zprange; ++z) {
                        Value result;
                        int zFinal = z;
                        c.setVariable("_z", (c_, t_) -> new NumericValue(zFinal).bindTo("_z"));
                        Value blockValue = BlockValue.fromCoords((CarpetContext)c, xFinal, yFinal, zFinal).bindTo("_");
                        c.setVariable("_", (cc_, t_c) -> blockValue);
                        try {
                            result = expr.evalValue((Context)c, (Context.Type)((Object)t));
                        }
                        catch (ContinueStatement notIgnored) {
                            result = notIgnored.retval;
                        }
                        catch (BreakStatement notIgnored) {
                            break block3;
                        }
                        if (t == Context.VOID || !result.getBoolean()) continue;
                        ++sCount;
                    }
                }
            }
            c.setVariable("_x", _x);
            c.setVariable("_y", _y);
            c.setVariable("_z", _z);
            c.setVariable("_", __);
            int finalSCount = sCount;
            return (c_, t_) -> new NumericValue(finalSCount);
        });
        expression.addLazyFunction("volume", (c, t, llv) -> {
            CarpetContext cc = (CarpetContext)c;
            if (llv.size() < 3) {
                throw new InternalExpressionException("'volume' needs many more arguments");
            }
            List<Value> lv = Fluff.AbstractFunction.unpackLazy(llv.subList(0, llv.size() - 1), c, Context.NONE);
            BlockArgument pos1Locator = BlockArgument.findIn(cc, lv, 0);
            BlockArgument pos2Locator = BlockArgument.findIn(cc, lv, pos1Locator.offset);
            class_2338 pos1 = pos1Locator.block.getPos();
            class_2338 pos2 = pos2Locator.block.getPos();
            int x1 = pos1.method_10263();
            int y1 = pos1.method_10264();
            int z1 = pos1.method_10260();
            int x2 = pos2.method_10263();
            int y2 = pos2.method_10264();
            int z2 = pos2.method_10260();
            int minx = Math.min(x1, x2);
            int miny = Math.min(y1, y2);
            int minz = Math.min(z1, z2);
            int maxx = Math.max(x1, x2);
            int maxy = Math.max(y1, y2);
            int maxz = Math.max(z1, z2);
            LazyValue expr = (LazyValue)llv.get(pos2Locator.offset);
            LazyValue _x = c.getVariable("_x");
            LazyValue _y = c.getVariable("_y");
            LazyValue _z = c.getVariable("_z");
            LazyValue __ = c.getVariable("_");
            int sCount = 0;
            block3: for (int y = miny; y <= maxy; ++y) {
                int yFinal = y;
                c.setVariable("_y", (c_, t_) -> new NumericValue(yFinal).bindTo("_y"));
                for (int x = minx; x <= maxx; ++x) {
                    int xFinal = x;
                    c.setVariable("_x", (c_, t_) -> new NumericValue(xFinal).bindTo("_x"));
                    for (int z = minz; z <= maxz; ++z) {
                        Value result;
                        int zFinal = z;
                        c.setVariable("_z", (c_, t_) -> new NumericValue(zFinal).bindTo("_z"));
                        Value blockValue = BlockValue.fromCoords((CarpetContext)c, xFinal, yFinal, zFinal).bindTo("_");
                        c.setVariable("_", (cc_, t_c) -> blockValue);
                        try {
                            result = expr.evalValue((Context)c, (Context.Type)((Object)t));
                        }
                        catch (ContinueStatement notIgnored) {
                            result = notIgnored.retval;
                        }
                        catch (BreakStatement notIgnored) {
                            break block3;
                        }
                        if (t == Context.VOID || !result.getBoolean()) continue;
                        ++sCount;
                    }
                }
            }
            c.setVariable("_x", _x);
            c.setVariable("_y", _y);
            c.setVariable("_z", _z);
            c.setVariable("_", __);
            int finalSCount = sCount;
            return (c_, t_) -> new NumericValue(finalSCount);
        });
        expression.addContextFunction("neighbours", -1, (c, t, lv) -> {
            class_2338 center = BlockArgument.findIn((CarpetContext)((CarpetContext)c), (List<Value>)lv, (int)0).block.getPos();
            class_3218 world = ((CarpetContext)c).s.method_9225();
            ArrayList<Value> neighbours = new ArrayList<Value>();
            neighbours.add(new BlockValue(null, world, center.method_10084()));
            neighbours.add(new BlockValue(null, world, center.method_10074()));
            neighbours.add(new BlockValue(null, world, center.method_10095()));
            neighbours.add(new BlockValue(null, world, center.method_10072()));
            neighbours.add(new BlockValue(null, world, center.method_10078()));
            neighbours.add(new BlockValue(null, world, center.method_10067()));
            return ListValue.wrap(neighbours);
        });
        expression.addContextFunction("rect", -1, (c, t, lv) -> {
            int smaxz;
            int smaxy;
            int smaxx;
            int sminz;
            int sminy;
            int sminx;
            final CarpetContext cc = (CarpetContext)c;
            BlockArgument cposLocator = BlockArgument.findIn(cc, lv, 0);
            class_2338 cpos = cposLocator.block.getPos();
            final int cx = cpos.method_10263();
            final int cy = cpos.method_10264();
            final int cz = cpos.method_10260();
            if (lv.size() > cposLocator.offset) {
                Vector3Argument diffLocator = Vector3Argument.findIn(lv, cposLocator.offset);
                if (diffLocator.fromBlock) {
                    sminx = class_3532.method_15357((double)Math.abs(diffLocator.vec.field_1352 - (double)cx));
                    sminy = class_3532.method_15357((double)Math.abs(diffLocator.vec.field_1351 - (double)cx));
                    sminz = class_3532.method_15357((double)Math.abs(diffLocator.vec.field_1350 - (double)cx));
                } else {
                    sminx = class_3532.method_15357((double)Math.abs(diffLocator.vec.field_1352));
                    sminy = class_3532.method_15357((double)Math.abs(diffLocator.vec.field_1351));
                    sminz = class_3532.method_15357((double)Math.abs(diffLocator.vec.field_1350));
                }
                if (lv.size() > diffLocator.offset) {
                    Vector3Argument posDiff = Vector3Argument.findIn(lv, diffLocator.offset);
                    if (posDiff.fromBlock) {
                        smaxx = class_3532.method_15357((double)Math.abs(posDiff.vec.field_1352 - (double)cx));
                        smaxy = class_3532.method_15357((double)Math.abs(posDiff.vec.field_1351 - (double)cx));
                        smaxz = class_3532.method_15357((double)Math.abs(posDiff.vec.field_1350 - (double)cx));
                    } else {
                        smaxx = class_3532.method_15357((double)Math.abs(posDiff.vec.field_1352));
                        smaxy = class_3532.method_15357((double)Math.abs(posDiff.vec.field_1351));
                        smaxz = class_3532.method_15357((double)Math.abs(posDiff.vec.field_1350));
                    }
                } else {
                    smaxx = sminx;
                    smaxy = sminy;
                    smaxz = sminz;
                }
            } else {
                sminx = 1;
                sminy = 1;
                sminz = 1;
                smaxx = 1;
                smaxy = 1;
                smaxz = 1;
            }
            return new LazyListValue(){
                final int minx;
                final int miny;
                final int minz;
                final int maxx;
                final int maxy;
                final int maxz;
                int x;
                int y;
                int z;
                {
                    this.minx = cx - sminx;
                    this.miny = cy - sminy;
                    this.minz = cz - sminz;
                    this.maxx = cx + smaxx;
                    this.maxy = cy + smaxy;
                    this.maxz = cz + smaxz;
                    this.reset();
                }

                @Override
                public boolean hasNext() {
                    return this.y <= this.maxy;
                }

                @Override
                public Value next() {
                    BlockValue r = BlockValue.fromCoords(cc, this.x, this.y, this.z);
                    ++this.x;
                    if (this.x > this.maxx) {
                        this.x = this.minx;
                        ++this.z;
                        if (this.z > this.maxz) {
                            this.z = this.minz;
                            ++this.y;
                        }
                    }
                    return r;
                }

                @Override
                public void fatality() {
                    super.fatality();
                }

                @Override
                public void reset() {
                    this.x = this.minx;
                    this.y = this.miny;
                    this.z = this.minz;
                }

                @Override
                public String getString() {
                    return String.format(Locale.ROOT, "rect[(%d,%d,%d),..,(%d,%d,%d)]", this.minx, this.miny, this.minz, this.maxx, this.maxy, this.maxz);
                }
            };
        });
        expression.addContextFunction("diamond", -1, (c, t, lv) -> {
            int height;
            int width;
            int cz;
            int cy;
            int cx;
            CarpetContext cc;
            block6: {
                cc = (CarpetContext)c;
                BlockArgument cposLocator = BlockArgument.findIn((CarpetContext)c, lv, 0);
                class_2338 cpos = cposLocator.block.getPos();
                try {
                    cx = cpos.method_10263();
                    cy = cpos.method_10264();
                    cz = cpos.method_10260();
                    if (lv.size() == cposLocator.offset) {
                        ListValue retval = ListValue.of(BlockValue.fromCoords(cc, cx, cy - 1, cz), BlockValue.fromCoords(cc, cx, cy, cz), BlockValue.fromCoords(cc, cx - 1, cy, cz), BlockValue.fromCoords(cc, cx, cy, cz - 1), BlockValue.fromCoords(cc, cx + 1, cy, cz), BlockValue.fromCoords(cc, cx, cy, cz + 1), BlockValue.fromCoords(cc, cx, cy + 1, cz));
                        return retval;
                    }
                    if (lv.size() == 1 + cposLocator.offset) {
                        width = (int)((NumericValue)lv.get(cposLocator.offset)).getLong();
                        height = 0;
                        break block6;
                    }
                    if (lv.size() == 2 + cposLocator.offset) {
                        width = (int)((NumericValue)lv.get(cposLocator.offset)).getLong();
                        height = (int)((NumericValue)lv.get(cposLocator.offset + 1)).getLong();
                        break block6;
                    }
                    throw new InternalExpressionException("Incorrect number of arguments for 'diamond'");
                }
                catch (ClassCastException exc) {
                    throw new InternalExpressionException("Attempted to pass a non-number to 'diamond'");
                }
            }
            if (height == 0) {
                return new LazyListValue(){
                    int curradius;
                    int curpos;
                    {
                        this.reset();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.curradius <= width;
                    }

                    @Override
                    public Value next() {
                        if (this.curradius == 0) {
                            this.curradius = 1;
                            return BlockValue.fromCoords(cc, cx, cy, cz);
                        }
                        BlockValue block = BlockValue.fromCoords(cc, cx + (this.curradius - Math.abs(this.curpos - 2 * this.curradius)), cy, cz - this.curradius + Math.abs(Math.abs(this.curpos - this.curradius) % (4 * this.curradius) - 2 * this.curradius));
                        ++this.curpos;
                        if (this.curpos >= this.curradius * 4) {
                            ++this.curradius;
                            this.curpos = 0;
                        }
                        return block;
                    }

                    @Override
                    public void reset() {
                        this.curradius = 0;
                        this.curpos = 0;
                    }

                    @Override
                    public String getString() {
                        return String.format(Locale.ROOT, "diamond[(%d,%d,%d),%d,0]", cx, cy, cz, width);
                    }
                };
            }
            return new LazyListValue(){
                int curradius;
                int curpos;
                int curheight;
                {
                    this.reset();
                }

                @Override
                public boolean hasNext() {
                    return this.curheight <= height;
                }

                @Override
                public Value next() {
                    if (this.curheight == -height || this.curheight == height) {
                        return BlockValue.fromCoords(cc, cx, cy + this.curheight++, cz);
                    }
                    if (this.curradius == 0) {
                        ++this.curradius;
                        return BlockValue.fromCoords(cc, cx, cy + this.curheight, cz);
                    }
                    BlockValue block = BlockValue.fromCoords(cc, cx + (this.curradius - Math.abs(this.curpos - 2 * this.curradius)), cy + this.curheight, cz - this.curradius + Math.abs(Math.abs(this.curpos - this.curradius) % (4 * this.curradius) - 2 * this.curradius));
                    ++this.curpos;
                    if (this.curpos >= this.curradius * 4) {
                        ++this.curradius;
                        this.curpos = 0;
                        if (this.curradius > width - Math.abs(width * this.curheight / height)) {
                            ++this.curheight;
                            this.curradius = 0;
                            this.curpos = 0;
                        }
                    }
                    return block;
                }

                @Override
                public void reset() {
                    this.curradius = 0;
                    this.curpos = 0;
                    this.curheight = -height;
                }

                @Override
                public String getString() {
                    return String.format(Locale.ROOT, "diamond[(%d,%d,%d),%d,%d]", cx, cy, cz, width, height);
                }
            };
        });
    }
}

