/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.api;

import carpet.fakes.IngredientInterface;
import carpet.fakes.RecipeManagerInterface;
import carpet.script.CarpetContext;
import carpet.script.Context;
import carpet.script.Expression;
import carpet.script.argument.FunctionArgument;
import carpet.script.bundled.Module;
import carpet.script.exception.InternalExpressionException;
import carpet.script.exception.ThrowStatement;
import carpet.script.exception.Throwables;
import carpet.script.utils.InputValidator;
import carpet.script.value.BooleanValue;
import carpet.script.value.EntityValue;
import carpet.script.value.FormattedTextValue;
import carpet.script.value.FunctionValue;
import carpet.script.value.ListValue;
import carpet.script.value.NBTSerializableValue;
import carpet.script.value.NumericValue;
import carpet.script.value.ScreenValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import carpet.script.value.ValueConversions;
import com.google.common.collect.Sets;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1860;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_1874;
import net.minecraft.class_1937;
import net.minecraft.class_2290;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2653;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3956;
import net.minecraft.class_3972;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6885;

public class Inventories {
    public static void apply(Expression expression) {
        expression.addUnaryFunction("stack_limit", v -> new NumericValue(NBTSerializableValue.parseItem(v.getString()).method_9785().method_7882()));
        expression.addUnaryFunction("item_category", v -> {
            class_2290 item = NBTSerializableValue.parseItem(v.getString());
            class_1761 ig = item.method_9785().method_7859();
            return ig == null ? Value.NULL : new StringValue(ig.method_7751());
        });
        expression.addContextFunction("item_list", -1, (c, t, lv) -> {
            String tag;
            if (lv.size() == 0) {
                return ListValue.wrap(class_2378.field_11142.method_10235().stream().map(ValueConversions::of).collect(Collectors.toList()));
            }
            CarpetContext cc = (CarpetContext)c;
            class_2378 items = cc.s.method_9211().method_30611().method_30530(class_2378.field_25108);
            Optional itemTag = items.method_40266(class_6862.method_40092((class_5321)class_2378.field_25108, (class_2960)InputValidator.identifierOf(tag = ((Value)lv.get(0)).getString())));
            if (itemTag.isEmpty()) {
                return Value.NULL;
            }
            return ListValue.wrap(((class_6885.class_6888)itemTag.get()).method_40239().map(b -> ValueConversions.of(items.method_10221((Object)((class_1792)b.comp_349())))).collect(Collectors.toList()));
        });
        expression.addContextFunction("item_tags", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            class_2378 blocks = cc.s.method_9211().method_30611().method_30530(class_2378.field_25108);
            if (lv.size() == 0) {
                return ListValue.wrap(blocks.method_40273().map(ValueConversions::of).collect(Collectors.toList()));
            }
            class_1792 item = NBTSerializableValue.parseItem(((Value)lv.get(0)).getString()).method_9785();
            if (lv.size() == 1) {
                return ListValue.wrap(blocks.method_40272().filter(e -> ((class_6885.class_6888)e.getSecond()).method_40239().anyMatch(h -> h.comp_349() == item)).map(e -> ValueConversions.of((class_6862)e.getFirst())).collect(Collectors.toList()));
            }
            String tag = ((Value)lv.get(1)).getString();
            Optional tagSet = blocks.method_40266(class_6862.method_40092((class_5321)class_2378.field_25108, (class_2960)InputValidator.identifierOf(tag)));
            if (tagSet.isEmpty()) {
                return Value.NULL;
            }
            return BooleanValue.of(((class_6885.class_6888)tagSet.get()).method_40239().anyMatch(h -> h.comp_349() == item));
        });
        expression.addContextFunction("recipe_data", -1, (c, t, lv) -> {
            List<class_1860<?>> recipes;
            CarpetContext cc = (CarpetContext)c;
            if (lv.size() < 1) {
                throw new InternalExpressionException("'recipe_data' requires at least one argument");
            }
            String recipeName = ((Value)lv.get(0)).getString();
            class_3956 type = class_3956.field_17545;
            if (lv.size() > 1) {
                String recipeType = ((Value)lv.get(1)).getString();
                type = (class_3956)class_2378.field_17597.method_10223(InputValidator.identifierOf(recipeType));
            }
            if ((recipes = ((RecipeManagerInterface)cc.s.method_9211().method_3772()).getAllMatching(type, InputValidator.identifierOf(recipeName))).isEmpty()) {
                return Value.NULL;
            }
            ArrayList<Value> recipesOutput = new ArrayList<Value>();
            for (class_1860<?> recipe : recipes) {
                class_1799 result = recipe.method_8110();
                ArrayList<Value> ingredientValue = new ArrayList<Value>();
                recipe.method_8117().forEach(ingredient -> {
                    List<Collection<class_1799>> stacks = ((IngredientInterface)ingredient).getRecipeStacks();
                    if (stacks.isEmpty()) {
                        ingredientValue.add(Value.NULL);
                    } else {
                        ArrayList<Value> alternatives = new ArrayList<Value>();
                        stacks.forEach(col -> col.stream().map(ValueConversions::of).forEach(alternatives::add));
                        ingredientValue.add(ListValue.wrap(alternatives));
                    }
                });
                ListValue recipeSpec = recipe instanceof class_1869 ? ListValue.of(new StringValue("shaped"), new NumericValue(((class_1869)recipe).method_8150()), new NumericValue(((class_1869)recipe).method_8158())) : (recipe instanceof class_1867 ? ListValue.of(new StringValue("shapeless")) : (recipe instanceof class_1874 ? ListValue.of(new StringValue("smelting"), new NumericValue(((class_1874)recipe).method_8167()), new NumericValue(((class_1874)recipe).method_8171())) : (recipe instanceof class_3972 ? ListValue.of(new StringValue("cutting")) : (recipe instanceof class_1852 ? ListValue.of(new StringValue("special")) : ListValue.of(new StringValue("custom"))))));
                recipesOutput.add(ListValue.of(ValueConversions.of(result), ListValue.wrap(ingredientValue), recipeSpec));
            }
            return ListValue.wrap(recipesOutput);
        });
        expression.addUnaryFunction("crafting_remaining_item", v -> {
            String itemStr = v.getString();
            class_2960 id = InputValidator.identifierOf(itemStr);
            class_1792 item = (class_1792)class_2378.field_11142.method_17966(id).orElseThrow(() -> new ThrowStatement(itemStr, Throwables.UNKNOWN_ITEM));
            if (!item.method_7857()) {
                return Value.NULL;
            }
            return new StringValue(NBTSerializableValue.nameFromRegistryId(class_2378.field_11142.method_10221((Object)item.method_7858())));
        });
        expression.addContextFunction("inventory_size", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            NBTSerializableValue.InventoryLocator inventoryLocator = NBTSerializableValue.locateInventory(cc, lv, 0);
            if (inventoryLocator == null) {
                return Value.NULL;
            }
            return new NumericValue(inventoryLocator.inventory().method_5439());
        });
        expression.addContextFunction("inventory_has_items", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            NBTSerializableValue.InventoryLocator inventoryLocator = NBTSerializableValue.locateInventory(cc, lv, 0);
            if (inventoryLocator == null) {
                return Value.NULL;
            }
            return BooleanValue.of(!inventoryLocator.inventory().method_5442());
        });
        expression.addContextFunction("inventory_get", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            NBTSerializableValue.InventoryLocator inventoryLocator = NBTSerializableValue.locateInventory(cc, lv, 0);
            if (inventoryLocator == null) {
                return Value.NULL;
            }
            if (lv.size() == inventoryLocator.offset()) {
                ArrayList<Value> fullInventory = new ArrayList<Value>();
                int maxi = inventoryLocator.inventory().method_5439();
                for (int i = 0; i < maxi; ++i) {
                    fullInventory.add(ValueConversions.of(inventoryLocator.inventory().method_5438(i)));
                }
                return ListValue.wrap(fullInventory);
            }
            int slot = (int)NumericValue.asNumber((Value)lv.get(inventoryLocator.offset())).getLong();
            if ((slot = NBTSerializableValue.validateSlot(slot, inventoryLocator.inventory())) == inventoryLocator.inventory().method_5439()) {
                return Value.NULL;
            }
            return ValueConversions.of(inventoryLocator.inventory().method_5438(slot));
        });
        expression.addContextFunction("inventory_set", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            NBTSerializableValue.InventoryLocator inventoryLocator = NBTSerializableValue.locateInventory(cc, lv, 0);
            if (inventoryLocator == null) {
                return Value.NULL;
            }
            if (lv.size() < inventoryLocator.offset() + 2) {
                throw new InternalExpressionException("'inventory_set' requires at least slot number and new stack size, and optional new item");
            }
            int slot = (int)NumericValue.asNumber((Value)lv.get(inventoryLocator.offset() + 0)).getLong();
            if ((slot = NBTSerializableValue.validateSlot(slot, inventoryLocator.inventory())) == inventoryLocator.inventory().method_5439()) {
                return Value.NULL;
            }
            int count = (int)NumericValue.asNumber((Value)lv.get(inventoryLocator.offset() + 1)).getLong();
            if (count == 0) {
                class_1799 removedStack = inventoryLocator.inventory().method_5441(slot);
                Inventories.syncPlayerInventory(inventoryLocator, slot);
                return ValueConversions.of(removedStack);
            }
            if (lv.size() < inventoryLocator.offset() + 3) {
                class_1799 previousStack = inventoryLocator.inventory().method_5438(slot);
                class_1799 newStack = previousStack.method_7972();
                newStack.method_7939(count);
                inventoryLocator.inventory().method_5447(slot, newStack);
                Inventories.syncPlayerInventory(inventoryLocator, slot);
                return ValueConversions.of(previousStack);
            }
            Object nbt = null;
            if (lv.size() > inventoryLocator.offset() + 3) {
                Value nbtValue = (Value)lv.get(inventoryLocator.offset() + 3);
                nbt = nbtValue instanceof NBTSerializableValue ? ((NBTSerializableValue)nbtValue).getCompoundTag() : (nbtValue.isNull() ? null : new NBTSerializableValue(nbtValue.getString()).getCompoundTag());
            }
            class_2290 newitem = NBTSerializableValue.parseItem(((Value)lv.get(inventoryLocator.offset() + 2)).getString(), nbt);
            class_1799 previousStack = inventoryLocator.inventory().method_5438(slot);
            try {
                inventoryLocator.inventory().method_5447(slot, newitem.method_9781(count, false));
                Inventories.syncPlayerInventory(inventoryLocator, slot);
            }
            catch (CommandSyntaxException e) {
                throw new InternalExpressionException(e.getMessage());
            }
            return ValueConversions.of(previousStack);
        });
        expression.addContextFunction("inventory_find", -1, (c, t, lv) -> {
            Value secondArg;
            CarpetContext cc = (CarpetContext)c;
            NBTSerializableValue.InventoryLocator inventoryLocator = NBTSerializableValue.locateInventory(cc, lv, 0);
            if (inventoryLocator == null) {
                return Value.NULL;
            }
            class_2290 itemArg = null;
            if (lv.size() > inventoryLocator.offset() && !(secondArg = (Value)lv.get(inventoryLocator.offset() + 0)).isNull()) {
                itemArg = NBTSerializableValue.parseItem(secondArg.getString());
            }
            int startIndex = 0;
            if (lv.size() > inventoryLocator.offset() + 1) {
                startIndex = (int)NumericValue.asNumber((Value)lv.get(inventoryLocator.offset() + 1)).getLong();
            }
            int maxi = inventoryLocator.inventory().method_5439();
            for (int i = startIndex = NBTSerializableValue.validateSlot(startIndex, inventoryLocator.inventory()); i < maxi; ++i) {
                class_1799 stack = inventoryLocator.inventory().method_5438(i);
                if ((itemArg != null || !stack.method_7960()) && (itemArg == null || !itemArg.method_9785().equals(stack.method_7909()))) continue;
                return new NumericValue(i);
            }
            return Value.NULL;
        });
        expression.addContextFunction("inventory_remove", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            NBTSerializableValue.InventoryLocator inventoryLocator = NBTSerializableValue.locateInventory(cc, lv, 0);
            if (inventoryLocator == null) {
                return Value.NULL;
            }
            if (lv.size() <= inventoryLocator.offset()) {
                throw new InternalExpressionException("'inventory_remove' requires at least an item to be removed");
            }
            class_2290 searchItem = NBTSerializableValue.parseItem(((Value)lv.get(inventoryLocator.offset())).getString());
            int amount = 1;
            if (lv.size() > inventoryLocator.offset() + 1) {
                amount = (int)NumericValue.asNumber((Value)lv.get(inventoryLocator.offset() + 1)).getLong();
            }
            if (amount == 1 && !inventoryLocator.inventory().method_18862((Set)Sets.newHashSet((Object[])new class_1792[]{searchItem.method_9785()})) || inventoryLocator.inventory().method_18861(searchItem.method_9785()) < amount) {
                return Value.FALSE;
            }
            int maxi = inventoryLocator.inventory().method_5439();
            for (int i = 0; i < maxi; ++i) {
                class_1799 stack = inventoryLocator.inventory().method_5438(i);
                if (stack.method_7960() || !stack.method_7909().equals(searchItem.method_9785())) continue;
                int left = stack.method_7947() - amount;
                if (left > 0) {
                    stack.method_7939(left);
                    inventoryLocator.inventory().method_5447(i, stack);
                    Inventories.syncPlayerInventory(inventoryLocator, i);
                    return Value.TRUE;
                }
                inventoryLocator.inventory().method_5441(i);
                Inventories.syncPlayerInventory(inventoryLocator, i);
                amount -= stack.method_7947();
            }
            if (amount > 0) {
                throw new InternalExpressionException("Something bad happened - cannot pull all items from inventory");
            }
            return Value.TRUE;
        });
        expression.addContextFunction("drop_item", -1, (c, t, lv) -> {
            class_1542 item;
            class_1799 droppedStack;
            CarpetContext cc = (CarpetContext)c;
            NBTSerializableValue.InventoryLocator inventoryLocator = NBTSerializableValue.locateInventory(cc, lv, 0);
            if (inventoryLocator == null) {
                return Value.NULL;
            }
            if (lv.size() == inventoryLocator.offset()) {
                throw new InternalExpressionException("Slot number is required for inventory_drop");
            }
            int slot = (int)NumericValue.asNumber((Value)lv.get(inventoryLocator.offset())).getLong();
            if ((slot = NBTSerializableValue.validateSlot(slot, inventoryLocator.inventory())) == inventoryLocator.inventory().method_5439()) {
                return Value.NULL;
            }
            int amount = 0;
            if (lv.size() > inventoryLocator.offset() + 1) {
                amount = (int)NumericValue.asNumber((Value)lv.get(inventoryLocator.offset() + 1)).getLong();
            }
            if (amount < 0) {
                throw new InternalExpressionException("Cannot throw negative number of items");
            }
            class_1799 stack = inventoryLocator.inventory().method_5438(slot);
            if (stack == null || stack.method_7960()) {
                return Value.ZERO;
            }
            if (amount == 0) {
                amount = stack.method_7947();
            }
            if ((droppedStack = inventoryLocator.inventory().method_5434(slot, amount)).method_7960()) {
                return Value.ZERO;
            }
            Object owner = inventoryLocator.owner();
            if (owner instanceof class_1657) {
                item = ((class_1657)owner).method_7329(droppedStack, false, true);
            } else if (owner instanceof class_1309) {
                class_1309 villager = (class_1309)owner;
                double double_1 = villager.method_23318() - (double)0.3f + (double)villager.method_5751();
                item = new class_1542(villager.field_6002, villager.method_23317(), double_1, villager.method_23321(), droppedStack);
                class_243 vec3d_1 = villager.method_5828(1.0f).method_1029().method_1021(0.3);
                item.method_18799(vec3d_1);
                item.method_6988();
                cc.s.method_9225().method_8649((class_1297)item);
            } else {
                class_243 point = class_243.method_24953((class_2382)inventoryLocator.position());
                item = new class_1542((class_1937)cc.s.method_9225(), point.field_1352, point.field_1351, point.field_1350, droppedStack);
                item.method_6988();
                cc.s.method_9225().method_8649((class_1297)item);
            }
            return new NumericValue(item.method_6983().method_7947());
        });
        expression.addContextFunction("create_screen", -1, (c, t, lv) -> {
            if (lv.size() < 3) {
                throw new InternalExpressionException("'create_screen' requires at least three arguments");
            }
            Value playerValue = (Value)lv.get(0);
            class_3222 player = EntityValue.getPlayerByValue(((CarpetContext)c).s.method_9211(), playerValue);
            if (player == null) {
                throw new InternalExpressionException("'create_screen' requires a valid online player as the first argument.");
            }
            String type = ((Value)lv.get(1)).getString();
            class_2561 name = FormattedTextValue.getTextByValue((Value)lv.get(2));
            FunctionValue function = null;
            if (lv.size() > 3) {
                function = FunctionArgument.findIn((Context)c, (Module)expression.module, (List<Value>)lv, (int)3, (boolean)true, (boolean)false).function;
            }
            return new ScreenValue(player, type, name, function, (Context)c);
        });
        expression.addContextFunction("close_screen", 1, (c, t, lv) -> {
            Value value = (Value)lv.get(0);
            if (!(value instanceof ScreenValue)) {
                throw new InternalExpressionException("'close_screen' requires a screen value as the first argument.");
            }
            ScreenValue screenValue = (ScreenValue)value;
            if (!screenValue.isOpen()) {
                return Value.FALSE;
            }
            screenValue.close();
            return Value.TRUE;
        });
        expression.addContextFunction("screen_property", -1, (c, t, lv) -> {
            if (lv.size() < 2) {
                throw new InternalExpressionException("'screen_property' requires at least a screen and a property name");
            }
            Object patt23759$temp = lv.get(0);
            if (!(patt23759$temp instanceof ScreenValue)) {
                throw new InternalExpressionException("'screen_property' requires a screen value as the first argument");
            }
            ScreenValue screenValue = (ScreenValue)patt23759$temp;
            String propertyName = ((Value)lv.get(1)).getString();
            if (lv.size() >= 3) {
                return screenValue.modifyProperty(propertyName, lv.subList(2, lv.size()));
            }
            return screenValue.queryProperty(propertyName);
        });
    }

    private static void syncPlayerInventory(NBTSerializableValue.InventoryLocator inventory, int int_1) {
        Object object = inventory.owner();
        if (object instanceof class_3222) {
            class_3222 player = (class_3222)object;
            if (!inventory.isEnder() && !(inventory.inventory() instanceof ScreenValue.ScreenHandlerInventory)) {
                player.field_13987.method_14364((class_2596)new class_2653(-2, 0, int_1, inventory.inventory().method_5438(int_1)));
            }
        }
    }
}

