/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.bundled;

import carpet.script.bundled.Module;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.apache.commons.io.IOUtils;

public class BundledModule
extends Module {
    private String name;
    private String code;
    private boolean library;

    public BundledModule(String name, String code, boolean isLibrary) {
        this.library = isLibrary;
        this.name = name;
        this.code = code;
    }

    public static BundledModule carpetNative(String scriptName, boolean isLibrary) {
        return BundledModule.fromPath("assets/carpet/scripts/", scriptName, isLibrary);
    }

    public static BundledModule fromPath(String path, String scriptName, boolean isLibrary) {
        return BundledModule.fromPathWithCustomName(path + scriptName + (isLibrary ? ".scl" : ".sc"), scriptName, isLibrary);
    }

    public static BundledModule fromPathWithCustomName(String fullPath, String customName, boolean isLibrary) {
        BundledModule module = new BundledModule(null, null, isLibrary);
        try {
            module.name = customName.toLowerCase(Locale.ROOT);
            module.code = IOUtils.toString((InputStream)BundledModule.class.getClassLoader().getResourceAsStream(fullPath), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException | NullPointerException e) {
            module.name = null;
            module.code = null;
        }
        return module;
    }

    @Override
    public boolean isLibrary() {
        return this.library;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getCode() {
        return this.code;
    }
}

