/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.utils;

import java.util.function.Supplier;

public class GlocalFlag
extends ThreadLocal<Boolean> {
    private final boolean initial;

    public GlocalFlag(boolean initial) {
        this.initial = initial;
    }

    @Override
    public Boolean initialValue() {
        return this.initial;
    }

    public <T> T getWhileDisabled(Supplier<T> action) {
        return this.whileValueReturn(!this.initial, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T whileValueReturn(boolean what, Supplier<T> action) {
        T result;
        boolean previous;
        GlocalFlag glocalFlag = this;
        synchronized (glocalFlag) {
            previous = (Boolean)this.get();
            this.set(what);
        }
        try {
            result = action.get();
        }
        finally {
            this.set(previous);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runIfEnabled(Runnable action) {
        GlocalFlag glocalFlag = this;
        synchronized (glocalFlag) {
            if ((Boolean)this.get() != this.initial) {
                return false;
            }
            this.set(!this.initial);
        }
        try {
            action.run();
        }
        finally {
            this.set(this.initial);
        }
        return true;
    }
}

