/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.utils;

import carpet.CarpetSettings;
import carpet.script.utils.ShapeDispatcher;
import carpet.utils.CarpetProfiler;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.class_1160;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_757;

public class ShapesRenderer {
    private final Map<class_5321<class_1937>, Long2ObjectOpenHashMap<RenderedShape<? extends ShapeDispatcher.ExpiringShape>>> shapes;
    private final Map<class_5321<class_1937>, Long2ObjectOpenHashMap<RenderedShape<? extends ShapeDispatcher.ExpiringShape>>> labels;
    private class_310 client;
    private Map<String, BiFunction<class_310, ShapeDispatcher.ExpiringShape, RenderedShape<? extends ShapeDispatcher.ExpiringShape>>> renderedShapes = new HashMap<String, BiFunction<class_310, ShapeDispatcher.ExpiringShape, RenderedShape<? extends ShapeDispatcher.ExpiringShape>>>(){
        {
            this.put("line", RenderedLine::new);
            this.put("box", RenderedBox::new);
            this.put("sphere", RenderedSphere::new);
            this.put("cylinder", RenderedCylinder::new);
            this.put("label", RenderedText::new);
        }
    };

    public ShapesRenderer(class_310 minecraftClient) {
        this.client = minecraftClient;
        this.shapes = new HashMap<class_5321<class_1937>, Long2ObjectOpenHashMap<RenderedShape<? extends ShapeDispatcher.ExpiringShape>>>();
        this.labels = new HashMap<class_5321<class_1937>, Long2ObjectOpenHashMap<RenderedShape<? extends ShapeDispatcher.ExpiringShape>>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(class_4587 matrices, class_4184 camera, float partialTick) {
        Map<class_5321<class_1937>, Long2ObjectOpenHashMap<RenderedShape<? extends ShapeDispatcher.ExpiringShape>>> map;
        CarpetProfiler.ProfilerToken token = CarpetProfiler.start_section(null, "Scarpet client", CarpetProfiler.TYPE.GENERAL);
        class_638 iWorld = this.client.field_1687;
        class_5321 dimensionType = iWorld.method_27983();
        if ((this.shapes.get(dimensionType) == null || this.shapes.get(dimensionType).isEmpty()) && (this.labels.get(dimensionType) == null || this.labels.get(dimensionType).isEmpty())) {
            return;
        }
        long currentTime = this.client.field_1687.method_8510();
        RenderSystem.disableTexture();
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.depthFunc((int)515);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.depthMask((boolean)false);
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        double cameraX = camera.method_19326().field_1352;
        double cameraY = camera.method_19326().field_1351;
        double cameraZ = camera.method_19326().field_1350;
        if (this.shapes.size() != 0) {
            map = this.shapes;
            synchronized (map) {
                this.shapes.get(dimensionType).long2ObjectEntrySet().removeIf(entry -> ((RenderedShape)entry.getValue()).isExpired(currentTime));
                class_4587 matrixStack = RenderSystem.getModelViewStack();
                matrixStack.method_22903();
                matrixStack.method_34425(matrices.method_23760().method_23761());
                RenderSystem.applyModelViewMatrix();
                RenderSystem.lineWidth((float)0.5f);
                this.shapes.get(dimensionType).values().forEach(s -> {
                    if (s.shouldRender((class_5321<class_1937>)dimensionType)) {
                        s.renderLines(matrices, tessellator, bufferBuilder, cameraX, cameraY, cameraZ, partialTick);
                    }
                });
                RenderSystem.lineWidth((float)0.1f);
                this.shapes.get(dimensionType).values().forEach(s -> {
                    if (s.shouldRender((class_5321<class_1937>)dimensionType)) {
                        s.renderFaces(tessellator, bufferBuilder, cameraX, cameraY, cameraZ, partialTick);
                    }
                });
                RenderSystem.lineWidth((float)1.0f);
                matrixStack.method_22909();
                RenderSystem.applyModelViewMatrix();
            }
        }
        if (this.labels.size() != 0) {
            map = this.labels;
            synchronized (map) {
                this.labels.get(dimensionType).long2ObjectEntrySet().removeIf(entry -> ((RenderedShape)entry.getValue()).isExpired(currentTime));
                this.labels.get(dimensionType).values().forEach(s -> {
                    if (s.shouldRender((class_5321<class_1937>)dimensionType)) {
                        s.renderLines(matrices, tessellator, bufferBuilder, cameraX, cameraY, cameraZ, partialTick);
                    }
                });
            }
        }
        RenderSystem.enableCull();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableTexture();
        CarpetProfiler.end_current_section(token);
    }

    public void addShapes(class_2499 tag) {
        CarpetProfiler.ProfilerToken token = CarpetProfiler.start_section(null, "Scarpet client", CarpetProfiler.TYPE.GENERAL);
        int count = tag.size();
        for (int i = 0; i < count; ++i) {
            this.addShape(tag.method_10602(i));
        }
        CarpetProfiler.end_current_section(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addShape(class_2487 tag) {
        ShapeDispatcher.ExpiringShape shape = ShapeDispatcher.fromTag(tag);
        if (shape == null) {
            return;
        }
        BiFunction<class_310, ShapeDispatcher.ExpiringShape, RenderedShape<? extends ShapeDispatcher.ExpiringShape>> shapeFactory = this.renderedShapes.get(tag.method_10558("shape"));
        if (shapeFactory == null) {
            CarpetSettings.LOG.info("Unrecognized shape: " + tag.method_10558("shape"));
        } else {
            Map<class_5321<class_1937>, Long2ObjectOpenHashMap<RenderedShape<? extends ShapeDispatcher.ExpiringShape>>> container;
            RenderedShape<? extends ShapeDispatcher.ExpiringShape> rshape = shapeFactory.apply(this.client, shape);
            class_5321<class_1937> dim = shape.shapeDimension;
            long key = rshape.key();
            Map<class_5321<class_1937>, Long2ObjectOpenHashMap<RenderedShape<? extends ShapeDispatcher.ExpiringShape>>> map = container = rshape.stageDeux() ? this.labels : this.shapes;
            synchronized (map) {
                RenderedShape existing = (RenderedShape)container.computeIfAbsent(dim, d -> new Long2ObjectOpenHashMap()).get(key);
                if (existing != null) {
                    existing.promoteWith(rshape);
                } else {
                    container.get(dim).put(key, rshape);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Map<class_5321<class_1937>, Long2ObjectOpenHashMap<RenderedShape<? extends ShapeDispatcher.ExpiringShape>>> map = this.shapes;
        synchronized (map) {
            this.shapes.values().forEach(Long2ObjectOpenHashMap::clear);
        }
        map = this.labels;
        synchronized (map) {
            this.labels.values().forEach(Long2ObjectOpenHashMap::clear);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renewShapes() {
        CarpetProfiler.ProfilerToken token = CarpetProfiler.start_section(null, "Scarpet client", CarpetProfiler.TYPE.GENERAL);
        Map<class_5321<class_1937>, Long2ObjectOpenHashMap<RenderedShape<? extends ShapeDispatcher.ExpiringShape>>> map = this.shapes;
        synchronized (map) {
            this.shapes.values().forEach(el -> el.values().forEach(shape -> ++shape.expiryTick));
        }
        map = this.labels;
        synchronized (map) {
            this.labels.values().forEach(el -> el.values().forEach(shape -> ++shape.expiryTick));
        }
        CarpetProfiler.end_current_section(token);
    }

    public static void drawLine(class_289 tessellator, class_287 builder, float x1, float y1, float z1, float x2, float y2, float z2, float red1, float grn1, float blu1, float alpha) {
        builder.method_1328(class_293.class_5596.field_29344, class_290.field_1576);
        builder.method_22912((double)x1, (double)y1, (double)z1).method_22915(red1, grn1, blu1, alpha).method_1344();
        builder.method_22912((double)x2, (double)y2, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
        tessellator.method_1350();
    }

    public static void drawBoxWireGLLines(class_289 tessellator, class_287 builder, float x1, float y1, float z1, float x2, float y2, float z2, boolean xthick, boolean ythick, boolean zthick, float red1, float grn1, float blu1, float alpha, float red2, float grn2, float blu2) {
        builder.method_1328(class_293.class_5596.field_29344, class_290.field_1576);
        if (xthick) {
            builder.method_22912((double)x1, (double)y1, (double)z1).method_22915(red1, grn2, blu2, alpha).method_1344();
            builder.method_22912((double)x2, (double)y1, (double)z1).method_22915(red1, grn2, blu2, alpha).method_1344();
            builder.method_22912((double)x2, (double)y2, (double)z1).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x1, (double)y2, (double)z1).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x1, (double)y1, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x2, (double)y1, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x1, (double)y2, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x2, (double)y2, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
        }
        if (ythick) {
            builder.method_22912((double)x1, (double)y1, (double)z1).method_22915(red2, grn1, blu2, alpha).method_1344();
            builder.method_22912((double)x1, (double)y2, (double)z1).method_22915(red2, grn1, blu2, alpha).method_1344();
            builder.method_22912((double)x2, (double)y1, (double)z1).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x2, (double)y2, (double)z1).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x1, (double)y2, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x1, (double)y1, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x2, (double)y1, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x2, (double)y2, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
        }
        if (zthick) {
            builder.method_22912((double)x1, (double)y1, (double)z1).method_22915(red2, grn2, blu1, alpha).method_1344();
            builder.method_22912((double)x1, (double)y1, (double)z2).method_22915(red2, grn2, blu1, alpha).method_1344();
            builder.method_22912((double)x1, (double)y2, (double)z1).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x1, (double)y2, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x2, (double)y1, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x2, (double)y1, (double)z1).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x2, (double)y2, (double)z1).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x2, (double)y2, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
        }
        tessellator.method_1350();
    }

    public static void drawBoxFaces(class_289 tessellator, class_287 builder, float x1, float y1, float z1, float x2, float y2, float z2, boolean xthick, boolean ythick, boolean zthick, float red1, float grn1, float blu1, float alpha) {
        builder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        if (xthick && ythick) {
            builder.method_22912((double)x1, (double)y1, (double)z1).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x2, (double)y1, (double)z1).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x2, (double)y2, (double)z1).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x1, (double)y2, (double)z1).method_22915(red1, grn1, blu1, alpha).method_1344();
            if (zthick) {
                builder.method_22912((double)x1, (double)y1, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
                builder.method_22912((double)x1, (double)y2, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
                builder.method_22912((double)x2, (double)y2, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
                builder.method_22912((double)x2, (double)y1, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
            }
        }
        if (zthick && ythick) {
            builder.method_22912((double)x1, (double)y1, (double)z1).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x1, (double)y2, (double)z1).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x1, (double)y2, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x1, (double)y1, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
            if (xthick) {
                builder.method_22912((double)x2, (double)y1, (double)z1).method_22915(red1, grn1, blu1, alpha).method_1344();
                builder.method_22912((double)x2, (double)y1, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
                builder.method_22912((double)x2, (double)y2, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
                builder.method_22912((double)x2, (double)y2, (double)z1).method_22915(red1, grn1, blu1, alpha).method_1344();
            }
        }
        if (zthick && xthick) {
            builder.method_22912((double)x1, (double)y1, (double)z1).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x2, (double)y1, (double)z1).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x2, (double)y1, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
            builder.method_22912((double)x1, (double)y1, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
            if (ythick) {
                builder.method_22912((double)x1, (double)y2, (double)z1).method_22915(red1, grn1, blu1, alpha).method_1344();
                builder.method_22912((double)x2, (double)y2, (double)z1).method_22915(red1, grn1, blu1, alpha).method_1344();
                builder.method_22912((double)x2, (double)y2, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
                builder.method_22912((double)x1, (double)y2, (double)z2).method_22915(red1, grn1, blu1, alpha).method_1344();
            }
        }
        tessellator.method_1350();
    }

    public static void drawCylinderWireframe(class_289 tessellator, class_287 builder, float cx, float cy, float cz, float r, float h, class_2350.class_2351 axis, int subd, boolean isFlat, float red, float grn, float blu, float alpha) {
        float step = (float)Math.PI / (float)(subd / 2);
        int num_steps180 = (int)(Math.PI / (double)step) + 1;
        int num_steps360 = (int)(Math.PI * 2 / (double)step);
        int hsteps = 1;
        float hstep = 1.0f;
        if (!isFlat) {
            hsteps = (int)Math.ceil(class_3532.method_15379((float)h) / (step * r)) + 1;
            hstep = h / (float)(hsteps - 1);
        }
        if (axis == class_2350.class_2351.field_11052) {
            for (int dh = 0; dh < hsteps; ++dh) {
                float hh = (float)dh * hstep;
                builder.method_1328(class_293.class_5596.field_29345, class_290.field_1576);
                for (int i = 0; i <= num_steps360 + 1; ++i) {
                    float theta = step * (float)i;
                    float x = r * class_3532.method_15362((float)theta);
                    float y = hh;
                    float z = r * class_3532.method_15374((float)theta);
                    builder.method_22912((double)(x + cx), (double)(y + cy), (double)(z + cz)).method_22915(red, grn, blu, alpha).method_1344();
                }
                tessellator.method_1350();
            }
            if (!isFlat) {
                for (i = 0; i <= num_steps180; ++i) {
                    builder.method_1328(class_293.class_5596.field_29345, class_290.field_1576);
                    theta = step * (float)i;
                    float x = r * class_3532.method_15362((float)theta);
                    z = r * class_3532.method_15374((float)theta);
                    builder.method_22912((double)(cx - x), (double)(cy + 0.0f), (double)(cz + z)).method_22915(red, grn, blu, alpha).method_1344();
                    builder.method_22912((double)(cx + x), (double)(cy + 0.0f), (double)(cz - z)).method_22915(red, grn, blu, alpha).method_1344();
                    builder.method_22912((double)(cx + x), (double)(cy + h), (double)(cz - z)).method_22915(red, grn, blu, alpha).method_1344();
                    builder.method_22912((double)(cx - x), (double)(cy + h), (double)(cz + z)).method_22915(red, grn, blu, alpha).method_1344();
                    builder.method_22912((double)(cx - x), (double)(cy + 0.0f), (double)(cz + z)).method_22915(red, grn, blu, alpha).method_1344();
                    tessellator.method_1350();
                }
            } else {
                builder.method_1328(class_293.class_5596.field_29344, class_290.field_1576);
                for (i = 0; i <= num_steps180; ++i) {
                    theta = step * (float)i;
                    float x = r * class_3532.method_15362((float)theta);
                    z = r * class_3532.method_15374((float)theta);
                    builder.method_22912((double)(cx - x), (double)cy, (double)(cz + z)).method_22915(red, grn, blu, alpha).method_1344();
                    builder.method_22912((double)(cx + x), (double)cy, (double)(cz - z)).method_22915(red, grn, blu, alpha).method_1344();
                }
                tessellator.method_1350();
            }
        } else if (axis == class_2350.class_2351.field_11048) {
            for (int dh = 0; dh < hsteps; ++dh) {
                float hh = (float)dh * hstep;
                builder.method_1328(class_293.class_5596.field_29345, class_290.field_1576);
                for (int i = 0; i <= num_steps360; ++i) {
                    float theta = step * (float)i;
                    float z = r * class_3532.method_15362((float)theta);
                    float x = hh;
                    float y = r * class_3532.method_15374((float)theta);
                    builder.method_22912((double)(x + cx), (double)(y + cy), (double)(z + cz)).method_22915(red, grn, blu, alpha).method_1344();
                }
                tessellator.method_1350();
            }
            if (!isFlat) {
                for (i = 0; i <= num_steps180; ++i) {
                    builder.method_1328(class_293.class_5596.field_29345, class_290.field_1576);
                    theta = step * (float)i;
                    float y = r * class_3532.method_15362((float)theta);
                    z = r * class_3532.method_15374((float)theta);
                    builder.method_22912((double)(cx + 0.0f), (double)(cy - y), (double)(cz + z)).method_22915(red, grn, blu, alpha).method_1344();
                    builder.method_22912((double)(cx + 0.0f), (double)(cy + y), (double)(cz - z)).method_22915(red, grn, blu, alpha).method_1344();
                    builder.method_22912((double)(cx + h), (double)(cy + y), (double)(cz - z)).method_22915(red, grn, blu, alpha).method_1344();
                    builder.method_22912((double)(cx + h), (double)(cy - y), (double)(cz + z)).method_22915(red, grn, blu, alpha).method_1344();
                    tessellator.method_1350();
                }
            } else {
                builder.method_1328(class_293.class_5596.field_29344, class_290.field_1576);
                for (i = 0; i <= num_steps180; ++i) {
                    theta = step * (float)i;
                    float y = r * class_3532.method_15362((float)theta);
                    z = r * class_3532.method_15374((float)theta);
                    builder.method_22912((double)cx, (double)(cy - y), (double)(cz + z)).method_22915(red, grn, blu, alpha).method_1344();
                    builder.method_22912((double)cx, (double)(cy + y), (double)(cz - z)).method_22915(red, grn, blu, alpha).method_1344();
                }
                tessellator.method_1350();
            }
        } else if (axis == class_2350.class_2351.field_11051) {
            for (int dh = 0; dh < hsteps; ++dh) {
                float hh = (float)dh * hstep;
                builder.method_1328(class_293.class_5596.field_29345, class_290.field_1576);
                for (int i = 0; i <= num_steps360; ++i) {
                    float theta = step * (float)i;
                    float y = r * class_3532.method_15362((float)theta);
                    float z = hh;
                    float x = r * class_3532.method_15374((float)theta);
                    builder.method_22912((double)(x + cx), (double)(y + cy), (double)(z + cz)).method_22915(red, grn, blu, alpha).method_1344();
                }
                tessellator.method_1350();
            }
            if (!isFlat) {
                for (i = 0; i <= num_steps180; ++i) {
                    builder.method_1328(class_293.class_5596.field_29345, class_290.field_1576);
                    theta = step * (float)i;
                    float x = r * class_3532.method_15362((float)theta);
                    y = r * class_3532.method_15374((float)theta);
                    builder.method_22912((double)(cx + x), (double)(cy - y), (double)(cz + 0.0f)).method_22915(red, grn, blu, alpha).method_1344();
                    builder.method_22912((double)(cx - x), (double)(cy + y), (double)(cz + 0.0f)).method_22915(red, grn, blu, alpha).method_1344();
                    builder.method_22912((double)(cx - x), (double)(cy + y), (double)(cz + h)).method_22915(red, grn, blu, alpha).method_1344();
                    builder.method_22912((double)(cx + x), (double)(cy - y), (double)(cz + h)).method_22915(red, grn, blu, alpha).method_1344();
                    tessellator.method_1350();
                }
            } else {
                builder.method_1328(class_293.class_5596.field_29344, class_290.field_1576);
                for (i = 0; i <= num_steps180; ++i) {
                    theta = step * (float)i;
                    float x = r * class_3532.method_15362((float)theta);
                    y = r * class_3532.method_15374((float)theta);
                    builder.method_22912((double)(cx + x), (double)(cy - y), (double)cz).method_22915(red, grn, blu, alpha).method_1344();
                    builder.method_22912((double)(cx - x), (double)(cy + y), (double)cz).method_22915(red, grn, blu, alpha).method_1344();
                }
                tessellator.method_1350();
            }
        }
    }

    public static void drawCylinderFaces(class_289 tessellator, class_287 builder, float cx, float cy, float cz, float r, float h, class_2350.class_2351 axis, int subd, boolean isFlat, float red, float grn, float blu, float alpha) {
        float step = (float)Math.PI / (float)(subd / 2);
        int num_steps180 = (int)(Math.PI / (double)step) + 1;
        int num_steps360 = (int)(Math.PI * 2 / (double)step) + 1;
        if (axis == class_2350.class_2351.field_11052) {
            float z;
            float x;
            float theta;
            int i;
            builder.method_1328(class_293.class_5596.field_27381, class_290.field_1576);
            builder.method_22912((double)cx, (double)cy, (double)cz).method_22915(red, grn, blu, alpha).method_1344();
            for (i = 0; i <= num_steps360; ++i) {
                theta = step * (float)i;
                x = r * class_3532.method_15362((float)theta);
                z = r * class_3532.method_15374((float)theta);
                builder.method_22912((double)(x + cx), (double)cy, (double)(z + cz)).method_22915(red, grn, blu, alpha).method_1344();
            }
            tessellator.method_1350();
            if (!isFlat) {
                builder.method_1328(class_293.class_5596.field_27381, class_290.field_1576);
                builder.method_22912((double)cx, (double)(cy + h), (double)cz).method_22915(red, grn, blu, alpha).method_1344();
                for (i = 0; i <= num_steps360; ++i) {
                    theta = step * (float)i;
                    x = r * class_3532.method_15362((float)theta);
                    z = r * class_3532.method_15374((float)theta);
                    builder.method_22912((double)(x + cx), (double)(cy + h), (double)(z + cz)).method_22915(red, grn, blu, alpha).method_1344();
                }
                tessellator.method_1350();
                builder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
                float xp = r * 1.0f;
                float zp = r * 0.0f;
                for (int i2 = 1; i2 <= num_steps360; ++i2) {
                    float theta2 = step * (float)i2;
                    float x2 = r * class_3532.method_15362((float)theta2);
                    float z2 = r * class_3532.method_15374((float)theta2);
                    builder.method_22912((double)(cx + xp), (double)(cy + 0.0f), (double)(cz + zp)).method_22915(red, grn, blu, alpha).method_1344();
                    builder.method_22912((double)(cx + xp), (double)(cy + h), (double)(cz + zp)).method_22915(red, grn, blu, alpha).method_1344();
                    builder.method_22912((double)(cx + x2), (double)(cy + h), (double)(cz + z2)).method_22915(red, grn, blu, alpha).method_1344();
                    builder.method_22912((double)(cx + x2), (double)(cy + 0.0f), (double)(cz + z2)).method_22915(red, grn, blu, alpha).method_1344();
                    xp = x2;
                    zp = z2;
                }
                tessellator.method_1350();
            }
        } else if (axis == class_2350.class_2351.field_11048) {
            float z;
            float y;
            float theta;
            int i;
            builder.method_1328(class_293.class_5596.field_27381, class_290.field_1576);
            builder.method_22912((double)cx, (double)cy, (double)cz).method_22915(red, grn, blu, alpha).method_1344();
            for (i = 0; i <= num_steps360; ++i) {
                theta = step * (float)i;
                y = r * class_3532.method_15362((float)theta);
                z = r * class_3532.method_15374((float)theta);
                builder.method_22912((double)cx, (double)(cy + y), (double)(z + cz)).method_22915(red, grn, blu, alpha).method_1344();
            }
            tessellator.method_1350();
            if (!isFlat) {
                builder.method_1328(class_293.class_5596.field_27381, class_290.field_1576);
                builder.method_22912((double)(cx + h), (double)cy, (double)cz).method_22915(red, grn, blu, alpha).method_1344();
                for (i = 0; i <= num_steps360; ++i) {
                    theta = step * (float)i;
                    y = r * class_3532.method_15362((float)theta);
                    z = r * class_3532.method_15374((float)theta);
                    builder.method_22912((double)(cx + h), (double)(cy + y), (double)(cz + z)).method_22915(red, grn, blu, alpha).method_1344();
                }
                tessellator.method_1350();
                builder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
                float yp = r * 1.0f;
                float zp = r * 0.0f;
                for (int i3 = 1; i3 <= num_steps360; ++i3) {
                    float theta3 = step * (float)i3;
                    float y2 = r * class_3532.method_15362((float)theta3);
                    float z3 = r * class_3532.method_15374((float)theta3);
                    builder.method_22912((double)(cx + 0.0f), (double)(cy + yp), (double)(cz + zp)).method_22915(red, grn, blu, alpha).method_1344();
                    builder.method_22912((double)(cx + h), (double)(cy + yp), (double)(cz + zp)).method_22915(red, grn, blu, alpha).method_1344();
                    builder.method_22912((double)(cx + h), (double)(cy + y2), (double)(cz + z3)).method_22915(red, grn, blu, alpha).method_1344();
                    builder.method_22912((double)(cx + 0.0f), (double)(cy + y2), (double)(cz + z3)).method_22915(red, grn, blu, alpha).method_1344();
                    yp = y2;
                    zp = z3;
                }
                tessellator.method_1350();
            }
        } else if (axis == class_2350.class_2351.field_11051) {
            float y;
            float x;
            float theta;
            int i;
            builder.method_1328(class_293.class_5596.field_27381, class_290.field_1576);
            builder.method_22912((double)cx, (double)cy, (double)cz).method_22915(red, grn, blu, alpha).method_1344();
            for (i = 0; i <= num_steps360; ++i) {
                theta = step * (float)i;
                x = r * class_3532.method_15362((float)theta);
                y = r * class_3532.method_15374((float)theta);
                builder.method_22912((double)(x + cx), (double)(cy + y), (double)cz).method_22915(red, grn, blu, alpha).method_1344();
            }
            tessellator.method_1350();
            if (!isFlat) {
                builder.method_1328(class_293.class_5596.field_27381, class_290.field_1576);
                builder.method_22912((double)cx, (double)cy, (double)(cz + h)).method_22915(red, grn, blu, alpha).method_1344();
                for (i = 0; i <= num_steps360; ++i) {
                    theta = step * (float)i;
                    x = r * class_3532.method_15362((float)theta);
                    y = r * class_3532.method_15374((float)theta);
                    builder.method_22912((double)(x + cx), (double)(cy + y), (double)(cz + h)).method_22915(red, grn, blu, alpha).method_1344();
                }
                tessellator.method_1350();
                builder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
                float xp = r;
                float yp = 0.0f;
                for (int i4 = 1; i4 <= num_steps360; ++i4) {
                    float theta4 = step * (float)i4;
                    float x3 = r * class_3532.method_15362((float)theta4);
                    float y3 = r * class_3532.method_15374((float)theta4);
                    builder.method_22912((double)(cx + xp), (double)(cy + yp), (double)(cz + 0.0f)).method_22915(red, grn, blu, alpha).method_1344();
                    builder.method_22912((double)(cx + xp), (double)(cy + yp), (double)(cz + h)).method_22915(red, grn, blu, alpha).method_1344();
                    builder.method_22912((double)(cx + x3), (double)(cy + y3), (double)(cz + h)).method_22915(red, grn, blu, alpha).method_1344();
                    builder.method_22912((double)(cx + x3), (double)(cy + y3), (double)(cz + 0.0f)).method_22915(red, grn, blu, alpha).method_1344();
                    xp = x3;
                    yp = y3;
                }
                tessellator.method_1350();
            }
        }
    }

    public static void drawSphereWireframe(class_289 tessellator, class_287 builder, float cx, float cy, float cz, float r, int subd, float red, float grn, float blu, float alpha) {
        float y;
        float z;
        float x;
        float step = (float)Math.PI / (float)(subd / 2);
        int num_steps180 = (int)(Math.PI / (double)step) + 1;
        int num_steps360 = (int)(Math.PI * 2 / (double)step) + 1;
        for (int i = 0; i <= num_steps360; ++i) {
            builder.method_1328(class_293.class_5596.field_29345, class_290.field_1576);
            float theta = step * (float)i;
            for (int j = 0; j <= num_steps180; ++j) {
                float phi = step * (float)j;
                x = r * class_3532.method_15374((float)phi) * class_3532.method_15362((float)theta);
                z = r * class_3532.method_15374((float)phi) * class_3532.method_15374((float)theta);
                y = r * class_3532.method_15362((float)phi);
                builder.method_22912((double)(x + cx), (double)(y + cy), (double)(z + cz)).method_22915(red, grn, blu, alpha).method_1344();
            }
            tessellator.method_1350();
        }
        for (int j = 0; j <= num_steps180; ++j) {
            builder.method_1328(class_293.class_5596.field_29345, class_290.field_1576);
            float phi = step * (float)j;
            for (int i = 0; i <= num_steps360; ++i) {
                float theta = step * (float)i;
                x = r * class_3532.method_15374((float)phi) * class_3532.method_15362((float)theta);
                z = r * class_3532.method_15374((float)phi) * class_3532.method_15374((float)theta);
                y = r * class_3532.method_15362((float)phi);
                builder.method_22912((double)(x + cx), (double)(y + cy), (double)(z + cz)).method_22915(red, grn, blu, alpha).method_1344();
            }
            tessellator.method_1350();
        }
    }

    public static void drawSphereFaces(class_289 tessellator, class_287 builder, float cx, float cy, float cz, float r, int subd, float red, float grn, float blu, float alpha) {
        float step = (float)Math.PI / (float)(subd / 2);
        int num_steps180 = (int)(Math.PI / (double)step) + 1;
        int num_steps360 = (int)(Math.PI * 2 / (double)step);
        for (int i = 0; i <= num_steps360; ++i) {
            float theta = (float)i * step;
            float thetaprime = theta + step;
            builder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
            float xb = 0.0f;
            float zb = 0.0f;
            float xbp = 0.0f;
            float zbp = 0.0f;
            float yp = r;
            for (int j = 0; j <= num_steps180; ++j) {
                float phi = (float)j * step;
                float x = r * class_3532.method_15374((float)phi) * class_3532.method_15362((float)theta);
                float z = r * class_3532.method_15374((float)phi) * class_3532.method_15374((float)theta);
                float y = r * class_3532.method_15362((float)phi);
                float xp = r * class_3532.method_15374((float)phi) * class_3532.method_15362((float)thetaprime);
                float zp = r * class_3532.method_15374((float)phi) * class_3532.method_15374((float)thetaprime);
                builder.method_22912((double)(xb + cx), (double)(yp + cy), (double)(zb + cz)).method_22915(red, grn, blu, alpha).method_1344();
                builder.method_22912((double)(xbp + cx), (double)(yp + cy), (double)(zbp + cz)).method_22915(red, grn, blu, alpha).method_1344();
                builder.method_22912((double)(xp + cx), (double)(y + cy), (double)(zp + cz)).method_22915(red, grn, blu, alpha).method_1344();
                builder.method_22912((double)(x + cx), (double)(y + cy), (double)(z + cz)).method_22915(red, grn, blu, alpha).method_1344();
                xb = x;
                zb = z;
                xbp = xp;
                zbp = zp;
                yp = y;
            }
            tessellator.method_1350();
        }
    }

    public static abstract class RenderedShape<T extends ShapeDispatcher.ExpiringShape> {
        protected T shape;
        protected class_310 client;
        long expiryTick;
        double renderEpsilon = 0.0;

        public abstract void renderLines(class_4587 var1, class_289 var2, class_287 var3, double var4, double var6, double var8, float var10);

        public void renderFaces(class_289 tessellator, class_287 builder, double cx, double cy, double cz, float partialTick) {
        }

        protected RenderedShape(class_310 client, T shape) {
            this.shape = shape;
            this.expiryTick = client.field_1687.method_8510() + (long)((ShapeDispatcher.ExpiringShape)shape).getExpiry();
            this.renderEpsilon = (3.0 + (double)((ShapeDispatcher.ExpiringShape)shape).key() / 9.223372036854776E18) / 1000.0;
            this.client = client;
        }

        public boolean isExpired(long currentTick) {
            return this.expiryTick < currentTick;
        }

        public long key() {
            return ((ShapeDispatcher.ExpiringShape)this.shape).key();
        }

        public boolean shouldRender(class_5321<class_1937> dim) {
            if (((ShapeDispatcher.ExpiringShape)this.shape).followEntity <= 0) {
                return true;
            }
            if (this.client.field_1687 == null) {
                return false;
            }
            if (this.client.field_1687.method_27983() != dim) {
                return false;
            }
            return this.client.field_1687.method_8469(((ShapeDispatcher.ExpiringShape)this.shape).followEntity) != null;
        }

        public boolean stageDeux() {
            return false;
        }

        public void promoteWith(RenderedShape<?> rshape) {
            this.expiryTick = rshape.expiryTick;
        }
    }

    public static class RenderedCylinder
    extends RenderedShape<ShapeDispatcher.Cylinder> {
        public RenderedCylinder(class_310 client, ShapeDispatcher.ExpiringShape shape) {
            super(client, (ShapeDispatcher.Cylinder)shape);
        }

        @Override
        public void renderLines(class_4587 matrices, class_289 tessellator, class_287 bufferBuilder, double cx, double cy, double cz, float partialTick) {
            if ((double)((ShapeDispatcher.Cylinder)this.shape).a == 0.0) {
                return;
            }
            class_243 vc = ((ShapeDispatcher.Cylinder)this.shape).relativiseRender((class_1937)this.client.field_1687, ((ShapeDispatcher.Cylinder)this.shape).center, partialTick);
            double dir = class_3532.method_17822((double)((ShapeDispatcher.Cylinder)this.shape).height);
            ShapesRenderer.drawCylinderWireframe(tessellator, bufferBuilder, (float)(vc.field_1352 - cx - dir * this.renderEpsilon), (float)(vc.field_1351 - cy - dir * this.renderEpsilon), (float)(vc.field_1350 - cz - dir * this.renderEpsilon), (float)((double)((ShapeDispatcher.Cylinder)this.shape).radius + this.renderEpsilon), (float)((double)((ShapeDispatcher.Cylinder)this.shape).height + 2.0 * dir * this.renderEpsilon), ((ShapeDispatcher.Cylinder)this.shape).axis, ((ShapeDispatcher.Cylinder)this.shape).subdivisions, ((ShapeDispatcher.Cylinder)this.shape).radius == 0.0f, ((ShapeDispatcher.Cylinder)this.shape).r, ((ShapeDispatcher.Cylinder)this.shape).g, ((ShapeDispatcher.Cylinder)this.shape).b, ((ShapeDispatcher.Cylinder)this.shape).a);
        }

        @Override
        public void renderFaces(class_289 tessellator, class_287 bufferBuilder, double cx, double cy, double cz, float partialTick) {
            if ((double)((ShapeDispatcher.Cylinder)this.shape).fa == 0.0) {
                return;
            }
            class_243 vc = ((ShapeDispatcher.Cylinder)this.shape).relativiseRender((class_1937)this.client.field_1687, ((ShapeDispatcher.Cylinder)this.shape).center, partialTick);
            double dir = class_3532.method_17822((double)((ShapeDispatcher.Cylinder)this.shape).height);
            ShapesRenderer.drawCylinderFaces(tessellator, bufferBuilder, (float)(vc.field_1352 - cx - dir * this.renderEpsilon), (float)(vc.field_1351 - cy - dir * this.renderEpsilon), (float)(vc.field_1350 - cz - dir * this.renderEpsilon), (float)((double)((ShapeDispatcher.Cylinder)this.shape).radius + this.renderEpsilon), (float)((double)((ShapeDispatcher.Cylinder)this.shape).height + 2.0 * dir * this.renderEpsilon), ((ShapeDispatcher.Cylinder)this.shape).axis, ((ShapeDispatcher.Cylinder)this.shape).subdivisions, ((ShapeDispatcher.Cylinder)this.shape).radius == 0.0f, ((ShapeDispatcher.Cylinder)this.shape).fr, ((ShapeDispatcher.Cylinder)this.shape).fg, ((ShapeDispatcher.Cylinder)this.shape).fb, ((ShapeDispatcher.Cylinder)this.shape).fa);
        }
    }

    public static class RenderedSphere
    extends RenderedShape<ShapeDispatcher.Sphere> {
        public RenderedSphere(class_310 client, ShapeDispatcher.ExpiringShape shape) {
            super(client, (ShapeDispatcher.Sphere)shape);
        }

        @Override
        public void renderLines(class_4587 matrices, class_289 tessellator, class_287 bufferBuilder, double cx, double cy, double cz, float partialTick) {
            if ((double)((ShapeDispatcher.Sphere)this.shape).a == 0.0) {
                return;
            }
            class_243 vc = ((ShapeDispatcher.Sphere)this.shape).relativiseRender((class_1937)this.client.field_1687, ((ShapeDispatcher.Sphere)this.shape).center, partialTick);
            ShapesRenderer.drawSphereWireframe(tessellator, bufferBuilder, (float)(vc.field_1352 - cx), (float)(vc.field_1351 - cy), (float)(vc.field_1350 - cz), (float)((double)((ShapeDispatcher.Sphere)this.shape).radius + this.renderEpsilon), ((ShapeDispatcher.Sphere)this.shape).subdivisions, ((ShapeDispatcher.Sphere)this.shape).r, ((ShapeDispatcher.Sphere)this.shape).g, ((ShapeDispatcher.Sphere)this.shape).b, ((ShapeDispatcher.Sphere)this.shape).a);
        }

        @Override
        public void renderFaces(class_289 tessellator, class_287 bufferBuilder, double cx, double cy, double cz, float partialTick) {
            if ((double)((ShapeDispatcher.Sphere)this.shape).fa == 0.0) {
                return;
            }
            class_243 vc = ((ShapeDispatcher.Sphere)this.shape).relativiseRender((class_1937)this.client.field_1687, ((ShapeDispatcher.Sphere)this.shape).center, partialTick);
            ShapesRenderer.drawSphereFaces(tessellator, bufferBuilder, (float)(vc.field_1352 - cx), (float)(vc.field_1351 - cy), (float)(vc.field_1350 - cz), (float)((double)((ShapeDispatcher.Sphere)this.shape).radius + this.renderEpsilon), ((ShapeDispatcher.Sphere)this.shape).subdivisions, ((ShapeDispatcher.Sphere)this.shape).fr, ((ShapeDispatcher.Sphere)this.shape).fg, ((ShapeDispatcher.Sphere)this.shape).fb, ((ShapeDispatcher.Sphere)this.shape).fa);
        }
    }

    public static class RenderedLine
    extends RenderedShape<ShapeDispatcher.Line> {
        public RenderedLine(class_310 client, ShapeDispatcher.ExpiringShape shape) {
            super(client, (ShapeDispatcher.Line)shape);
        }

        @Override
        public void renderLines(class_4587 matrices, class_289 tessellator, class_287 bufferBuilder, double cx, double cy, double cz, float partialTick) {
            class_243 v1 = ((ShapeDispatcher.Line)this.shape).relativiseRender((class_1937)this.client.field_1687, ((ShapeDispatcher.Line)this.shape).from, partialTick);
            class_243 v2 = ((ShapeDispatcher.Line)this.shape).relativiseRender((class_1937)this.client.field_1687, ((ShapeDispatcher.Line)this.shape).to, partialTick);
            ShapesRenderer.drawLine(tessellator, bufferBuilder, (float)(v1.field_1352 - cx - this.renderEpsilon), (float)(v1.field_1351 - cy - this.renderEpsilon), (float)(v1.field_1350 - cz - this.renderEpsilon), (float)(v2.field_1352 - cx + this.renderEpsilon), (float)(v2.field_1351 - cy + this.renderEpsilon), (float)(v2.field_1350 - cz + this.renderEpsilon), ((ShapeDispatcher.Line)this.shape).r, ((ShapeDispatcher.Line)this.shape).g, ((ShapeDispatcher.Line)this.shape).b, ((ShapeDispatcher.Line)this.shape).a);
        }
    }

    public static class RenderedBox
    extends RenderedShape<ShapeDispatcher.Box> {
        private RenderedBox(class_310 client, ShapeDispatcher.ExpiringShape shape) {
            super(client, (ShapeDispatcher.Box)shape);
        }

        @Override
        public void renderLines(class_4587 matrices, class_289 tessellator, class_287 bufferBuilder, double cx, double cy, double cz, float partialTick) {
            if ((double)((ShapeDispatcher.Box)this.shape).a == 0.0) {
                return;
            }
            class_243 v1 = ((ShapeDispatcher.Box)this.shape).relativiseRender((class_1937)this.client.field_1687, ((ShapeDispatcher.Box)this.shape).from, partialTick);
            class_243 v2 = ((ShapeDispatcher.Box)this.shape).relativiseRender((class_1937)this.client.field_1687, ((ShapeDispatcher.Box)this.shape).to, partialTick);
            ShapesRenderer.drawBoxWireGLLines(tessellator, bufferBuilder, (float)(v1.field_1352 - cx - this.renderEpsilon), (float)(v1.field_1351 - cy - this.renderEpsilon), (float)(v1.field_1350 - cz - this.renderEpsilon), (float)(v2.field_1352 - cx + this.renderEpsilon), (float)(v2.field_1351 - cy + this.renderEpsilon), (float)(v2.field_1350 - cz + this.renderEpsilon), v1.field_1352 != v2.field_1352, v1.field_1351 != v2.field_1351, v1.field_1350 != v2.field_1350, ((ShapeDispatcher.Box)this.shape).r, ((ShapeDispatcher.Box)this.shape).g, ((ShapeDispatcher.Box)this.shape).b, ((ShapeDispatcher.Box)this.shape).a, ((ShapeDispatcher.Box)this.shape).r, ((ShapeDispatcher.Box)this.shape).g, ((ShapeDispatcher.Box)this.shape).b);
        }

        @Override
        public void renderFaces(class_289 tessellator, class_287 bufferBuilder, double cx, double cy, double cz, float partialTick) {
            if ((double)((ShapeDispatcher.Box)this.shape).fa == 0.0) {
                return;
            }
            class_243 v1 = ((ShapeDispatcher.Box)this.shape).relativiseRender((class_1937)this.client.field_1687, ((ShapeDispatcher.Box)this.shape).from, partialTick);
            class_243 v2 = ((ShapeDispatcher.Box)this.shape).relativiseRender((class_1937)this.client.field_1687, ((ShapeDispatcher.Box)this.shape).to, partialTick);
            ShapesRenderer.drawBoxFaces(tessellator, bufferBuilder, (float)(v1.field_1352 - cx - this.renderEpsilon), (float)(v1.field_1351 - cy - this.renderEpsilon), (float)(v1.field_1350 - cz - this.renderEpsilon), (float)(v2.field_1352 - cx + this.renderEpsilon), (float)(v2.field_1351 - cy + this.renderEpsilon), (float)(v2.field_1350 - cz + this.renderEpsilon), v1.field_1352 != v2.field_1352, v1.field_1351 != v2.field_1351, v1.field_1350 != v2.field_1350, ((ShapeDispatcher.Box)this.shape).fr, ((ShapeDispatcher.Box)this.shape).fg, ((ShapeDispatcher.Box)this.shape).fb, ((ShapeDispatcher.Box)this.shape).fa);
        }
    }

    public static class RenderedText
    extends RenderedShape<ShapeDispatcher.DisplayedText> {
        protected RenderedText(class_310 client, ShapeDispatcher.ExpiringShape shape) {
            super(client, (ShapeDispatcher.DisplayedText)shape);
        }

        @Override
        public void renderLines(class_4587 matrices, class_289 tessellator, class_287 builder, double cx, double cy, double cz, float partialTick) {
            if ((double)((ShapeDispatcher.DisplayedText)this.shape).a == 0.0) {
                return;
            }
            class_243 v1 = ((ShapeDispatcher.DisplayedText)this.shape).relativiseRender((class_1937)this.client.field_1687, ((ShapeDispatcher.DisplayedText)this.shape).pos, partialTick);
            class_4184 camera1 = this.client.field_1773.method_19418();
            class_327 textRenderer = this.client.field_1772;
            if (((ShapeDispatcher.DisplayedText)this.shape).doublesided) {
                RenderSystem.disableCull();
            } else {
                RenderSystem.enableCull();
            }
            matrices.method_22903();
            matrices.method_22904(v1.field_1352 - cx, v1.field_1351 - cy, v1.field_1350 - cz);
            if (((ShapeDispatcher.DisplayedText)this.shape).facing == null) {
                matrices.method_22907(camera1.method_23767());
            } else {
                switch (((ShapeDispatcher.DisplayedText)this.shape).facing) {
                    case field_11043: {
                        break;
                    }
                    case field_11035: {
                        matrices.method_22907(class_1160.field_20705.method_23214(180.0f));
                        break;
                    }
                    case field_11034: {
                        matrices.method_22907(class_1160.field_20705.method_23214(270.0f));
                        break;
                    }
                    case field_11039: {
                        matrices.method_22907(class_1160.field_20705.method_23214(90.0f));
                        break;
                    }
                    case field_11036: {
                        matrices.method_22907(class_1160.field_20703.method_23214(90.0f));
                        break;
                    }
                    case field_11033: {
                        matrices.method_22907(class_1160.field_20703.method_23214(-90.0f));
                    }
                }
            }
            matrices.method_22905(((ShapeDispatcher.DisplayedText)this.shape).size * 0.0025f, -((ShapeDispatcher.DisplayedText)this.shape).size * 0.0025f, ((ShapeDispatcher.DisplayedText)this.shape).size * 0.0025f);
            if (((ShapeDispatcher.DisplayedText)this.shape).tilt != 0.0f) {
                matrices.method_22907(class_1160.field_20707.method_23214(((ShapeDispatcher.DisplayedText)this.shape).tilt));
            }
            if (((ShapeDispatcher.DisplayedText)this.shape).lean != 0.0f) {
                matrices.method_22907(class_1160.field_20703.method_23214(((ShapeDispatcher.DisplayedText)this.shape).lean));
            }
            if (((ShapeDispatcher.DisplayedText)this.shape).turn != 0.0f) {
                matrices.method_22907(class_1160.field_20705.method_23214(((ShapeDispatcher.DisplayedText)this.shape).turn));
            }
            matrices.method_22904((double)(-10.0f * ((ShapeDispatcher.DisplayedText)this.shape).indent), (double)(-10.0f * ((ShapeDispatcher.DisplayedText)this.shape).height - 9.0f), -10.0 * this.renderEpsilon - (double)(10.0f * ((ShapeDispatcher.DisplayedText)this.shape).raise));
            matrices.method_22905(-1.0f, 1.0f, 1.0f);
            float text_x = 0.0f;
            if (((ShapeDispatcher.DisplayedText)this.shape).align == 0) {
                text_x = (float)(-textRenderer.method_1727(((ShapeDispatcher.DisplayedText)this.shape).value.getString())) / 2.0f;
            } else if (((ShapeDispatcher.DisplayedText)this.shape).align == 1) {
                text_x = -textRenderer.method_1727(((ShapeDispatcher.DisplayedText)this.shape).value.getString());
            }
            class_4597.class_4598 immediate = class_4597.method_22991((class_287)builder);
            textRenderer.method_30882(((ShapeDispatcher.DisplayedText)this.shape).value, text_x, 0.0f, ((ShapeDispatcher.DisplayedText)this.shape).textcolor, false, matrices.method_23760().method_23761(), (class_4597)immediate, false, ((ShapeDispatcher.DisplayedText)this.shape).textbck, 0xF000F0);
            immediate.method_22993();
            matrices.method_22909();
            RenderSystem.enableCull();
        }

        @Override
        public boolean stageDeux() {
            return true;
        }

        @Override
        public void promoteWith(RenderedShape<?> rshape) {
            super.promoteWith(rshape);
            try {
                ((ShapeDispatcher.DisplayedText)this.shape).value = ((ShapeDispatcher.DisplayedText)rshape.shape).value;
            }
            catch (ClassCastException ignored) {
                CarpetSettings.LOG.error("shape " + rshape.shape.getClass() + " cannot cast to a Label");
            }
        }
    }
}

