/*
 * Decompiled with CFR 0.152.
 */
package carpet.utils;

import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;

public class FabricAPIHooks {
    public static final boolean WORLD_RENDER_EVENTS = FabricAPIHooks.hasMod("fabric-rendering-v1", "1.5.0");

    private FabricAPIHooks() {
    }

    public static void initialize() {
        if (WORLD_RENDER_EVENTS) {
            WorldRenderEvents.BEFORE_DEBUG_RENDER.register(context -> {});
        }
    }

    private static boolean hasMod(String id, String minimumVersion) {
        return FabricLoader.getInstance().getModContainer(id).map(m -> {
            Version version = m.getMetadata().getVersion();
            if (version instanceof SemanticVersion) {
                try {
                    return ((SemanticVersion)version).compareTo(SemanticVersion.parse((String)minimumVersion)) >= 0;
                }
                catch (VersionParsingException versionParsingException) {
                    // empty catch block
                }
            }
            return false;
        }).orElse(false);
    }
}

