/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.audiodevice;

import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.voicechat.gui.audiodevice.SelectDeviceScreen;
import de.maxhenkel.voicechat.gui.widgets.ListScreenEntryBase;
import java.util.Objects;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5253;

public class AudioDeviceEntry
extends ListScreenEntryBase<AudioDeviceEntry> {
    protected static final class_2960 SELECTED = new class_2960("voicechat", "textures/icons/device_selected.png");
    protected static final int PADDING = 4;
    protected static final int BG_FILL = class_5253.class_5254.method_27764((int)255, (int)74, (int)74, (int)74);
    protected static final int BG_FILL_HOVERED = class_5253.class_5254.method_27764((int)255, (int)90, (int)90, (int)90);
    protected static final int BG_FILL_SELECTED = class_5253.class_5254.method_27764((int)255, (int)40, (int)40, (int)40);
    protected static final int DEVICE_NAME_COLOR = class_5253.class_5254.method_27764((int)255, (int)255, (int)255, (int)255);
    protected final class_310 minecraft;
    protected final String device;
    protected final String visibleDeviceName;
    protected final SelectDeviceScreen parent;

    public AudioDeviceEntry(SelectDeviceScreen parent, String device) {
        this.parent = parent;
        this.device = device;
        this.visibleDeviceName = parent.getVisibleName(device);
        this.minecraft = class_310.method_1551();
    }

    public void method_25343(class_4587 poseStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float delta) {
        boolean selected = this.parent.getSelectedDevice().equals(this.device);
        if (selected) {
            class_332.method_25294((class_4587)poseStack, (int)left, (int)top, (int)(left + width), (int)(top + height), (int)BG_FILL_SELECTED);
        } else if (hovered) {
            class_332.method_25294((class_4587)poseStack, (int)left, (int)top, (int)(left + width), (int)(top + height), (int)BG_FILL_HOVERED);
        } else {
            class_332.method_25294((class_4587)poseStack, (int)left, (int)top, (int)(left + width), (int)(top + height), (int)BG_FILL);
        }
        RenderSystem.setShaderTexture((int)0, (class_2960)this.parent.getIcon(this.device));
        class_332.method_25290((class_4587)poseStack, (int)(left + 4), (int)(top + height / 2 - 8), (float)16.0f, (float)16.0f, (int)16, (int)16, (int)16, (int)16);
        if (selected) {
            RenderSystem.setShaderTexture((int)0, (class_2960)SELECTED);
            class_332.method_25290((class_4587)poseStack, (int)(left + 4), (int)(top + height / 2 - 8), (float)16.0f, (float)16.0f, (int)16, (int)16, (int)16, (int)16);
        }
        float deviceWidth = this.minecraft.field_1772.method_1727(this.visibleDeviceName);
        float space = width - 4 - 16 - 4 - 4;
        float scale = Math.min(space / deviceWidth, 1.0f);
        poseStack.method_22903();
        double d = left + 4 + 16 + 4;
        float f = top + height / 2;
        Objects.requireNonNull(this.minecraft.field_1772);
        poseStack.method_22904(d, (double)(f - 9.0f * scale / 2.0f), 0.0);
        poseStack.method_22905(scale, scale, 1.0f);
        this.minecraft.field_1772.method_1729(poseStack, this.visibleDeviceName, 0.0f, 0.0f, DEVICE_NAME_COLOR);
        poseStack.method_22909();
    }

    public String getDevice() {
        return this.device;
    }
}

