/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.intercompatibility;

import com.mojang.brigadier.CommandDispatcher;
import de.maxhenkel.voicechat.api.VoicechatPlugin;
import de.maxhenkel.voicechat.events.PlayerEvents;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.net.FabricNetManager;
import de.maxhenkel.voicechat.net.NetManager;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.impl.client.keybinding.KeyBindingRegistryImpl;
import net.fabricmc.fabric.mixin.client.keybinding.KeyCodeAccessor;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.fabricmc.loader.api.metadata.ModDependency;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_2168;
import net.minecraft.class_304;
import net.minecraft.class_3222;
import net.minecraft.class_3675;
import net.minecraft.server.MinecraftServer;

public class FabricCommonCompatibilityManager
extends CommonCompatibilityManager {
    private FabricNetManager netManager;

    @Override
    public String getModVersion() {
        ModContainer modContainer = FabricLoader.getInstance().getModContainer("voicechat").orElse(null);
        if (modContainer == null) {
            return "N/A";
        }
        return modContainer.getMetadata().getVersion().getFriendlyString();
    }

    @Override
    public String getModName() {
        ModContainer modContainer = FabricLoader.getInstance().getModContainer("voicechat").orElse(null);
        if (modContainer == null) {
            return "voicechat";
        }
        return modContainer.getMetadata().getName();
    }

    @Override
    public Path getGameDirectory() {
        return FabricLoader.getInstance().getGameDir();
    }

    @Override
    public void onServerStarting(Consumer<MinecraftServer> onServerStarting) {
        ServerLifecycleEvents.SERVER_STARTED.register(onServerStarting::accept);
    }

    @Override
    public void onServerStopping(Consumer<MinecraftServer> onServerStopping) {
        ServerLifecycleEvents.SERVER_STOPPING.register(onServerStopping::accept);
    }

    @Override
    public void onPlayerLoggedIn(Consumer<class_3222> onPlayerLoggedIn) {
        PlayerEvents.PLAYER_LOGGED_IN.register(onPlayerLoggedIn);
    }

    @Override
    public void onPlayerLoggedOut(Consumer<class_3222> onPlayerLoggedOut) {
        PlayerEvents.PLAYER_LOGGED_OUT.register(onPlayerLoggedOut);
    }

    @Override
    public void onRegisterServerCommands(Consumer<CommandDispatcher<class_2168>> onRegisterServerCommands) {
        CommandRegistrationCallback.EVENT.register((dispatcher, dedicated) -> onRegisterServerCommands.accept(dispatcher));
    }

    @Override
    public NetManager getNetManager() {
        if (this.netManager == null) {
            this.netManager = new FabricNetManager();
        }
        return this.netManager;
    }

    @Override
    public String listLoadedMods() {
        StringBuilder sb = new StringBuilder();
        for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
            ModMetadata metadata = mod.getMetadata();
            sb.append("Mod ID: " + metadata.getId());
            sb.append("\n");
            sb.append("Name: " + metadata.getName());
            sb.append("\n");
            sb.append("Version: " + metadata.getVersion());
            sb.append("\n");
            sb.append("Dependencies: " + metadata.getDepends().stream().map(ModDependency::getModId).collect(Collectors.joining(", ")));
            sb.append("\n\n");
        }
        return sb.toString();
    }

    @Override
    public String listKeybinds() {
        StringBuilder sb = new StringBuilder();
        try {
            Field moddedKeyBindings = KeyBindingRegistryImpl.class.getDeclaredField("moddedKeyBindings");
            moddedKeyBindings.setAccessible(true);
            List mappings = (List)moddedKeyBindings.get(null);
            for (class_304 mapping : mappings) {
                class_3675.class_306 boundKey = ((KeyCodeAccessor)mapping).fabric_getBoundKey();
                sb.append(mapping.method_1431() + "(" + mapping.method_1423() + "): " + boundKey.method_1441() + " (" + mapping.method_1429().method_1441() + ")");
                sb.append("\n");
            }
            sb.append("\n");
        }
        catch (Exception e) {
            sb.append("Error: " + e.getMessage());
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public boolean isDevEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    @Override
    public List<VoicechatPlugin> loadPlugins() {
        return FabricLoader.getInstance().getEntrypointContainers("voicechat", VoicechatPlugin.class).stream().map(EntrypointContainer::getEntrypoint).collect(Collectors.toList());
    }
}

