/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.macos;

import de.maxhenkel.voicechat.macos.VersionCheck;
import de.maxhenkel.voicechat.macos.jna.avfoundation.AVAuthorizationStatus;
import de.maxhenkel.voicechat.macos.jna.avfoundation.AVCaptureDevice;
import de.maxhenkel.voicechat.macos.jna.foundation.NSString;

public class PermissionCheck {
    private static final NSString AVMediaTypeAudio = new NSString("soun");

    public static void requestMicrophonePermissions() {
        PermissionCheck.checkMicrophonePermissions(true);
    }

    public static AVAuthorizationStatus getMicrophonePermissions() {
        return PermissionCheck.checkMicrophonePermissions(false);
    }

    public static AVAuthorizationStatus checkMicrophonePermissions(boolean requestIfNeeded) {
        if (!VersionCheck.isMinimumVersion(10, 14, 0)) {
            return AVAuthorizationStatus.AUTHORIZED;
        }
        AVAuthorizationStatus status = AVCaptureDevice.getAuthorizationStatus(AVMediaTypeAudio);
        if (requestIfNeeded && status == AVAuthorizationStatus.NOT_DETERMINED) {
            AVCaptureDevice.requestAccessForMediaType(AVMediaTypeAudio);
        }
        return status;
    }
}

