/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.api.opus.OpusDecoder;
import de.maxhenkel.voicechat.plugins.PluginManager;
import de.maxhenkel.voicechat.plugins.impl.opus.OpusManager;
import de.maxhenkel.voicechat.voice.client.AudioPacketBuffer;
import de.maxhenkel.voicechat.voice.client.AudioRecorder;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.InitializationData;
import de.maxhenkel.voicechat.voice.client.NativeDependencyException;
import de.maxhenkel.voicechat.voice.client.PositionalAudioUtils;
import de.maxhenkel.voicechat.voice.client.speaker.Speaker;
import de.maxhenkel.voicechat.voice.client.speaker.SpeakerManager;
import de.maxhenkel.voicechat.voice.common.GroupSoundPacket;
import de.maxhenkel.voicechat.voice.common.LocationSoundPacket;
import de.maxhenkel.voicechat.voice.common.Packet;
import de.maxhenkel.voicechat.voice.common.PlayerSoundPacket;
import de.maxhenkel.voicechat.voice.common.SoundPacket;
import de.maxhenkel.voicechat.voice.common.Utils;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Supplier;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_310;

public class AudioChannel
extends Thread {
    private final class_310 minecraft;
    private final ClientVoicechat client;
    private final InitializationData initializationData;
    private final UUID uuid;
    private final BlockingQueue<SoundPacket<?>> queue;
    private final AudioPacketBuffer packetBuffer;
    private long lastPacketTime;
    private Speaker speaker;
    private boolean stopped;
    private final OpusDecoder decoder;
    private long lastSequenceNumber;

    public AudioChannel(ClientVoicechat client, InitializationData initializationData, UUID uuid) throws NativeDependencyException {
        this.client = client;
        this.initializationData = initializationData;
        this.uuid = uuid;
        this.queue = new LinkedBlockingQueue();
        this.packetBuffer = new AudioPacketBuffer(VoicechatClient.CLIENT_CONFIG.audioPacketThreshold.get());
        this.lastPacketTime = System.currentTimeMillis();
        this.stopped = false;
        this.decoder = OpusManager.createDecoder(48000, 960, initializationData.getMtuSize());
        this.lastSequenceNumber = -1L;
        this.minecraft = class_310.method_1551();
        this.setDaemon(true);
        this.setName("AudioChannelThread-" + uuid.toString());
        Voicechat.LOGGER.info("Creating audio channel for " + uuid);
    }

    public boolean canKill() {
        return System.currentTimeMillis() - this.lastPacketTime > 30000L;
    }

    public void closeAndKill() {
        Voicechat.LOGGER.info("Closing audio channel for " + this.uuid);
        this.stopped = true;
        this.queue.clear();
        if (Thread.currentThread() == this) {
            return;
        }
        this.interrupt();
        try {
            this.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void addToQueue(SoundPacket<?> p) {
        this.queue.add(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.client.getSoundManager() == null) {
                throw new IllegalStateException("Started audio channel without sound manager");
            }
            this.speaker = SpeakerManager.createSpeaker(this.client.getSoundManager(), this.uuid);
            while (!this.stopped) {
                if (ClientManager.getPlayerStateManager().isDisabled()) {
                    this.closeAndKill();
                    return;
                }
                SoundPacket<?> packet = this.packetBuffer.poll(this.queue);
                if (packet == null) continue;
                this.lastPacketTime = System.currentTimeMillis();
                if (!packet.isFromClientAudioChannel() && this.lastSequenceNumber >= 0L && packet.getSequenceNumber() <= this.lastSequenceNumber || this.minecraft.field_1687 == null || this.minecraft.field_1724 == null) continue;
                if (packet.getData().length == 0) {
                    if (packet instanceof PlayerSoundPacket) {
                        PlayerSoundPacket playerSoundPacket = (PlayerSoundPacket)packet;
                        PluginManager.instance().onReceiveEntityClientSound(this.uuid, new short[0], playerSoundPacket.isWhispering());
                    } else if (packet instanceof LocationSoundPacket) {
                        LocationSoundPacket locationSoundPacket = (LocationSoundPacket)packet;
                        PluginManager.instance().onReceiveLocationalClientSound(this.uuid, new short[0], locationSoundPacket.getLocation());
                    } else if (packet instanceof GroupSoundPacket) {
                        PluginManager.instance().onReceiveStaticClientSound(this.uuid, new short[0]);
                    }
                    this.lastSequenceNumber = -1L;
                    this.packetBuffer.clear();
                    this.flushRecording();
                    this.decoder.resetState();
                    continue;
                }
                if (!packet.isFromClientAudioChannel() && this.lastSequenceNumber >= 0L) {
                    int packetsToCompensate = (int)(packet.getSequenceNumber() - (this.lastSequenceNumber + 1L));
                    if (packetsToCompensate > 0) {
                        Voicechat.LOGGER.debug("Compensating {}/{} packets ", (Object)(packetsToCompensate >= 4 ? 0 : packetsToCompensate), (Object)packetsToCompensate);
                    }
                    if (packetsToCompensate <= 4) {
                        for (int i = 0; i < packetsToCompensate; ++i) {
                            this.writeToSpeaker(packet, this.decoder.decode(null));
                        }
                    }
                }
                this.lastSequenceNumber = packet.getSequenceNumber();
                short[] decodedAudio = packet.isFromClientAudioChannel() ? Utils.bytesToShorts(packet.getData()) : this.decoder.decode(packet.getData());
                this.writeToSpeaker(packet, decodedAudio);
            }
        }
        catch (InterruptedException packet) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            if (this.speaker != null) {
                this.flushRecording();
                this.speaker.close();
            }
            this.decoder.close();
            Voicechat.LOGGER.info("Closed audio channel for " + this.uuid);
        }
    }

    private void flushRecording() {
        AudioRecorder recorder = this.client.getRecorder();
        if (recorder == null) {
            return;
        }
        recorder.flushChunkThreaded(this.uuid);
    }

    private void writeToSpeaker(Packet<?> packet, short[] monoData) {
        class_1657 player = this.minecraft.field_1687.method_18470(this.uuid);
        float playerVolume = VoicechatClient.USERNAME_CACHE.has(this.uuid) ? (float)VoicechatClient.VOLUME_CONFIG.getVolume(this.uuid) : (float)VoicechatClient.VOLUME_CONFIG.getVolume(class_156.field_25140);
        float volume = VoicechatClient.CLIENT_CONFIG.voiceChatVolume.get().floatValue() * playerVolume;
        if (packet instanceof GroupSoundPacket) {
            short[] processedMonoData = PluginManager.instance().onReceiveStaticClientSound(this.uuid, monoData);
            this.speaker.play(processedMonoData, volume, null);
            this.client.getTalkCache().updateTalking(this.uuid, false);
            this.appendRecording(() -> PositionalAudioUtils.convertToStereo(processedMonoData));
        } else if (packet instanceof PlayerSoundPacket) {
            PlayerSoundPacket soundPacket = (PlayerSoundPacket)packet;
            if (player == null) {
                return;
            }
            if (player == this.minecraft.field_1719) {
                short[] processedMonoData = PluginManager.instance().onReceiveStaticClientSound(this.uuid, monoData);
                this.speaker.play(processedMonoData, volume, null);
                this.client.getTalkCache().updateTalking(this.uuid, soundPacket.isWhispering());
                this.appendRecording(() -> PositionalAudioUtils.convertToStereo(processedMonoData));
                return;
            }
            class_243 pos = player.method_33571();
            short[] processedMonoData = PluginManager.instance().onReceiveEntityClientSound(this.uuid, monoData, soundPacket.isWhispering());
            if (pos.method_1022(this.minecraft.field_1773.method_19418().method_19326()) > this.initializationData.getVoiceChatDistance() + 1.0) {
                return;
            }
            float crouchMultiplayer = player.method_18276() ? (float)this.initializationData.getCrouchDistanceMultiplier() : 1.0f;
            float whisperMultiplayer = soundPacket.isWhispering() ? (float)this.initializationData.getWhisperDistanceMultiplier() : 1.0f;
            float multiplier = crouchMultiplayer * whisperMultiplayer;
            float outputVolume = volume * PositionalAudioUtils.getDistanceVolume(this.initializationData, pos, multiplier);
            this.speaker.play(processedMonoData, outputVolume, pos);
            if (outputVolume >= 0.01f) {
                this.client.getTalkCache().updateTalking(this.uuid, soundPacket.isWhispering());
            }
            this.appendRecording(() -> PositionalAudioUtils.convertToStereoForRecording(this.initializationData, pos, processedMonoData, multiplier));
        } else if (packet instanceof LocationSoundPacket) {
            LocationSoundPacket p = (LocationSoundPacket)packet;
            short[] processedMonoData = PluginManager.instance().onReceiveLocationalClientSound(this.uuid, monoData, p.getLocation());
            if (p.getLocation().method_1022(this.minecraft.field_1773.method_19418().method_19326()) > this.initializationData.getVoiceChatDistance() + 1.0) {
                return;
            }
            this.speaker.play(processedMonoData, volume * PositionalAudioUtils.getDistanceVolume(this.initializationData, p.getLocation()), p.getLocation());
            this.client.getTalkCache().updateTalking(this.uuid, false);
            this.appendRecording(() -> PositionalAudioUtils.convertToStereoForRecording(this.initializationData, p.getLocation(), processedMonoData));
        }
    }

    private void appendRecording(Supplier<short[]> stereo) {
        if (this.client.getRecorder() != null) {
            try {
                this.client.getRecorder().appendChunk(this.uuid, System.currentTimeMillis(), stereo.get());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isClosed() {
        return this.stopped;
    }
}

