/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.server;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.net.NetManager;
import de.maxhenkel.voicechat.net.PlayerStatePacket;
import de.maxhenkel.voicechat.net.PlayerStatesPacket;
import de.maxhenkel.voicechat.voice.common.ClientGroup;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class PlayerStateManager {
    private final ConcurrentHashMap<UUID, PlayerState> states = new ConcurrentHashMap();

    public PlayerStateManager() {
        CommonCompatibilityManager.INSTANCE.onPlayerLoggedOut(this::removePlayer);
        CommonCompatibilityManager.INSTANCE.getNetManager().updateStateChannel.setServerListener((server, player, handler, packet) -> {
            PlayerState state = this.states.get(player.method_5667());
            if (state == null) {
                state = PlayerStateManager.defaultDisconnectedState(player);
            }
            state.setDisconnected(packet.isDisconnected());
            state.setDisabled(packet.isDisabled());
            this.states.put(player.method_5667(), state);
            this.broadcastState(server, state);
            Voicechat.logDebug("Got state of {}: {}", player.method_5476().getString(), state);
        });
    }

    private void broadcastState(MinecraftServer server, PlayerState state) {
        PlayerStatePacket packet = new PlayerStatePacket(state);
        server.method_3760().method_14571().forEach(p -> NetManager.sendToClient(p, packet));
    }

    public void onPlayerCompatibilityCheckSucceeded(class_3222 player) {
        PlayerState state = this.states.getOrDefault(player.method_5667(), PlayerStateManager.defaultDisconnectedState(player));
        this.states.put(player.method_5667(), state);
        PlayerStatesPacket packet = new PlayerStatesPacket(this.states);
        NetManager.sendToClient(player, packet);
        Voicechat.logDebug("Setting initial state of {}: {}", player.method_5476().getString(), state);
    }

    private void removePlayer(class_3222 player) {
        this.states.remove(player.method_5667());
        this.broadcastState(player.field_13995, new PlayerState(player.method_5667(), player.method_7334().getName(), true, true));
        Voicechat.logDebug("Removing state of {}", player.method_5476().getString());
    }

    @Nullable
    public PlayerState getState(UUID playerUUID) {
        return this.states.get(playerUUID);
    }

    public static PlayerState defaultDisconnectedState(class_3222 player) {
        return new PlayerState(player.method_5667(), player.method_7334().getName(), false, true);
    }

    public void setGroup(MinecraftServer server, class_3222 player, @Nullable ClientGroup group) {
        PlayerState state = this.states.get(player.method_5667());
        if (state == null) {
            state = PlayerStateManager.defaultDisconnectedState(player);
            Voicechat.logDebug("Defaulting to default state for {}: {}", player.method_5476().getString(), state);
        }
        state.setGroup(group);
        this.states.put(player.method_5667(), state);
        this.broadcastState(server, state);
        Voicechat.logDebug("Setting group of {}: {}", player.method_5476().getString(), state);
    }

    public Collection<PlayerState> getStates() {
        return this.states.values();
    }
}

