/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fuzs.puzzleslib.json.JsonConfigFileUtil;
import java.io.FileReader;
import java.io.Reader;
import java.util.Optional;
import java.util.stream.Stream;

public class JsonSerializationUtil {
    public static final String FILE_FORMAT_STRING = "__file_format";
    public static final String COMMENT_STRING = "__comment";

    public static JsonObject getConfigBase(String ... comments) {
        return JsonSerializationUtil.getConfigBase(-1, comments);
    }

    public static JsonObject getConfigBase(int fileFormat, String ... comments) {
        JsonObject jsonobject = new JsonObject();
        if (fileFormat != -1) {
            jsonobject.addProperty(FILE_FORMAT_STRING, (Number)fileFormat);
        }
        JsonSerializationUtil.addConfigComment(jsonobject, comments);
        return jsonobject;
    }

    private static void addConfigComment(JsonObject jsonobject, String ... comments) {
        if (comments.length == 1) {
            jsonobject.addProperty(COMMENT_STRING, comments[0]);
        } else if (comments.length > 1) {
            JsonArray jsonarray = new JsonArray();
            Stream.of(comments).forEach(arg_0 -> ((JsonArray)jsonarray).add(arg_0));
            jsonobject.add(COMMENT_STRING, (JsonElement)jsonarray);
        }
    }

    public static int readFileFormat(JsonObject jsonObject) {
        return Optional.ofNullable(jsonObject.get(FILE_FORMAT_STRING)).map(JsonElement::getAsInt).orElse(-1);
    }

    public static JsonObject readJsonObject(FileReader reader) {
        JsonElement jsonElement = (JsonElement)JsonConfigFileUtil.GSON.fromJson((Reader)reader, JsonElement.class);
        if (!jsonElement.isJsonObject()) {
            throw new IllegalArgumentException("unable to get json object from file reader");
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        jsonObject.remove(FILE_FORMAT_STRING);
        jsonObject.remove(COMMENT_STRING);
        return jsonObject;
    }
}

