/*
 * Decompiled with CFR 0.152.
 */
package com.github.merchantpug.toomanyorigins;

import com.github.merchantpug.apugli.Apugli;
import com.github.merchantpug.toomanyorigins.registry.TMOBlocks;
import com.github.merchantpug.toomanyorigins.registry.TMOEffects;
import com.github.merchantpug.toomanyorigins.registry.TMOEntities;
import com.github.merchantpug.toomanyorigins.registry.TMOItems;
import com.github.merchantpug.toomanyorigins.registry.TMOPowers;
import com.github.merchantpug.toomanyorigins.registry.TMOSounds;
import com.github.merchantpug.toomanyorigins.util.TooManyOriginsConfig;
import io.github.apace100.apoli.util.NamespaceAlias;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TooManyOrigins
implements ModInitializer {
    public static final String MODID = "toomanyorigins";
    public static final Logger LOGGER = LogManager.getLogger(TooManyOrigins.class);
    public static String VERSION = "";
    public static int[] SEMVER;
    public static TooManyOriginsConfig config;

    public void onInitialize() {
        FabricLoader.getInstance().getModContainer(MODID).ifPresent(modContainer -> {
            VERSION = modContainer.getMetadata().getVersion().getFriendlyString();
            if (VERSION.contains("+")) {
                VERSION = VERSION.split("\\+")[0];
            }
            if (VERSION.contains("-")) {
                VERSION = VERSION.split("-")[0];
            }
            String[] splitVersion = VERSION.split("\\.");
            SEMVER = new int[splitVersion.length];
            for (int i = 0; i < SEMVER.length; ++i) {
                TooManyOrigins.SEMVER[i] = Integer.parseInt(splitVersion[i]);
            }
        });
        LOGGER.info("TooManyOrigins " + VERSION + " is initializing. Enjoy!");
        TMOBlocks.register();
        TMOEffects.register();
        TMOEntities.register();
        TMOItems.register();
        TMOPowers.register();
        TMOSounds.register();
        Apugli.addDependentModid((String)MODID);
        NamespaceAlias.addAlias((String)MODID, (String)"apugli");
        AutoConfig.register(TooManyOriginsConfig.class, JanksonConfigSerializer::new);
        config = (TooManyOriginsConfig)AutoConfig.getConfigHolder(TooManyOriginsConfig.class).getConfig();
    }
}

