/*
 * Decompiled with CFR 0.152.
 */
package ru.maxvar.mcf.reap.menu;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import net.fabricmc.loader.api.FabricLoader;
import ru.maxvar.mcf.reap.Mod;
import ru.maxvar.mcf.reap.menu.Config;

public final class ConfigManager {
    private static Config config;
    private static final Path configPath;
    private static final Gson GSON;
    private static final Executor EXECUTOR;

    private ConfigManager() {
    }

    public static Config getConfig() {
        return config != null ? config : ConfigManager.init();
    }

    private static Config init() {
        if (!Files.exists(configPath, new LinkOption[0])) {
            Mod.LOGGER.info("Creating config file ({})", (Object)configPath.getFileName());
            ConfigManager.save().join();
        }
        ((CompletableFuture)ConfigManager.load().thenApply(o -> {
            config = o;
            return config;
        })).join();
        return Objects.requireNonNull(config, "Failed to init config");
    }

    private static CompletableFuture<Config> load() {
        return CompletableFuture.supplyAsync(() -> {
            Config config;
            block8: {
                BufferedReader reader = Files.newBufferedReader(configPath);
                try {
                    config = (Config)GSON.fromJson((Reader)reader, Config.class);
                    if (reader == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (JsonIOException | JsonSyntaxException | IOException e) {
                        Mod.LOGGER.error("Unable to read config file, restoring defaults!", e);
                        ConfigManager.save();
                        return new Config();
                    }
                }
                reader.close();
            }
            return config;
        }, EXECUTOR);
    }

    public static CompletableFuture<Void> save() {
        Mod.LOGGER.info("Saving config file to {}", (Object)configPath);
        return CompletableFuture.runAsync(() -> {
            try (BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);){
                GSON.toJson((Object)Optional.ofNullable(config).orElseGet(Config::new), (Appendable)writer);
            }
            catch (JsonIOException | IOException e) {
                Mod.LOGGER.error("Unable to write config file", e);
            }
        }, EXECUTOR);
    }

    static {
        configPath = FabricLoader.getInstance().getConfigDir().resolve("mcf-reap.json");
        GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().create();
        EXECUTOR = Executors.newSingleThreadExecutor(r -> new Thread(r, "mfc-reap Config Manager"));
    }
}

