/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.layer;

import net.coderbot.iris.Iris;
import net.coderbot.iris.gbuffer_overrides.matching.SpecialCondition;
import net.coderbot.iris.gl.state.StateUpdateNotifiers;
import net.coderbot.iris.pipeline.WorldRenderingPhase;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;

public class GbufferPrograms {
    private static boolean entities;
    private static boolean blockEntities;
    private static boolean outline;
    private static Runnable phaseChangeListener;

    private static void checkReentrancy() {
        if (entities || blockEntities || outline) {
            throw new IllegalStateException("GbufferPrograms in weird state, tried to call begin function when entities = " + entities + ", blockEntities = " + blockEntities + ", outline = " + outline);
        }
    }

    public static void beginEntities() {
        GbufferPrograms.checkReentrancy();
        GbufferPrograms.setPhase(WorldRenderingPhase.ENTITIES);
        entities = true;
    }

    public static void endEntities() {
        if (!entities) {
            throw new IllegalStateException("GbufferPrograms in weird state, tried to call endEntities when entities = false");
        }
        GbufferPrograms.setPhase(WorldRenderingPhase.NONE);
        entities = false;
    }

    public static void beginOutline() {
        GbufferPrograms.checkReentrancy();
        GbufferPrograms.setPhase(WorldRenderingPhase.OUTLINE);
        outline = true;
    }

    public static void endOutline() {
        if (!outline) {
            throw new IllegalStateException("GbufferPrograms in weird state, tried to call endOutline when outline = false");
        }
        GbufferPrograms.setPhase(WorldRenderingPhase.NONE);
        outline = false;
    }

    public static void beginBlockEntities() {
        GbufferPrograms.checkReentrancy();
        GbufferPrograms.setPhase(WorldRenderingPhase.BLOCK_ENTITIES);
        blockEntities = true;
    }

    public static void endBlockEntities() {
        if (!blockEntities) {
            throw new IllegalStateException("GbufferPrograms in weird state, tried to call endBlockEntities when blockEntities = false");
        }
        GbufferPrograms.setPhase(WorldRenderingPhase.NONE);
        blockEntities = false;
    }

    public static WorldRenderingPhase getCurrentPhase() {
        WorldRenderingPipeline worldRenderingPipeline = Iris.getPipelineManager().getPipelineNullable();
        if (worldRenderingPipeline != null) {
            return worldRenderingPipeline.getPhase();
        }
        return WorldRenderingPhase.NONE;
    }

    private static void setPhase(WorldRenderingPhase worldRenderingPhase) {
        WorldRenderingPipeline worldRenderingPipeline = Iris.getPipelineManager().getPipelineNullable();
        if (worldRenderingPipeline != null) {
            worldRenderingPipeline.setPhase(worldRenderingPhase);
        }
    }

    public static void setOverridePhase(WorldRenderingPhase worldRenderingPhase) {
        WorldRenderingPipeline worldRenderingPipeline = Iris.getPipelineManager().getPipelineNullable();
        if (worldRenderingPipeline != null) {
            worldRenderingPipeline.setOverridePhase(worldRenderingPhase);
        }
    }

    public static void runPhaseChangeNotifier() {
        if (phaseChangeListener != null) {
            phaseChangeListener.run();
        }
    }

    public static void setupSpecialRenderCondition(SpecialCondition specialCondition) {
        Iris.getPipelineManager().getPipeline().ifPresent(worldRenderingPipeline -> worldRenderingPipeline.setSpecialCondition(specialCondition));
    }

    public static void teardownSpecialRenderCondition(SpecialCondition specialCondition) {
        Iris.getPipelineManager().getPipeline().ifPresent(worldRenderingPipeline -> worldRenderingPipeline.setSpecialCondition(null));
    }

    public static void init() {
    }

    static {
        StateUpdateNotifiers.phaseChangeNotifier = runnable -> {
            phaseChangeListener = runnable;
        };
    }
}

