/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.newshader;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.coderbot.iris.block_rendering.BlockMaterialMapping;
import net.coderbot.iris.block_rendering.BlockRenderingSettings;
import net.coderbot.iris.gbuffer_overrides.matching.InputAvailability;
import net.coderbot.iris.gbuffer_overrides.matching.SpecialCondition;
import net.coderbot.iris.gbuffer_overrides.state.RenderTargetStateListener;
import net.coderbot.iris.gl.blending.AlphaTest;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.program.ProgramImages;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.gl.texture.DepthBufferFormat;
import net.coderbot.iris.gl.texture.InternalTextureFormat;
import net.coderbot.iris.mixin.LevelRendererAccessor;
import net.coderbot.iris.pipeline.ClearPass;
import net.coderbot.iris.pipeline.ClearPassCreator;
import net.coderbot.iris.pipeline.CustomTextureManager;
import net.coderbot.iris.pipeline.HorizonRenderer;
import net.coderbot.iris.pipeline.ShadowRenderer;
import net.coderbot.iris.pipeline.SodiumTerrainPipeline;
import net.coderbot.iris.pipeline.WorldRenderingPhase;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.CoreWorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.ExtendedShader;
import net.coderbot.iris.pipeline.newshader.FogMode;
import net.coderbot.iris.pipeline.newshader.NewShaderTests;
import net.coderbot.iris.pipeline.newshader.ShaderKey;
import net.coderbot.iris.pipeline.newshader.ShaderMap;
import net.coderbot.iris.pipeline.newshader.fallback.FallbackShader;
import net.coderbot.iris.postprocess.BufferFlipper;
import net.coderbot.iris.postprocess.CenterDepthSampler;
import net.coderbot.iris.postprocess.CompositeRenderer;
import net.coderbot.iris.postprocess.FinalPassRenderer;
import net.coderbot.iris.rendertarget.Blaze3dRenderTargetExt;
import net.coderbot.iris.rendertarget.NativeImageBackedSingleColorTexture;
import net.coderbot.iris.rendertarget.RenderTargets;
import net.coderbot.iris.samplers.IrisImages;
import net.coderbot.iris.samplers.IrisSamplers;
import net.coderbot.iris.shaderpack.PackShadowDirectives;
import net.coderbot.iris.shaderpack.ProgramFallbackResolver;
import net.coderbot.iris.shaderpack.ProgramSet;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.shaderpack.texture.TextureStage;
import net.coderbot.iris.shadows.ShadowRenderTargets;
import net.coderbot.iris.texture.TextureInfoCache;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.coderbot.iris.uniforms.FrameUpdateNotifier;
import net.coderbot.iris.vendored.joml.Vector3d;
import net.coderbot.iris.vendored.joml.Vector4f;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1044;
import net.minecraft.class_276;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_5294;
import net.minecraft.class_5944;
import net.minecraft.class_757;
import org.jetbrains.annotations.Nullable;

public class NewWorldRenderingPipeline
implements WorldRenderingPipeline,
CoreWorldRenderingPipeline,
RenderTargetStateListener {
    private final RenderTargets renderTargets;
    private final ShaderMap shaderMap;
    private ShadowRenderTargets shadowRenderTargets;
    private final Supplier<ShadowRenderTargets> shadowTargetsSupplier;
    private WorldRenderingPhase overridePhase = null;
    private WorldRenderingPhase phase = WorldRenderingPhase.NONE;
    private final Set<class_5944> loadedShaders;
    private final ImmutableList<ClearPass> clearPassesFull;
    private final ImmutableList<ClearPass> clearPasses;
    private final GlFramebuffer baseline;
    private final CompositeRenderer prepareRenderer;
    private final CompositeRenderer deferredRenderer;
    private final CompositeRenderer compositeRenderer;
    private final FinalPassRenderer finalPassRenderer;
    private final CustomTextureManager customTextureManager;
    private final class_1044 whitePixel;
    private final FrameUpdateNotifier updateNotifier;
    private final CenterDepthSampler centerDepthSampler;
    private final SodiumTerrainPipeline sodiumTerrainPipeline;
    private final ImmutableSet<Integer> flippedBeforeShadow;
    private final ImmutableSet<Integer> flippedAfterPrepare;
    private final ImmutableSet<Integer> flippedAfterTranslucent;
    public boolean isBeforeTranslucent;
    private final HorizonRenderer horizonRenderer = new HorizonRenderer();
    private final float sunPathRotation;
    private final boolean shouldRenderClouds;
    private final boolean shouldRenderUnderwaterOverlay;
    private final boolean shouldRenderVignette;
    private final boolean shouldWriteRainAndSnowToDepthBuffer;
    private final boolean shouldRenderParticlesBeforeDeferred;
    private final boolean oldLighting;
    private final OptionalInt forcedShadowRenderDistanceChunks;
    private boolean destroyed = false;
    private boolean isRenderingWorld;
    private boolean isMainBound;
    @Nullable
    private final ShadowRenderer shadowRenderer;
    private final int shadowMapResolution;

    public NewWorldRenderingPipeline(ProgramSet programSet) throws IOException {
        Path path2;
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            path2 = FabricLoader.getInstance().getGameDir().resolve("patched_shaders");
            if (Files.exists(path2, new LinkOption[0])) {
                Files.list(path2).forEach(path -> {
                    try {
                        Files.delete(path);
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                });
            }
            Files.createDirectories(path2, new FileAttribute[0]);
        }
        this.shouldRenderClouds = programSet.getPackDirectives().areCloudsEnabled();
        this.shouldRenderUnderwaterOverlay = programSet.getPackDirectives().underwaterOverlay();
        this.shouldRenderVignette = programSet.getPackDirectives().vignette();
        this.shouldWriteRainAndSnowToDepthBuffer = programSet.getPackDirectives().rainDepth();
        this.shouldRenderParticlesBeforeDeferred = programSet.getPackDirectives().areParticlesBeforeDeferred();
        this.oldLighting = programSet.getPackDirectives().isOldLighting();
        this.updateNotifier = new FrameUpdateNotifier();
        path2 = class_310.method_1551().method_1522();
        int n2 = path2.method_30278();
        int n3 = TextureInfoCache.INSTANCE.getInfo(n2).getInternalFormat();
        DepthBufferFormat depthBufferFormat = DepthBufferFormat.fromGlEnumOrDefault(n3);
        this.renderTargets = new RenderTargets(((class_276)path2).field_1482, ((class_276)path2).field_1481, n2, ((Blaze3dRenderTargetExt)((Object)path2)).iris$getDepthBufferVersion(), depthBufferFormat, programSet.getPackDirectives().getRenderTargetDirectives().getRenderTargetSettings());
        this.sunPathRotation = programSet.getPackDirectives().getSunPathRotation();
        PackShadowDirectives packShadowDirectives = programSet.getPackDirectives().getShadowDirectives();
        this.forcedShadowRenderDistanceChunks = packShadowDirectives.isDistanceRenderMulExplicit() ? ((double)packShadowDirectives.getDistanceRenderMul() >= 0.0 ? OptionalInt.of(((int)(packShadowDirectives.getDistance() * packShadowDirectives.getDistanceRenderMul()) + 15) / 16) : OptionalInt.of(-1)) : OptionalInt.empty();
        GlStateManager._activeTexture((int)33986);
        this.customTextureManager = new CustomTextureManager(programSet.getPackDirectives(), programSet.getPack().getCustomTextureDataMap(), programSet.getPack().getCustomNoiseTexture());
        this.whitePixel = new NativeImageBackedSingleColorTexture(255, 255, 255, 255);
        GlStateManager._activeTexture((int)33984);
        this.flippedBeforeShadow = ImmutableSet.of();
        BufferFlipper bufferFlipper = new BufferFlipper();
        this.centerDepthSampler = new CenterDepthSampler(programSet.getPackDirectives().getCenterDepthHalfLife());
        this.shadowMapResolution = programSet.getPackDirectives().getShadowDirectives().getResolution();
        this.shadowTargetsSupplier = () -> {
            if (this.shadowRenderTargets == null) {
                this.shadowRenderTargets = new ShadowRenderTargets(this.shadowMapResolution, new InternalTextureFormat[]{InternalTextureFormat.RGBA, InternalTextureFormat.RGBA});
            }
            return this.shadowRenderTargets;
        };
        this.prepareRenderer = new CompositeRenderer(programSet.getPackDirectives(), programSet.getPrepare(), this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, this.centerDepthSampler, bufferFlipper, this.shadowTargetsSupplier, this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.PREPARE, (Object2ObjectMap<String, IntSupplier>)Object2ObjectMaps.emptyMap()), programSet.getPackDirectives().getExplicitFlips("prepare_pre"));
        this.flippedAfterPrepare = bufferFlipper.snapshot();
        this.deferredRenderer = new CompositeRenderer(programSet.getPackDirectives(), programSet.getDeferred(), this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, this.centerDepthSampler, bufferFlipper, this.shadowTargetsSupplier, this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.DEFERRED, (Object2ObjectMap<String, IntSupplier>)Object2ObjectMaps.emptyMap()), programSet.getPackDirectives().getExplicitFlips("deferred_pre"));
        this.flippedAfterTranslucent = bufferFlipper.snapshot();
        this.compositeRenderer = new CompositeRenderer(programSet.getPackDirectives(), programSet.getComposite(), this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, this.centerDepthSampler, bufferFlipper, this.shadowTargetsSupplier, this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.COMPOSITE_AND_FINAL, (Object2ObjectMap<String, IntSupplier>)Object2ObjectMaps.emptyMap()), programSet.getPackDirectives().getExplicitFlips("composite_pre"));
        this.finalPassRenderer = new FinalPassRenderer(programSet, this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, bufferFlipper.snapshot(), this.centerDepthSampler, this.shadowTargetsSupplier, this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.COMPOSITE_AND_FINAL, (Object2ObjectMap<String, IntSupplier>)Object2ObjectMaps.emptyMap()), this.compositeRenderer.getFlippedAtLeastOnceFinal());
        Supplier<ImmutableSet> supplier = () -> this.isBeforeTranslucent ? this.flippedAfterPrepare : this.flippedAfterTranslucent;
        IntFunction<ProgramSamplers> intFunction = n -> {
            ProgramSamplers.Builder builder = ProgramSamplers.builder(n, IrisSamplers.WORLD_RESERVED_TEXTURE_UNITS);
            ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(builder, this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.GBUFFERS_AND_SHADOW, (Object2ObjectMap<String, IntSupplier>)Object2ObjectMaps.emptyMap()));
            IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, supplier, this.renderTargets, false);
            IrisSamplers.addLevelSamplers(customTextureSamplerInterceptor, (class_1044)this.customTextureManager.getNormals(), (class_1044)this.customTextureManager.getSpecular(), this.whitePixel, new InputAvailability(true, true, false));
            IrisSamplers.addWorldDepthSamplers(customTextureSamplerInterceptor, this.renderTargets);
            IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.customTextureManager.getNoiseTexture());
            if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor)) {
                IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, Objects.requireNonNull(this.shadowRenderTargets));
            }
            return builder.build();
        };
        IntFunction<ProgramImages> intFunction2 = n -> {
            ProgramImages.Builder builder = ProgramImages.builder(n);
            IrisImages.addRenderTargetImages(builder, supplier, this.renderTargets);
            if (IrisImages.hasShadowImages(builder)) {
                IrisImages.addShadowColorImages(builder, Objects.requireNonNull(this.shadowRenderTargets));
            }
            return builder.build();
        };
        IntFunction<ProgramSamplers> intFunction3 = n -> {
            ProgramSamplers.Builder builder = ProgramSamplers.builder(n, IrisSamplers.WORLD_RESERVED_TEXTURE_UNITS);
            ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(builder, this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.GBUFFERS_AND_SHADOW, (Object2ObjectMap<String, IntSupplier>)Object2ObjectMaps.emptyMap()));
            IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, () -> this.flippedBeforeShadow, this.renderTargets, false);
            IrisSamplers.addLevelSamplers(customTextureSamplerInterceptor, (class_1044)this.customTextureManager.getNormals(), (class_1044)this.customTextureManager.getSpecular(), this.whitePixel, new InputAvailability(true, true, false));
            IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.customTextureManager.getNoiseTexture());
            if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor)) {
                IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, Objects.requireNonNull(this.shadowRenderTargets));
            }
            return builder.build();
        };
        IntFunction<ProgramImages> intFunction4 = n -> {
            ProgramImages.Builder builder = ProgramImages.builder(n);
            IrisImages.addRenderTargetImages(builder, () -> this.flippedBeforeShadow, this.renderTargets);
            if (IrisImages.hasShadowImages(builder)) {
                IrisImages.addShadowColorImages(builder, Objects.requireNonNull(this.shadowRenderTargets));
            }
            return builder.build();
        };
        this.baseline = this.renderTargets.createFramebufferWritingToMain(new int[]{0});
        this.loadedShaders = new HashSet<class_5944>();
        ProgramFallbackResolver programFallbackResolver = new ProgramFallbackResolver(programSet);
        this.shaderMap = new ShaderMap(shaderKey -> {
            try {
                if (shaderKey.isShadow()) {
                    if (this.shadowRenderTargets != null) {
                        return this.createShadowShader(shaderKey.getName(), programFallbackResolver.resolve(shaderKey.getProgram()), (ShaderKey)((Object)shaderKey));
                    }
                    return null;
                }
                return this.createShader(shaderKey.getName(), programFallbackResolver.resolve(shaderKey.getProgram()), (ShaderKey)((Object)shaderKey));
            }
            catch (IOException iOException) {
                this.destroyShaders();
                throw new RuntimeException(iOException);
            }
            catch (RuntimeException runtimeException) {
                this.destroyShaders();
                throw runtimeException;
            }
        });
        BlockRenderingSettings.INSTANCE.setBlockStateIds(BlockMaterialMapping.createBlockStateIdMap(programSet.getPack().getIdMap().getBlockProperties()));
        BlockRenderingSettings.INSTANCE.setBlockTypeIds(BlockMaterialMapping.createBlockTypeMap(programSet.getPack().getIdMap().getBlockRenderTypeMap()));
        BlockRenderingSettings.INSTANCE.setEntityIds(programSet.getPack().getIdMap().getEntityIdMap());
        BlockRenderingSettings.INSTANCE.setAmbientOcclusionLevel(programSet.getPackDirectives().getAmbientOcclusionLevel());
        BlockRenderingSettings.INSTANCE.setDisableDirectionalShading(this.shouldDisableDirectionalShading());
        BlockRenderingSettings.INSTANCE.setUseSeparateAo(programSet.getPackDirectives().shouldUseSeparateAo());
        BlockRenderingSettings.INSTANCE.setUseExtendedVertexFormat(true);
        this.clearPassesFull = ClearPassCreator.createClearPasses(this.renderTargets, true, programSet.getPackDirectives().getRenderTargetDirectives());
        this.clearPasses = ClearPassCreator.createClearPasses(this.renderTargets, false, programSet.getPackDirectives().getRenderTargetDirectives());
        if (this.shadowRenderTargets != null) {
            class_5944 class_59442 = this.shaderMap.getShader(ShaderKey.SHADOW_TERRAIN_CUTOUT);
            boolean bl = false;
            if (class_59442 instanceof ExtendedShader) {
                ExtendedShader extendedShader = (ExtendedShader)class_59442;
                bl = IrisImages.hasShadowImages(extendedShader) || IrisImages.hasRenderTargetImages(extendedShader, this.renderTargets);
            }
            this.shadowRenderer = new ShadowRenderer(programSet.getShadow().orElse(null), programSet.getPackDirectives(), this.shadowRenderTargets, bl);
        } else {
            this.shadowRenderer = null;
        }
        this.sodiumTerrainPipeline = new SodiumTerrainPipeline(this, programSet, intFunction, this.shadowRenderTargets == null ? null : intFunction3, intFunction2, intFunction4, this.renderTargets, this.flippedAfterPrepare, this.flippedAfterTranslucent, this.shadowRenderTargets != null ? this.shadowRenderTargets.getFramebuffer() : null);
    }

    @SafeVarargs
    private static <T> Optional<T> first(Optional<T> ... optionalArray) {
        for (Optional<T> optional : optionalArray) {
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    private class_5944 createShader(String string, Optional<ProgramSource> optional, ShaderKey shaderKey) throws IOException {
        if (!optional.isPresent()) {
            return this.createFallbackShader(string, shaderKey);
        }
        return this.createShader(string, optional.get(), shaderKey.getAlphaTest(), shaderKey.getVertexFormat(), shaderKey.getFogMode(), shaderKey.shouldIgnoreLightmap());
    }

    private class_5944 createShader(String string, ProgramSource programSource, AlphaTest alphaTest, class_293 class_2932, FogMode fogMode, boolean bl) throws IOException {
        GlFramebuffer glFramebuffer = this.renderTargets.createGbufferFramebuffer(this.flippedAfterPrepare, programSource.getDirectives().getDrawBuffers());
        GlFramebuffer glFramebuffer2 = this.renderTargets.createGbufferFramebuffer(this.flippedAfterTranslucent, programSource.getDirectives().getDrawBuffers());
        ExtendedShader extendedShader = NewShaderTests.create(string, programSource, glFramebuffer, glFramebuffer2, this.baseline, alphaTest, class_2932, this.updateNotifier, this, fogMode, bl);
        this.loadedShaders.add(extendedShader);
        Supplier<ImmutableSet<Integer>> supplier = () -> this.isBeforeTranslucent ? this.flippedAfterPrepare : this.flippedAfterTranslucent;
        this.addGbufferOrShadowSamplers(extendedShader, supplier, false);
        return extendedShader;
    }

    private class_5944 createFallbackShader(String string, ShaderKey shaderKey) throws IOException {
        GlFramebuffer glFramebuffer = this.renderTargets.createGbufferFramebuffer(this.flippedAfterPrepare, new int[]{0});
        GlFramebuffer glFramebuffer2 = this.renderTargets.createGbufferFramebuffer(this.flippedAfterTranslucent, new int[]{0});
        FallbackShader fallbackShader = NewShaderTests.createFallback(string, glFramebuffer, glFramebuffer2, shaderKey.getAlphaTest(), shaderKey.getVertexFormat(), null, this, shaderKey.getFogMode(), shaderKey.hasDiffuseLighting(), shaderKey.isIntensity(), shaderKey.shouldIgnoreLightmap());
        this.loadedShaders.add(fallbackShader);
        return fallbackShader;
    }

    private class_5944 createShadowShader(String string, Optional<ProgramSource> optional, ShaderKey shaderKey) throws IOException {
        if (!optional.isPresent()) {
            return this.createFallbackShadowShader(string, shaderKey);
        }
        return this.createShadowShader(string, optional.get(), shaderKey.getAlphaTest(), shaderKey.getVertexFormat(), shaderKey.shouldIgnoreLightmap());
    }

    private class_5944 createFallbackShadowShader(String string, ShaderKey shaderKey) throws IOException {
        GlFramebuffer glFramebuffer = this.shadowRenderTargets.getFramebuffer();
        FallbackShader fallbackShader = NewShaderTests.createFallback(string, glFramebuffer, glFramebuffer, shaderKey.getAlphaTest(), shaderKey.getVertexFormat(), BlendModeOverride.OFF, this, shaderKey.getFogMode(), shaderKey.hasDiffuseLighting(), shaderKey.isIntensity(), shaderKey.shouldIgnoreLightmap());
        this.loadedShaders.add(fallbackShader);
        return fallbackShader;
    }

    private class_5944 createShadowShader(String string, ProgramSource programSource, AlphaTest alphaTest, class_293 class_2932, boolean bl) throws IOException {
        GlFramebuffer glFramebuffer = this.shadowRenderTargets.getFramebuffer();
        ExtendedShader extendedShader = NewShaderTests.create(string, programSource, glFramebuffer, glFramebuffer, this.baseline, alphaTest, class_2932, this.updateNotifier, this, FogMode.PER_VERTEX, bl);
        this.loadedShaders.add(extendedShader);
        Supplier<ImmutableSet<Integer>> supplier = () -> this.flippedBeforeShadow;
        this.addGbufferOrShadowSamplers(extendedShader, supplier, true);
        return extendedShader;
    }

    private void addGbufferOrShadowSamplers(ExtendedShader extendedShader, Supplier<ImmutableSet<Integer>> supplier, boolean bl) {
        TextureStage textureStage = TextureStage.GBUFFERS_AND_SHADOW;
        ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(extendedShader, this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)textureStage, (Object2ObjectMap<String, IntSupplier>)Object2ObjectMaps.emptyMap()));
        IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, supplier, this.renderTargets, false);
        IrisImages.addRenderTargetImages(extendedShader, supplier, this.renderTargets);
        customTextureSamplerInterceptor.addDynamicSampler(() -> ((NativeImageBackedSingleColorTexture)this.customTextureManager.getNormals()).method_4624(), "normals");
        customTextureSamplerInterceptor.addDynamicSampler(() -> ((NativeImageBackedSingleColorTexture)this.customTextureManager.getSpecular()).method_4624(), "specular");
        IrisSamplers.addWorldDepthSamplers(customTextureSamplerInterceptor, this.renderTargets);
        IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.customTextureManager.getNoiseTexture());
        if (bl || IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor)) {
            if (!bl) {
                this.shadowTargetsSupplier.get();
            }
            IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, Objects.requireNonNull(this.shadowRenderTargets));
        }
        if (bl || IrisImages.hasShadowImages(extendedShader)) {
            IrisImages.addShadowColorImages(extendedShader, Objects.requireNonNull(this.shadowRenderTargets));
        }
    }

    @Override
    public WorldRenderingPhase getPhase() {
        if (this.overridePhase != null) {
            return this.overridePhase;
        }
        return this.phase;
    }

    @Override
    public void beginSodiumTerrainRendering() {
    }

    @Override
    public void endSodiumTerrainRendering() {
    }

    @Override
    public void setOverridePhase(WorldRenderingPhase worldRenderingPhase) {
        this.overridePhase = worldRenderingPhase;
    }

    @Override
    public void setPhase(WorldRenderingPhase worldRenderingPhase) {
        this.phase = worldRenderingPhase;
    }

    @Override
    public void setSpecialCondition(SpecialCondition specialCondition) {
    }

    @Override
    public RenderTargetStateListener getRenderTargetStateListener() {
        return this;
    }

    @Override
    public void beginLevelRendering() {
        ImmutableList<ClearPass> immutableList;
        this.isRenderingWorld = true;
        RenderSystem.activeTexture((int)33984);
        if (this.shadowRenderTargets != null) {
            this.shadowRenderTargets.getFramebuffer().bind();
            RenderSystem.clearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.clearDepth((double)1.0);
            RenderSystem.clear((int)16640, (boolean)false);
        }
        this.updateNotifier.onNewFrame();
        class_276 class_2762 = class_310.method_1551().method_1522();
        int n = class_2762.method_30278();
        int n2 = TextureInfoCache.INSTANCE.getInfo(n).getInternalFormat();
        DepthBufferFormat depthBufferFormat = DepthBufferFormat.fromGlEnumOrDefault(n2);
        this.renderTargets.resizeIfNeeded(((Blaze3dRenderTargetExt)class_2762).iris$getDepthBufferVersion(), n, class_2762.field_1482, class_2762.field_1481, depthBufferFormat);
        if (this.renderTargets.isFullClearRequired()) {
            this.renderTargets.onFullClear();
            immutableList = this.clearPassesFull;
        } else {
            immutableList = this.clearPasses;
        }
        Vector3d vector3d = CapturedRenderingState.INSTANCE.getFogColor();
        Vector4f vector4f = new Vector4f((float)vector3d.x, (float)vector3d.y, (float)vector3d.z, 1.0f);
        for (ClearPass clearPass : immutableList) {
            clearPass.execute(vector4f);
        }
        class_2762.method_1235(true);
        this.isMainBound = true;
        this.isBeforeTranslucent = true;
        this.setPhase(WorldRenderingPhase.SKY);
        UnmodifiableIterator unmodifiableIterator = class_310.method_1551().field_1687.method_28103().method_29992();
        if (unmodifiableIterator == class_5294.class_5401.field_25640) {
            RenderSystem.disableTexture();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShaderColor((float)vector4f.x, (float)vector4f.y, (float)vector4f.z, (float)vector4f.w);
            this.horizonRenderer.renderHorizon(CapturedRenderingState.INSTANCE.getGbufferModelView(), CapturedRenderingState.INSTANCE.getGbufferProjection(), class_757.method_34539());
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableTexture();
        }
    }

    @Override
    public void renderShadows(LevelRendererAccessor levelRendererAccessor, class_4184 class_41842) {
        if (this.shadowRenderer != null) {
            this.shadowRenderer.renderShadows(levelRendererAccessor, class_41842);
        }
        this.prepareRenderer.renderAll();
    }

    @Override
    public void addDebugText(List<String> list) {
        if (this.shadowRenderer != null) {
            list.add("");
            this.shadowRenderer.addDebugText(list);
        } else {
            list.add("");
            list.add("[Iris] Shadow Maps: not used by shader pack");
        }
    }

    @Override
    public OptionalInt getForcedShadowRenderDistanceChunksForDisplay() {
        return this.forcedShadowRenderDistanceChunks;
    }

    @Override
    public void beginHand() {
        this.renderTargets.copyPreHandDepth();
    }

    @Override
    public void beginTranslucents() {
        if (this.destroyed) {
            throw new IllegalStateException("Tried to use a destroyed world rendering pipeline");
        }
        this.isBeforeTranslucent = false;
        this.renderTargets.copyPreTranslucentDepth();
        this.deferredRenderer.renderAll();
        RenderSystem.enableBlend();
        RenderSystem.setShader(class_757::method_34539);
    }

    @Override
    public void finalizeLevelRendering() {
        this.isRenderingWorld = false;
        this.centerDepthSampler.sampleCenterDepth();
        this.compositeRenderer.renderAll();
        this.finalPassRenderer.renderFinalPass();
    }

    @Override
    public boolean shouldDisableVanillaEntityShadows() {
        return this.shadowRenderer != null;
    }

    @Override
    public boolean shouldRenderClouds() {
        return this.shouldRenderClouds;
    }

    @Override
    public boolean shouldRenderUnderwaterOverlay() {
        return this.shouldRenderUnderwaterOverlay;
    }

    @Override
    public boolean shouldRenderVignette() {
        return this.shouldRenderVignette;
    }

    @Override
    public boolean shouldWriteRainAndSnowToDepthBuffer() {
        return this.shouldWriteRainAndSnowToDepthBuffer;
    }

    @Override
    public boolean shouldRenderParticlesBeforeDeferred() {
        return this.shouldRenderParticlesBeforeDeferred;
    }

    @Override
    public boolean shouldDisableDirectionalShading() {
        return !this.oldLighting;
    }

    @Override
    public ShaderMap getShaderMap() {
        return this.shaderMap;
    }

    private void destroyShaders() {
        this.loadedShaders.forEach(class_59442 -> {
            class_59442.method_34585();
            class_59442.close();
        });
    }

    @Override
    public void destroy() {
        int n;
        this.destroyed = true;
        this.destroyShaders();
        for (n = 0; n < 16; ++n) {
            GlStateManager.glActiveTexture((int)(33984 + n));
            GlStateManager._bindTexture((int)0);
        }
        GlStateManager.glActiveTexture((int)33984);
        for (n = 0; n < 12; ++n) {
            RenderSystem.setShaderTexture((int)n, (int)0);
        }
        this.compositeRenderer.destroy();
        this.customTextureManager.destroy();
        this.whitePixel.method_4528();
        GlStateManager._glBindFramebuffer((int)36008, (int)0);
        GlStateManager._glBindFramebuffer((int)36009, (int)0);
        GlStateManager._glBindFramebuffer((int)36160, (int)0);
        class_310.method_1551().method_1522().method_1235(false);
        this.renderTargets.destroy();
    }

    @Override
    public boolean shouldOverrideShaders() {
        return this.isRenderingWorld && this.isMainBound;
    }

    @Override
    public SodiumTerrainPipeline getSodiumTerrainPipeline() {
        return this.sodiumTerrainPipeline;
    }

    @Override
    public FrameUpdateNotifier getFrameUpdateNotifier() {
        return this.updateNotifier;
    }

    @Override
    public float getSunPathRotation() {
        return this.sunPathRotation;
    }

    protected class_1044 getWhitePixel() {
        return this.whitePixel;
    }

    @Override
    public void beginPostChain() {
    }

    @Override
    public void endPostChain() {
    }

    @Override
    public void setIsMainBound(boolean bl) {
        this.isMainBound = bl;
    }
}

