/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.coderbot.iris.shaderpack.ProgramSet;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.shaderpack.loading.ProgramId;
import org.jetbrains.annotations.Nullable;

public class ProgramFallbackResolver {
    private final ProgramSet programs;
    private final Map<ProgramId, ProgramSource> cache;

    public ProgramFallbackResolver(ProgramSet programSet) {
        this.programs = programSet;
        this.cache = new HashMap<ProgramId, ProgramSource>();
    }

    public Optional<ProgramSource> resolve(ProgramId programId) {
        return Optional.ofNullable(this.resolveNullable(programId));
    }

    @Nullable
    public ProgramSource resolveNullable(ProgramId programId) {
        ProgramId programId2;
        if (this.cache.containsKey((Object)programId)) {
            return this.cache.get((Object)programId);
        }
        ProgramSource programSource = this.programs.get(programId).orElse(null);
        if (programSource == null && (programId2 = (ProgramId)programId.getFallback().orElse(null)) != null) {
            programSource = this.resolveNullable(programId2);
        }
        this.cache.put(programId, programSource);
        return programSource;
    }
}

