/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack.option;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import net.coderbot.iris.Iris;
import net.coderbot.iris.shaderpack.option.BooleanOption;
import net.coderbot.iris.shaderpack.option.MergedBooleanOption;
import net.coderbot.iris.shaderpack.option.MergedStringOption;
import net.coderbot.iris.shaderpack.option.OptionLocation;
import net.coderbot.iris.shaderpack.option.StringOption;

public class OptionSet {
    private final ImmutableMap<String, MergedBooleanOption> booleanOptions;
    private final ImmutableMap<String, MergedStringOption> stringOptions;

    private OptionSet(Builder builder) {
        this.booleanOptions = ImmutableMap.copyOf(builder.booleanOptions);
        this.stringOptions = ImmutableMap.copyOf(builder.stringOptions);
    }

    public ImmutableMap<String, MergedBooleanOption> getBooleanOptions() {
        return this.booleanOptions;
    }

    public ImmutableMap<String, MergedStringOption> getStringOptions() {
        return this.stringOptions;
    }

    public boolean isBooleanOption(String string) {
        return this.booleanOptions.containsKey((Object)string);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, MergedBooleanOption> booleanOptions = new HashMap<String, MergedBooleanOption>();
        private final Map<String, MergedStringOption> stringOptions = new HashMap<String, MergedStringOption>();

        public void addAll(OptionSet optionSet) {
            if (this.booleanOptions.isEmpty()) {
                this.booleanOptions.putAll((Map<String, MergedBooleanOption>)optionSet.booleanOptions);
            } else {
                optionSet.booleanOptions.values().forEach(this::addBooleanOption);
            }
            if (this.stringOptions.isEmpty()) {
                this.stringOptions.putAll((Map<String, MergedStringOption>)optionSet.stringOptions);
            } else {
                optionSet.stringOptions.values().forEach(this::addStringOption);
            }
        }

        public void addBooleanOption(OptionLocation optionLocation, BooleanOption booleanOption) {
            this.addBooleanOption(new MergedBooleanOption(optionLocation, booleanOption));
        }

        public void addBooleanOption(MergedBooleanOption mergedBooleanOption) {
            MergedBooleanOption mergedBooleanOption2;
            BooleanOption booleanOption = mergedBooleanOption.getOption();
            MergedBooleanOption mergedBooleanOption3 = this.booleanOptions.get(booleanOption.getName());
            if (mergedBooleanOption3 != null) {
                mergedBooleanOption2 = mergedBooleanOption3.merge(mergedBooleanOption);
                if (mergedBooleanOption2 == null) {
                    Iris.logger.warn("Ignoring ambiguous boolean option " + booleanOption.getName());
                    this.booleanOptions.remove(booleanOption.getName());
                    return;
                }
            } else {
                mergedBooleanOption2 = mergedBooleanOption;
            }
            this.booleanOptions.put(booleanOption.getName(), mergedBooleanOption2);
        }

        public void addStringOption(OptionLocation optionLocation, StringOption stringOption) {
            this.addStringOption(new MergedStringOption(optionLocation, stringOption));
        }

        public void addStringOption(MergedStringOption mergedStringOption) {
            MergedStringOption mergedStringOption2;
            StringOption stringOption = mergedStringOption.getOption();
            MergedStringOption mergedStringOption3 = this.stringOptions.get(stringOption.getName());
            if (mergedStringOption3 != null) {
                mergedStringOption2 = mergedStringOption3.merge(mergedStringOption);
                if (mergedStringOption2 == null) {
                    Iris.logger.warn("Ignoring ambiguous string option " + stringOption.getName());
                    this.stringOptions.remove(stringOption.getName());
                    return;
                }
            } else {
                mergedStringOption2 = mergedStringOption;
            }
            this.stringOptions.put(stringOption.getName(), mergedStringOption2);
        }

        public OptionSet build() {
            return new OptionSet(this);
        }
    }
}

