/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.mod.vanilla;

import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.color.ColorManager;
import journeymap.client.cartography.color.ColoredSprite;
import journeymap.client.cartography.color.RGB;
import journeymap.client.mod.IBlockColorProxy;
import journeymap.client.model.BlockFlag;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.client.properties.CoreProperties;
import journeymap.client.world.JmBlockAccess;
import journeymap.common.Journeymap;
import journeymap.common.accessors.FluidAccess;
import journeymap.common.log.LogFormatter;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_324;
import net.minecraft.class_3609;
import org.apache.logging.log4j.Logger;

public class VanillaBlockColorProxy
implements IBlockColorProxy,
FluidAccess {
    static Logger logger = Journeymap.getLogger();
    private final class_324 blockColors = class_310.method_1551().method_1505();
    private final CoreProperties coreProperties = JourneymapClient.getInstance().getCoreProperties();

    @Override
    public int deriveBlockColor(BlockMD blockMD, @Nullable ChunkMD chunkMD, @Nullable class_2338 blockPos) {
        class_2680 blockState = blockMD.getBlockState();
        try {
            if (blockState.method_26204() instanceof class_2404) {
                return VanillaBlockColorProxy.getSpriteColor(blockMD, 0xBCBCBC, chunkMD, blockPos);
            }
            Integer color = VanillaBlockColorProxy.getSpriteColor(blockMD, null, chunkMD, blockPos);
            if (color == null) {
                color = VanillaBlockColorProxy.setBlockColorToMaterial(blockMD);
            }
            return color;
        }
        catch (Throwable e) {
            logger.error("Error deriving color for " + blockMD + ": " + LogFormatter.toPartialString(e));
            blockMD.addFlags(BlockFlag.Error);
            return VanillaBlockColorProxy.setBlockColorToMaterial(blockMD);
        }
    }

    @Override
    public int getBlockColor(ChunkMD chunkMD, BlockMD blockMD, class_2338 blockPos) {
        boolean showBiomeWaterColor = this.coreProperties.mapWaterBiomeColors.get();
        int result = blockMD.getTextureColor(chunkMD, blockPos);
        if (blockMD.isFoliage()) {
            result = RGB.adjustBrightness(result, 0.8f);
        } else if (!(!blockMD.isFluid() || blockMD.isWater() && showBiomeWaterColor)) {
            class_3609 fluidBlock = this.getFluid(blockMD.getBlock());
            return RGB.multiply(result, FluidRenderHandlerRegistry.INSTANCE.get(fluidBlock.method_15750()).getFluidColor(null, null, fluidBlock.method_15785()));
        }
        return RGB.multiply(result, this.getColorMultiplier(chunkMD, blockMD, blockPos, blockMD.getBlock().method_9604(blockMD.getBlockState()).ordinal()));
    }

    public int getColorMultiplier(ChunkMD chunkMD, BlockMD blockMD, class_2338 blockPos, int tintIndex) {
        boolean blendFoliage = this.coreProperties.mapBlendFoliage.get();
        boolean blendGrass = this.coreProperties.mapBlendGrass.get();
        boolean blendWater = this.coreProperties.mapBlendWater.get();
        if (!blendGrass && blockMD.isGrass()) {
            return chunkMD.getBiome(blockPos).method_8711((double)blockPos.method_10263(), (double)blockPos.method_10260());
        }
        if (!blendFoliage && blockMD.isFoliage()) {
            return chunkMD.getBiome(blockPos).method_8698();
        }
        if (!blendWater && blockMD.isWater()) {
            return chunkMD.getBiome(blockPos).method_8687();
        }
        return this.blockColors.method_1697(blockMD.getBlockState(), (class_1920)JmBlockAccess.INSTANCE, blockPos, tintIndex);
    }

    public static Integer getSpriteColor(@Nonnull BlockMD blockMD, @Nullable Integer defaultColor, @Nullable ChunkMD chunkMD, @Nullable class_2338 blockPos) {
        Collection<ColoredSprite> sprites = blockMD.getBlockSpritesProxy().getSprites(blockMD, chunkMD, blockPos);
        float[] rgba = ColorManager.INSTANCE.getAverageColor(sprites);
        if (rgba != null) {
            return RGB.toInteger(rgba);
        }
        return defaultColor;
    }

    public static int setBlockColorToError(BlockMD blockMD) {
        blockMD.setAlpha(0.0f);
        blockMD.addFlags(BlockFlag.Ignore, BlockFlag.Error);
        blockMD.setColor(-1);
        return -1;
    }

    public static int setBlockColorToMaterial(BlockMD blockMD) {
        try {
            blockMD.setAlpha(1.0f);
            blockMD.addFlags(BlockFlag.Ignore);
            return blockMD.setColor(blockMD.getBlockState().method_26207().method_15803().field_16011);
        }
        catch (Exception e) {
            logger.warn(String.format("Failed to use MaterialMapColor, marking as error: %s", blockMD));
            return VanillaBlockColorProxy.setBlockColorToError(blockMD);
        }
    }
}

