/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import journeymap.client.data.DataCache;
import journeymap.client.model.EntityDTO;
import journeymap.client.properties.InGameMapProperties;
import journeymap.client.render.draw.DrawEntityStep;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.map.GridRenderer;
import journeymap.client.render.texture.TextureImpl;
import journeymap.client.ui.minimap.EntityDisplay;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.class_1309;
import net.minecraft.class_1657;

public class RadarDrawStepFactory {
    public List<DrawStep> prepareSteps(List<EntityDTO> entityDTOs, GridRenderer grid, InGameMapProperties mapProperties) {
        boolean showAnimals = mapProperties.showAnimals.get();
        boolean showPets = mapProperties.showPets.get();
        boolean showVillagers = mapProperties.showVillagers.get();
        EntityDisplay mobDisplay = (EntityDisplay)((Object)mapProperties.mobDisplay.get());
        EntityDisplay playerDisplay = (EntityDisplay)((Object)mapProperties.playerDisplay.get());
        boolean showMobHeading = mapProperties.showMobHeading.get();
        boolean showPlayerHeading = mapProperties.showPlayerHeading.get();
        boolean showEntityNames = mapProperties.showEntityNames.get();
        float mobDisplayDrawScale = mapProperties.mobDisplayScale.get().floatValue();
        float playerDisplayDrawScale = mapProperties.playerDisplayScale.get().floatValue();
        ArrayList<DrawStep> drawStepList = new ArrayList<DrawStep>();
        try {
            for (EntityDTO dto : entityDTOs) {
                try {
                    boolean isPet;
                    TextureImpl entityIcon = null;
                    TextureImpl locatorImg = null;
                    class_1309 entityLiving = (class_1309)dto.entityLivingRef.get();
                    boolean isPlayer = entityLiving instanceof class_1657;
                    if (entityLiving == null || grid.getPixel(dto.posX, dto.posZ) == null) continue;
                    boolean bl = isPet = dto.owner != null && !Strings.isNullOrEmpty((String)dto.owner);
                    if (!showPets && isPet || !showAnimals && dto.passiveAnimal && !isPlayer && (!isPet || !showPets) || !showVillagers && (dto.profession != null || dto.npc)) continue;
                    DrawEntityStep drawStep = DataCache.INSTANCE.getDrawEntityStep(entityLiving);
                    if (isPlayer) {
                        locatorImg = EntityDisplay.getLocatorTexture(playerDisplay, showPlayerHeading);
                        entityIcon = EntityDisplay.getEntityTexture(playerDisplay, entityLiving.method_5667(), entityLiving.method_5476().getString());
                        drawStep.update(playerDisplay, locatorImg, entityIcon, dto.color, showPlayerHeading, showEntityNames, playerDisplayDrawScale);
                        drawStepList.add(drawStep);
                        continue;
                    }
                    locatorImg = EntityDisplay.getLocatorTexture(mobDisplay, showMobHeading);
                    entityIcon = EntityDisplay.getEntityTexture(mobDisplay, dto.entityIconLocation);
                    EntityDisplay actualDisplay = mobDisplay;
                    if (!mobDisplay.isDots() && entityIcon == null) {
                        actualDisplay = mobDisplay.getDot();
                        entityIcon = EntityDisplay.getEntityTexture(actualDisplay, dto.entityIconLocation);
                    }
                    drawStep.update(actualDisplay, locatorImg, entityIcon, dto.color, showMobHeading, showEntityNames, mobDisplayDrawScale);
                    drawStepList.add(drawStep);
                }
                catch (Exception e) {
                    Journeymap.getLogger().error("Exception during prepareSteps: " + LogFormatter.toString(e));
                }
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Throwable during prepareSteps: " + LogFormatter.toString(t));
        }
        return drawStepList;
    }
}

