/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.CommandDispatcher;
import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.util.NamespaceAlias;
import io.github.apace100.calio.mixin.CriteriaRegistryInvoker;
import io.github.apace100.calio.resource.OrderedResourceListenerInitializer;
import io.github.apace100.calio.resource.OrderedResourceListenerManager;
import io.github.apace100.origins.badge.BadgeManager;
import io.github.apace100.origins.command.OriginCommand;
import io.github.apace100.origins.networking.ModPacketsC2S;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayers;
import io.github.apace100.origins.origin.OriginManager;
import io.github.apace100.origins.power.OriginsEntityConditions;
import io.github.apace100.origins.power.OriginsPowerTypes;
import io.github.apace100.origins.registry.ModBlocks;
import io.github.apace100.origins.registry.ModEnchantments;
import io.github.apace100.origins.registry.ModEntities;
import io.github.apace100.origins.registry.ModItems;
import io.github.apace100.origins.registry.ModLoot;
import io.github.apace100.origins.registry.ModTags;
import io.github.apace100.origins.util.ChoseOriginCriterion;
import io.github.apace100.origins.util.OriginsConfigSerializer;
import io.github.apace100.origins.util.OriginsJsonConfigSerializer;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_179;
import net.minecraft.class_2168;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3518;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Origins
implements ModInitializer,
OrderedResourceListenerInitializer {
    public static final String MODID = "origins";
    public static String VERSION = "";
    public static int[] SEMVER;
    public static final Logger LOGGER;
    public static ServerConfig config;
    private static ConfigSerializer<ServerConfig> configSerializer;

    public void onInitialize() {
        FabricLoader.getInstance().getModContainer(MODID).ifPresent(modContainer -> {
            VERSION = modContainer.getMetadata().getVersion().getFriendlyString();
            if (VERSION.contains("+")) {
                VERSION = VERSION.split("\\+")[0];
            }
            if (VERSION.contains("-")) {
                VERSION = VERSION.split("-")[0];
            }
            String[] splitVersion = VERSION.split("\\.");
            SEMVER = new int[splitVersion.length];
            for (int i = 0; i < SEMVER.length; ++i) {
                Origins.SEMVER[i] = Integer.parseInt(splitVersion[i]);
            }
        });
        LOGGER.info("Origins " + VERSION + " is initializing. Have fun!");
        AutoConfig.register(ServerConfig.class, (definition, configClass) -> {
            configSerializer = new OriginsJsonConfigSerializer(definition, configClass, new OriginsConfigSerializer(definition, configClass));
            return configSerializer;
        });
        config = (ServerConfig)AutoConfig.getConfigHolder(ServerConfig.class).getConfig();
        NamespaceAlias.addAlias((String)MODID, (String)"apoli");
        OriginsPowerTypes.register();
        OriginsEntityConditions.register();
        ModBlocks.register();
        ModItems.register();
        ModTags.register();
        ModPacketsC2S.register();
        ModEnchantments.register();
        ModEntities.register();
        ModLoot.registerLootTables();
        Origin.init();
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> OriginCommand.register((CommandDispatcher<class_2168>)dispatcher));
        CriteriaRegistryInvoker.callRegister((class_179)ChoseOriginCriterion.INSTANCE);
    }

    public static void serializeConfig() {
        try {
            configSerializer.serialize((ConfigData)config);
        }
        catch (ConfigSerializer.SerializationException e) {
            LOGGER.error("Failed serialization of config file: " + e.getMessage());
        }
    }

    public static class_2960 identifier(String path) {
        return new class_2960(MODID, path);
    }

    public void registerResourceListeners(OrderedResourceListenerManager manager) {
        class_2960 powerData = Apoli.identifier((String)"powers");
        class_2960 originData = Origins.identifier(MODID);
        manager.register(class_3264.field_14190, (IdentifiableResourceReloadListener)new OriginManager()).after(powerData).complete();
        manager.register(class_3264.field_14190, (IdentifiableResourceReloadListener)new OriginLayers()).after(originData).complete();
        BadgeManager.init();
        manager.register(class_3264.field_14190, BadgeManager.REGISTRY.getLoader()).before(powerData).complete();
    }

    static {
        LOGGER = LogManager.getLogger(Origins.class);
    }

    @Config(name="origins_server")
    public static class ServerConfig
    implements ConfigData {
        public boolean performVersionCheck = true;
        public JsonObject origins = new JsonObject();

        public boolean isOriginDisabled(class_2960 originId) {
            String idString = originId.toString();
            if (!this.origins.has(idString)) {
                return false;
            }
            JsonElement element = this.origins.get(idString);
            if (element instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)element;
                return !class_3518.method_15258((JsonObject)jsonObject, (String)"enabled", (boolean)true);
            }
            return false;
        }

        public boolean isPowerDisabled(class_2960 originId, class_2960 powerId) {
            String originIdString = originId.toString();
            if (!this.origins.has(originIdString)) {
                return false;
            }
            String powerIdString = powerId.toString();
            JsonElement element = this.origins.get(originIdString);
            if (element instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)element;
                return !class_3518.method_15258((JsonObject)jsonObject, (String)powerIdString, (boolean)true);
            }
            return false;
        }

        public boolean addToConfig(Origin origin) {
            JsonObject originObj;
            boolean changed = false;
            String originIdString = origin.getIdentifier().toString();
            if (!this.origins.has(originIdString) || !(this.origins.get(originIdString) instanceof JsonObject)) {
                originObj = new JsonObject();
                this.origins.add(originIdString, (JsonElement)originObj);
                changed = true;
            } else {
                originObj = (JsonObject)this.origins.get(originIdString);
            }
            if (!originObj.has("enabled") || !(originObj.get("enabled") instanceof JsonPrimitive)) {
                originObj.addProperty("enabled", Boolean.TRUE);
                changed = true;
            }
            for (PowerType<?> power : origin.getPowerTypes()) {
                String powerIdString = power.getIdentifier().toString();
                if (originObj.has(powerIdString) && originObj.get(powerIdString) instanceof JsonPrimitive) continue;
                originObj.addProperty(powerIdString, Boolean.TRUE);
                changed = true;
            }
            return changed;
        }
    }
}

