/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.gui;

import com.google.common.base.Predicates;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.DisplayRenderer;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.client.gui.widgets.WidgetHolder;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class SimpleDisplayRenderer
extends DisplayRenderer
implements WidgetHolder {
    protected static final class_2960 CHEST_GUI_TEXTURE = new class_2960("roughlyenoughitems", "textures/gui/recipecontainer.png");
    protected List<Slot> inputWidgets;
    protected List<Slot> outputWidgets;
    protected List<class_364> widgets;

    @ApiStatus.Internal
    protected SimpleDisplayRenderer(List<EntryIngredient> input, List<EntryIngredient> output) {
        this.inputWidgets = CollectionUtils.map(SimpleDisplayRenderer.simplify(input), this::createSlot);
        this.outputWidgets = CollectionUtils.map(SimpleDisplayRenderer.simplify(output), this::createSlot);
        this.widgets = Stream.concat(this.inputWidgets.stream(), this.outputWidgets.stream()).collect(Collectors.toList());
    }

    protected Slot createSlot(EntryIngredient ingredient) {
        return Widgets.createSlot(new Point(0, 0)).entries(CollectionUtils.filterToList(ingredient, stack -> !stack.isEmpty())).disableBackground().disableHighlight().disableTooltips();
    }

    private static List<EntryIngredient> simplify(List<EntryIngredient> original) {
        ArrayList<EntryIngredient> out = new ArrayList<EntryIngredient>();
        for (EntryIngredient ingredient : original) {
            EntryIngredient filter = ingredient.filter((Predicate<EntryStack<?>>)Predicates.not(EntryStack::isEmpty));
            if (filter.isEmpty() || !out.stream().noneMatch(s -> SimpleDisplayRenderer.equalsList(filter, s))) continue;
            out.add(filter);
        }
        return out;
    }

    public static DisplayRenderer from(List<EntryIngredient> input, List<EntryIngredient> output) {
        return new SimpleDisplayRenderer(input, output);
    }

    public static boolean equalsList(EntryIngredient left, EntryIngredient right) {
        LongOpenHashSet leftBytes = new LongOpenHashSet(left.size());
        for (EntryStack entryStack : left) {
            leftBytes.add(EntryStacks.hashExact(entryStack));
        }
        if (leftBytes.size() > right.size()) {
            return false;
        }
        LongOpenHashSet rightBytes = new LongOpenHashSet(right.size());
        for (EntryStack entryStack : right) {
            rightBytes.add(EntryStacks.hashExact(entryStack));
            if (rightBytes.size() <= leftBytes.size()) continue;
            return false;
        }
        return leftBytes.equals(rightBytes);
    }

    @Override
    public void render(class_4587 matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
        int xx = bounds.x + 4;
        int yy = bounds.y + 2;
        int j = 0;
        int itemsPerLine = this.getItemsPerLine();
        for (Slot entryWidget : this.inputWidgets) {
            entryWidget.setZ(this.getZ() + 50);
            entryWidget.getBounds().setLocation(xx, yy);
            entryWidget.method_25394(matrices, mouseX, mouseY, delta);
            xx += 18;
            if (++j < this.getItemsPerLine() - 2) continue;
            yy += 18;
            xx = bounds.x + 4;
            j = 0;
        }
        xx = bounds.x + 4 + 18 * (this.getItemsPerLine() - 2);
        yy = bounds.y + this.getHeight() / 2 - 8;
        RenderSystem.setShaderTexture((int)0, (class_2960)CHEST_GUI_TEXTURE);
        this.method_25302(matrices, xx, yy, 0, 28, 18, 18);
        xx += 18;
        yy += this.outputWidgets.size() * -9 + 9;
        for (Slot outputWidget : this.outputWidgets) {
            outputWidget.setZ(this.getZ() + 50);
            outputWidget.getBounds().setLocation(xx, yy);
            outputWidget.method_25394(matrices, mouseX, mouseY, delta);
            yy += 18;
        }
    }

    @Override
    @Nullable
    public Tooltip getTooltip(TooltipContext context) {
        for (Slot widget : this.inputWidgets) {
            if (!widget.containsMouse(context.getPoint())) continue;
            return widget.getCurrentTooltip(context);
        }
        for (Slot widget : this.outputWidgets) {
            if (!widget.containsMouse(context.getPoint())) continue;
            return widget.getCurrentTooltip(context);
        }
        return null;
    }

    @Override
    public int getHeight() {
        return Math.max(4 + this.getItemsHeight() * 18, 4 + this.outputWidgets.size() * 18);
    }

    public int getItemsHeight() {
        return Math.max(class_3532.method_15386((float)((float)this.inputWidgets.size() / (float)(this.getItemsPerLine() - 2))), this.outputWidgets.size());
    }

    public int getItemsPerLine() {
        return class_3532.method_15375((float)(((float)this.getWidth() - 4.0f) / 18.0f));
    }

    @Override
    public List<? extends class_364> children() {
        return this.widgets;
    }
}

