/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.gui.widgets;

import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.ClientInternals;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_5632;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public interface Tooltip {
    public static Entry entry(class_2561 text) {
        return ClientInternals.createTooltipEntry(text);
    }

    public static Entry entry(class_5632 text) {
        return ClientInternals.createTooltipEntry(text);
    }

    public static Tooltip create(@Nullable Point point, Collection<class_2561> texts) {
        return Tooltip.from(point, CollectionUtils.map(texts, Tooltip::entry));
    }

    public static Tooltip create(@Nullable Point point, class_2561 ... texts) {
        return Tooltip.create(point, Arrays.asList(texts));
    }

    public static Tooltip create(Collection<class_2561> texts) {
        return Tooltip.create(null, texts);
    }

    public static Tooltip create(class_2561 ... texts) {
        return Tooltip.create(Arrays.asList(texts));
    }

    public static Tooltip from(@Nullable Point point, Collection<Entry> entries) {
        return ClientInternals.createTooltip(point, entries);
    }

    public static Tooltip from(@Nullable Point point, Entry ... entries) {
        return Tooltip.from(point, Arrays.asList(entries));
    }

    public static Tooltip from(Collection<Entry> entries) {
        return Tooltip.from(null, entries);
    }

    public static Tooltip from(Entry ... entries) {
        return Tooltip.from(Arrays.asList(entries));
    }

    public int getX();

    public int getY();

    public List<Entry> entries();

    public Tooltip add(class_2561 var1);

    public Tooltip add(class_5632 var1);

    default public Tooltip addAll(class_5632 ... components) {
        for (class_5632 component : components) {
            this.add(component);
        }
        return this;
    }

    default public Tooltip addAll(class_2561 ... text) {
        for (class_2561 component : text) {
            this.add(component);
        }
        return this;
    }

    default public Tooltip addAllTooltipComponents(Iterable<class_5632> text) {
        for (class_5632 component : text) {
            this.add(component);
        }
        return this;
    }

    default public Tooltip addAllTexts(Iterable<class_2561> text) {
        for (class_2561 component : text) {
            this.add(component);
        }
        return this;
    }

    public EntryStack<?> getContextStack();

    public Tooltip withContextStack(EntryStack<?> var1);

    default public void queue() {
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> REIRuntime.getInstance().queueTooltip(this));
    }

    public Tooltip copy();

    @ApiStatus.NonExtendable
    public static interface Entry {
        public boolean isText();

        public boolean isTooltipComponent();

        public class_2561 getAsText();

        public class_5632 getAsTooltipComponent();
    }
}

