/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.mixin;

import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;
import virtuoel.pehkui.util.ScaleUtils;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin {
    @Unique
    private static final ThreadLocal<Float> pehkui$WIDTH_SCALE = ThreadLocal.withInitial(() -> Float.valueOf(1.0f));
    @Unique
    private static final ThreadLocal<Float> pehkui$HEIGHT_SCALE = ThreadLocal.withInitial(() -> Float.valueOf(1.0f));

    @Inject(at={@At(value="RETURN")}, method={"getDimensions"}, cancellable=true)
    private void onGetDimensions(class_4050 pose, CallbackInfoReturnable<class_4048> info) {
        info.setReturnValue((Object)((class_4048)info.getReturnValue()).method_19539(ScaleUtils.getBoundingBoxWidthScale((class_1297)this), ScaleUtils.getBoundingBoxHeightScale((class_1297)this)));
    }

    @ModifyArg(method={"tickMovement"}, index=1, at=@At(value="INVOKE", target="Ljava/lang/Math;min(FF)F"))
    private float onTickMovementMinVelocityProxy(float velocity) {
        return velocity * ScaleUtils.getMotionScale((class_1297)this);
    }

    @Inject(method={"travel(Lnet/minecraft/util/math/Vec3d;)V"}, at={@At(value="INVOKE", ordinal=0, shift=At.Shift.BEFORE, target="Lnet/minecraft/entity/LivingEntity;travel(Lnet/minecraft/util/math/Vec3d;)V")})
    private void onTravelModifyFlightSpeed(class_243 movementInput, CallbackInfo info) {
        float scale = ScaleUtils.getFlightScale((class_1297)this);
        if (scale != 1.0f) {
            ((class_1657)this).field_6281 *= scale;
        }
    }

    @Inject(method={"dropItem(Lnet/minecraft/item/ItemStack;ZZ)Lnet/minecraft/entity/ItemEntity;"}, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/entity/ItemEntity;setPickupDelay(I)V")})
    private void onDropItem(class_1799 stack, boolean spread, boolean thrown, CallbackInfoReturnable<class_1542> info, double y, class_1542 entity) {
        ScaleUtils.setScaleOfDrop((class_1297)entity, (class_1297)this);
        float scale = ScaleUtils.getEyeHeightScale((class_1297)this);
        if (scale != 1.0f) {
            class_243 pos = entity.method_19538();
            entity.method_5814(pos.field_1352, y + (double)(1.0f - scale) * 0.3, pos.field_1350);
        }
    }

    @ModifyArgs(method={"tickMovement()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/math/Box;expand(DDD)Lnet/minecraft/util/math/Box;"))
    private void onTickMovementModifyExpand(Args args) {
        float scale = ScaleUtils.getMotionScale((class_1297)this);
        if (scale != 1.0f) {
            int index = args.get(0) instanceof class_238 ? 1 : 0;
            args.set(index, (Object)((Double)args.get(index) * (double)scale));
            args.set(index + 1, (Object)((Double)args.get(index + 1) * (double)scale));
            args.set(index + 2, (Object)((Double)args.get(index + 2) * (double)scale));
        }
    }

    @ModifyConstant(method={"attack(Lnet/minecraft/entity/Entity;)V"}, constant={@Constant(floatValue=0.5f, ordinal=1), @Constant(floatValue=0.5f, ordinal=2), @Constant(floatValue=0.5f, ordinal=3)})
    private float onAttackModifyKnockback(float value) {
        float scale = ScaleUtils.getKnockbackScale((class_1297)this);
        return scale != 1.0f ? scale * value : value;
    }

    @ModifyConstant(method={"getAttackCooldownProgressPerTick"}, constant={@Constant(doubleValue=20.0)})
    private double getAttackCooldownProgressPerTickModifyMultiplier(double value) {
        float scale = ScaleUtils.getAttackSpeedScale((class_1297)this);
        return scale != 1.0f ? value / (double)scale : value;
    }

    @Inject(at={@At(value="RETURN")}, method={"getBlockBreakingSpeed"}, cancellable=true)
    private void onGetBlockBreakingSpeed(class_2680 block, CallbackInfoReturnable<Float> info) {
        float scale = ScaleUtils.getMiningSpeedScale((class_1297)this);
        if (scale != 1.0f) {
            info.setReturnValue((Object)Float.valueOf(info.getReturnValueF() * scale));
        }
    }

    @ModifyConstant(method={"updateCapeAngles"}, constant={@Constant(doubleValue=10.0), @Constant(doubleValue=-10.0)})
    private double onUpdateCapeAnglesModifyLimits(double value) {
        float scale = ScaleUtils.getMotionScale((class_1297)this);
        return scale != 1.0f ? (double)scale * value : value;
    }

    @Inject(method={"attack"}, at={@At(value="HEAD")})
    private void onAttack(class_1297 target, CallbackInfo info) {
        pehkui$WIDTH_SCALE.set(Float.valueOf(ScaleUtils.getBoundingBoxWidthScale(target)));
        pehkui$HEIGHT_SCALE.set(Float.valueOf(ScaleUtils.getBoundingBoxHeightScale(target)));
    }

    @ModifyArg(method={"attack(Lnet/minecraft/entity/Entity;)V"}, index=0, at=@At(value="INVOKE", target="Lnet/minecraft/util/math/Box;expand(DDD)Lnet/minecraft/util/math/Box;"))
    private double onAttackExpandXProxy(double value) {
        return value * (double)pehkui$WIDTH_SCALE.get().floatValue();
    }

    @ModifyArg(method={"attack(Lnet/minecraft/entity/Entity;)V"}, index=1, at=@At(value="INVOKE", target="Lnet/minecraft/util/math/Box;expand(DDD)Lnet/minecraft/util/math/Box;"))
    private double onAttackExpandYProxy(double value) {
        return value * (double)pehkui$HEIGHT_SCALE.get().floatValue();
    }

    @ModifyArg(method={"attack(Lnet/minecraft/entity/Entity;)V"}, index=2, at=@At(value="INVOKE", target="Lnet/minecraft/util/math/Box;expand(DDD)Lnet/minecraft/util/math/Box;"))
    private double onAttackExpandZProxy(double value) {
        return value * (double)pehkui$WIDTH_SCALE.get().floatValue();
    }
}

