/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.server.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.function.Consumer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.MixinEnvironment;
import virtuoel.pehkui.Pehkui;
import virtuoel.pehkui.api.PehkuiConfig;
import virtuoel.pehkui.util.ConfigSyncUtils;
import virtuoel.pehkui.util.I18nUtils;
import virtuoel.pehkui.util.MixinTargetClasses;
import virtuoel.pehkui.util.NbtCompoundExtensions;

public class DebugCommand {
    private static final Collection<UUID> MARKED_UUIDS = new HashSet<UUID>();
    private static final Collection<String> MARKED_USERNAMES = new HashSet<String>();
    private static final List<class_1299<? extends class_1297>> TYPES = Arrays.asList(class_1299.field_6051, class_1299.field_6046, class_1299.field_6110, class_1299.field_6099);

    public static void register(CommandDispatcher<class_2168> commandDispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)class_2170.method_9247((String)"scale").requires(commandSource -> commandSource.method_9259(2));
        boolean splitConfigs = true;
        builder.then(class_2170.method_9247((String)"debug").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"config").then(ConfigSyncUtils.registerConfigFileCommands())).then(ConfigSyncUtils.registerConfigSyncCommands())).then(ConfigSyncUtils.registerConfigGetterCommands(true))).then(ConfigSyncUtils.registerConfigSetterCommands(true))).then(ConfigSyncUtils.registerConfigResetCommands(true))));
        if (FabricLoader.getInstance().isDevelopmentEnvironment() || PehkuiConfig.COMMON.enableCommands.get().booleanValue()) {
            builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"debug").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"delete_scale_data").then(class_2170.method_9247((String)"uuid").then(class_2170.method_9244((String)"uuid", (ArgumentType)StringArgumentType.string()).executes(context -> {
                String uuidString = StringArgumentType.getString((CommandContext)context, (String)"uuid");
                try {
                    MARKED_UUIDS.add(UUID.fromString(uuidString));
                }
                catch (IllegalArgumentException e) {
                    ((class_2168)context.getSource()).method_9213(I18nUtils.translate("commands.pehkui.debug.delete.uuid.invalid", "Invalid UUID \"%s\".", uuidString));
                    return 0;
                }
                return 1;
            })))).then(class_2170.method_9247((String)"username").then(class_2170.method_9244((String)"username", (ArgumentType)StringArgumentType.string()).executes(context -> {
                MARKED_USERNAMES.add(StringArgumentType.getString((CommandContext)context, (String)"username").toLowerCase(Locale.ROOT));
                return 1;
            }))))).then(class_2170.method_9247((String)"garbage_collect").executes(context -> {
                ((class_2168)context.getSource()).method_9207().field_13987.method_14364((class_2596)new class_2658(Pehkui.DEBUG_PACKET, new class_2540(Unpooled.buffer()).method_10817((Enum)DebugPacketType.GARBAGE_COLLECT)));
                System.gc();
                return 1;
            })));
        }
        if (FabricLoader.getInstance().isDevelopmentEnvironment() || PehkuiConfig.COMMON.enableDebugCommands.get().booleanValue()) {
            builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"debug").then(class_2170.method_9247((String)"run_mixin_tests").executes(DebugCommand::runMixinTests))).then(class_2170.method_9247((String)"run_tests").executes(DebugCommand::runTests)));
        }
        commandDispatcher.register(builder);
    }

    public static boolean unmarkEntityForScaleReset(class_1297 entity, class_2487 nbt) {
        if (entity instanceof class_1657 && MARKED_USERNAMES.remove(((class_1657)entity).method_7334().getName().toLowerCase(Locale.ROOT))) {
            return true;
        }
        NbtCompoundExtensions compound = (NbtCompoundExtensions)nbt;
        return compound.pehkui_containsUuid("UUID") && MARKED_UUIDS.remove(compound.pehkui_getUuid("UUID"));
    }

    private static int runTests(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        class_2350 dir = player.method_5735();
        class_2350 opposite = dir.method_10153();
        class_2350 left = dir.method_10160();
        class_2350 right = dir.method_10170();
        int distance = 4;
        int spacing = 2;
        int width = (TYPES.size() - 1) * (spacing + 1) + 1;
        class_2338 start = player.method_24515().method_10079(dir, distance).method_10079(left, width / 2);
        class_2338.class_2339 mut = start.method_25503();
        class_1937 w = player.method_5770();
        for (class_1299<? extends class_1297> t : TYPES) {
            w.method_8501((class_2338)mut, class_2246.field_10093.method_9564());
            class_1297 e = t.method_5883(w);
            e.method_5641((double)mut.method_10263() + 0.5, (double)(mut.method_10264() + 1), (double)mut.method_10260() + 0.5, opposite.method_10144(), 0.0f);
            e.method_5808((double)mut.method_10263() + 0.5, (double)(mut.method_10264() + 1), (double)mut.method_10260() + 0.5, opposite.method_10144(), 0.0f);
            e.method_5847(opposite.method_10144());
            e.method_5780("pehkui");
            w.method_8649(e);
            mut.method_10104(right, spacing + 1);
        }
        int successes = -1;
        int total = -1;
        ((class_2168)context.getSource()).method_9226(I18nUtils.translate("commands.pehkui.debug.test.success", "Tests succeeded: %d/%d", successes, total), false);
        return 1;
    }

    private static int runMixinTests(CommandContext<class_2168> context) throws CommandSyntaxException {
        DebugCommand.runMixinClassloadTests(t -> ((class_2168)context.getSource()).method_9226(t, false), false, false, MixinTargetClasses.Common.CLASSES, MixinTargetClasses.Server.CLASSES);
        DebugCommand.runMixinClassloadTests(t -> ((class_2168)context.getSource()).method_9226(t, false), false, true, MixinTargetClasses.Common.INTERMEDIARY_CLASSES, MixinTargetClasses.Server.INTERMEDIARY_CLASSES);
        ((class_2168)context.getSource()).method_9207().field_13987.method_14364((class_2596)new class_2658(Pehkui.DEBUG_PACKET, new class_2540(Unpooled.buffer()).method_10817((Enum)DebugPacketType.MIXIN_AUDIT)));
        ((class_2168)context.getSource()).method_9226(I18nUtils.translate("commands.pehkui.debug.audit.start", "Starting Mixin environment audit..."), false);
        MixinEnvironment.getCurrentEnvironment().audit();
        ((class_2168)context.getSource()).method_9226(I18nUtils.translate("commands.pehkui.debug.audit.end", "Mixin environment audit complete!"), false);
        return 1;
    }

    public static void runMixinClassloadTests(Consumer<class_2561> response, boolean client, boolean resolveMappings, String[] ... classes) {
        ArrayList<String> succeeded = new ArrayList<String>();
        ArrayList<String> failed = new ArrayList<String>();
        for (String[] c : classes) {
            DebugCommand.classloadMixinTargets(c, resolveMappings, succeeded, failed);
        }
        int successes = succeeded.size();
        int fails = failed.size();
        int total = successes + fails;
        if (fails > 0) {
            response.accept(I18nUtils.translate("commands.pehkui.debug.test.mixin.failed", "Failed classes: %s", "\"" + String.join((CharSequence)"\", \"", failed) + "\""));
        }
        String lang = "commands.pehkui.debug.test.mixin.results." + (resolveMappings ? "intermediary" : "named") + (client ? ".client" : ".server");
        String defaultStr = "%d successes and %d fails out of %d mixined " + (resolveMappings ? "intermediary " : "") + (client ? "client" : "server") + " classes";
        response.accept(I18nUtils.translate(lang, defaultStr, successes, fails, total));
    }

    public static void classloadMixinTargets(String[] classes, boolean resolveMappings, Collection<String> succeeded, Collection<String> failed) {
        ClassLoader cl = DebugCommand.class.getClassLoader();
        for (String name : classes) {
            name = name.replace('/', '.');
            if (resolveMappings) {
                name = FabricLoader.getInstance().getMappingResolver().mapClassName("intermediary", name);
            }
            try {
                Class.forName(name, true, cl);
                succeeded.add(name);
            }
            catch (Exception e) {
                failed.add(name);
            }
        }
    }

    public static enum DebugPacketType {
        MIXIN_AUDIT,
        GARBAGE_COLLECT;

    }
}

