/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.handler;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import tschipp.carryon.common.config.Configs;
import tschipp.carryon.common.handler.CustomPickupOverrideHandler;
import tschipp.carryon.common.handler.ListHandler;
import tschipp.carryon.common.helper.CarryonGamestageHelper;
import tschipp.carryon.common.item.ItemCarryonBlock;
import tschipp.carryon.common.scripting.CarryOnOverride;
import tschipp.carryon.common.scripting.ScriptChecker;

public class PickupHandler {
    public static boolean canPlayerPickUpBlock(ServerPlayer player, @Nullable BlockEntity tile, Level level, BlockPos pos) {
        double maxDist;
        double distance;
        CarryOnOverride override;
        if (player.f_8941_.m_9290_() == GameType.SPECTATOR || player.f_8941_.m_9290_() == GameType.ADVENTURE) {
            return false;
        }
        BlockState state = level.m_8055_(pos);
        CompoundTag tag = new CompoundTag();
        if (tile != null) {
            tile.m_187481_();
        }
        if ((override = ScriptChecker.inspectBlock(level.m_8055_(pos), level, pos, tag)) != null) {
            return ScriptChecker.fulfillsConditions(override, (Player)player) && PickupHandler.handleProtections(player, level, pos, state);
        }
        if ((Boolean)Configs.Settings.useWhitelistBlocks.get() != false ? !ListHandler.isAllowed(level.m_8055_(pos).m_60734_()) : ListHandler.isForbidden(level.m_8055_(pos).m_60734_())) {
            return false;
        }
        if ((state.m_60800_((BlockGetter)level, pos) != -1.0f || player.m_7500_()) && (distance = Vec3.m_82528_((Vec3i)pos).m_82554_(player.m_20182_())) < (maxDist = ((Double)Configs.Settings.maxDistance.get()).doubleValue()) && !ItemCarryonBlock.isLocked(pos, level)) {
            if (CustomPickupOverrideHandler.hasSpecialPickupConditions(state)) {
                return CarryonGamestageHelper.hasGamestage(CustomPickupOverrideHandler.getPickupCondition(state), (Player)player) && PickupHandler.handleProtections(player, level, pos, state);
            }
            if (((Boolean)Configs.Settings.pickupAllBlocks.get()).booleanValue() || tile != null) {
                return PickupHandler.handleProtections(player, level, pos, state);
            }
        }
        return false;
    }

    public static boolean canPlayerPickUpEntity(ServerPlayer player, Entity toPickUp) {
        double distance;
        if (player.f_8941_.m_9290_() == GameType.SPECTATOR || player.f_8941_.m_9290_() == GameType.ADVENTURE) {
            return false;
        }
        Vec3 pos = toPickUp.m_20182_();
        if (toPickUp instanceof Player) {
            return false;
        }
        CarryOnOverride override = ScriptChecker.inspectEntity(toPickUp);
        if (override != null) {
            return ScriptChecker.fulfillsConditions(override, (Player)player) && PickupHandler.handleProtections(player, toPickUp);
        }
        if (toPickUp instanceof AgeableMob) {
            AgeableMob living = (AgeableMob)toPickUp;
            if (((Boolean)Configs.Settings.allowBabies.get()).booleanValue() && (living.m_146764_() < 0 || living.m_6162_())) {
                TamableAnimal tame;
                double distance2 = pos.m_82557_(player.m_20182_());
                if (distance2 <= Math.pow((Double)Configs.Settings.maxDistance.get(), 2.0) && toPickUp instanceof TamableAnimal && (tame = (TamableAnimal)toPickUp).m_21805_() != null && tame.m_21805_() != player.m_36316_().getId()) {
                    return false;
                }
                if (CustomPickupOverrideHandler.hasSpecialPickupConditions(toPickUp)) {
                    return CarryonGamestageHelper.hasGamestage(CustomPickupOverrideHandler.getPickupCondition(toPickUp), (Player)player) && PickupHandler.handleProtections(player, toPickUp);
                }
                return PickupHandler.handleProtections(player, toPickUp);
            }
        }
        if ((Boolean)Configs.Settings.useWhitelistEntities.get() != false ? !ListHandler.isAllowed(toPickUp) : ListHandler.isForbidden(toPickUp)) {
            return false;
        }
        if ((((Boolean)Configs.Settings.pickupHostileMobs.get()).booleanValue() || toPickUp.m_6095_().m_20674_() != MobCategory.MONSTER || player.m_7500_()) && (((Boolean)Configs.Settings.pickupHostileMobs.get()).booleanValue() || toPickUp.m_6095_().m_20674_() != MobCategory.MONSTER || player.m_7500_()) && ((double)toPickUp.m_20206_() <= (Double)Configs.Settings.maxEntityHeight.get() && (double)toPickUp.m_20205_() <= (Double)Configs.Settings.maxEntityWidth.get() || player.m_7500_()) && (distance = pos.m_82557_(player.m_20182_())) < Math.pow((Double)Configs.Settings.maxDistance.get(), 2.0)) {
            if (toPickUp instanceof TamableAnimal) {
                TamableAnimal tame = (TamableAnimal)toPickUp;
                UUID owner = tame.m_21805_();
                UUID playerID = player.m_36316_().getId();
                if (owner != null && !owner.equals(playerID)) {
                    return false;
                }
            }
            if (CustomPickupOverrideHandler.hasSpecialPickupConditions(toPickUp)) {
                return CarryonGamestageHelper.hasGamestage(CustomPickupOverrideHandler.getPickupCondition(toPickUp), (Player)player) && PickupHandler.handleProtections(player, toPickUp);
            }
            return PickupHandler.handleProtections(player, toPickUp);
        }
        return false;
    }

    private static boolean handleProtections(ServerPlayer player, Level level, BlockPos pos, BlockState state) {
        boolean breakable = true;
        PickUpBlockEvent event = new PickUpBlockEvent(level, pos, state, (Player)player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            breakable = false;
        }
        return breakable;
    }

    private static boolean handleProtections(ServerPlayer player, Entity entity) {
        boolean canPickup = true;
        PickUpEntityEvent event = new PickUpEntityEvent((Player)player, entity);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            canPickup = false;
        }
        return canPickup;
    }

    public static class PickUpBlockEvent
    extends BlockEvent.BreakEvent {
        public PickUpBlockEvent(Level level, BlockPos pos, BlockState state, Player player) {
            super(level, pos, state, player);
        }
    }

    public static class PickUpEntityEvent
    extends AttackEntityEvent {
        public PickUpEntityEvent(Player player, Entity target) {
            super(player, target);
        }
    }
}

