/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.scripting;

import java.lang.reflect.Method;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import tschipp.carryon.common.config.Configs;
import tschipp.carryon.common.handler.ListHandler;
import tschipp.carryon.common.helper.ScriptParseHelper;
import tschipp.carryon.common.scripting.CarryOnOverride;
import tschipp.carryon.common.scripting.ScriptReader;

public class ScriptChecker {
    @Nullable
    public static CarryOnOverride inspectBlock(BlockState state, Level level, BlockPos pos, @Nullable CompoundTag tag) {
        boolean isAllowed;
        if (!((Boolean)Configs.Settings.useScripts.get()).booleanValue()) {
            return null;
        }
        Block block = state.m_60734_();
        Material material = state.m_60767_();
        float hardness = state.m_60800_((BlockGetter)level, pos);
        float resistance = block.m_7325_();
        CompoundTag nbt = tag;
        boolean bl = (Boolean)Configs.Settings.useWhitelistBlocks.get() != false ? ListHandler.isAllowed(block) : (isAllowed = !ListHandler.isForbidden(block));
        if (isAllowed) {
            for (CarryOnOverride override : ScriptReader.OVERRIDES.values()) {
                if (!override.isBlock() || !ScriptChecker.matchesAll(override, block, material, hardness, resistance, nbt)) continue;
                return override;
            }
        }
        return null;
    }

    @Nullable
    public static CarryOnOverride inspectEntity(Entity entity) {
        boolean isAllowed;
        if (!((Boolean)Configs.Settings.useScripts.get()).booleanValue()) {
            return null;
        }
        String name = ForgeRegistries.ENTITIES.getKey((Object)entity.m_6095_()).toString();
        float height = entity.m_20206_();
        float width = entity.m_20205_();
        float health = entity instanceof LivingEntity ? ((LivingEntity)entity).m_21223_() : 0.0f;
        CompoundTag tag = entity.serializeNBT();
        boolean bl = (Boolean)Configs.Settings.useWhitelistEntities.get() != false ? ListHandler.isAllowed(entity) : (isAllowed = !ListHandler.isForbidden(entity));
        if (isAllowed) {
            for (CarryOnOverride override : ScriptReader.OVERRIDES.values()) {
                if (!override.isEntity() || !ScriptChecker.matchesAll(override, name, height, width, health, tag)) continue;
                return override;
            }
        }
        return null;
    }

    public static boolean matchesAll(CarryOnOverride override, String name, float height, float width, float health, CompoundTag tag) {
        boolean matchname = override.getTypeNameEntity().isEmpty() ? true : name.equals(override.getTypeNameEntity());
        boolean matchheight = ScriptParseHelper.matches(height, override.getTypeHeight());
        boolean matchwidth = ScriptParseHelper.matches(width, override.getTypeWidth());
        boolean matchhealth = ScriptParseHelper.matches(health, override.getTypeHealth());
        boolean matchnbt = ScriptParseHelper.matches(tag, override.getTypeEntityTag());
        return matchname && matchheight && matchwidth && matchhealth && matchnbt;
    }

    public static boolean matchesAll(CarryOnOverride override, Block block, Material material, float hardness, float resistance, CompoundTag nbt) {
        boolean matchnbt = ScriptParseHelper.matches(nbt, override.getTypeBlockTag());
        boolean matchblock = ScriptParseHelper.matches(block, override.getTypeNameBlock());
        boolean matchmaterial = ScriptParseHelper.matches(material, override.getTypeMaterial());
        boolean matchhardness = ScriptParseHelper.matches(hardness, override.getTypeHardness());
        boolean matchresistance = ScriptParseHelper.matches(resistance, override.getTypeResistance());
        return matchnbt && matchblock && matchmaterial && matchhardness && matchresistance;
    }

    public static boolean fulfillsConditions(CarryOnOverride override, Player player) {
        ServerAdvancementManager manager = ((ServerPlayer)player).f_8924_.m_129889_();
        Advancement adv = manager.m_136041_(new ResourceLocation(override.getConditionAchievement().isEmpty() ? "" : override.getConditionAchievement()));
        boolean achievement = adv == null ? true : ((ServerPlayer)player).m_8960_().m_135996_(adv).m_8193_();
        boolean gamemode = ScriptParseHelper.matches(((ServerPlayer)player).f_8941_.m_9290_().m_46392_(), override.getConditionGamemode());
        boolean gamestage = true;
        if (ModList.get().isLoaded("gamestages") && !override.getConditionGamestage().isEmpty()) {
            try {
                Class<?> gameStageHelper = Class.forName("net.darkhax.gamestages.GameStageHelper");
                Class<?> iStageData = Class.forName("net.darkhax.gamestages.data.IStageData");
                Method getPlayerData = ObfuscationReflectionHelper.findMethod(gameStageHelper, (String)"getPlayerData", (Class[])new Class[]{Player.class});
                Method hasStage = ObfuscationReflectionHelper.findMethod(iStageData, (String)"hasStage", (Class[])new Class[]{String.class});
                Object stageData = getPlayerData.invoke(null, player);
                String condition = override.getConditionGamestage();
                gamestage = (Boolean)hasStage.invoke(stageData, condition);
            }
            catch (Exception e) {
                try {
                    Class<?> playerDataHandler = Class.forName("net.darkhax.gamestages.capabilities.PlayerDataHandler");
                    Class<?> iStageData = Class.forName("net.darkhax.gamestages.capabilities.PlayerDataHandler$IStageData");
                    Method getStageData = ObfuscationReflectionHelper.findMethod(playerDataHandler, (String)"getStageData", (Class[])new Class[]{Player.class});
                    Method hasUnlockedStage = ObfuscationReflectionHelper.findMethod(iStageData, (String)"hasUnlockedStage", (Class[])new Class[]{String.class});
                    Object stageData = getStageData.invoke(null, player);
                    String condition = override.getConditionGamestage();
                    gamestage = (Boolean)hasUnlockedStage.invoke(stageData, condition);
                }
                catch (Exception playerDataHandler) {
                    // empty catch block
                }
            }
        }
        boolean position = ScriptParseHelper.matches(player.m_20183_(), override.getConditionPosition());
        boolean xp = ScriptParseHelper.matches(player.f_36078_, override.getConditionXp());
        boolean scoreboard = ScriptParseHelper.matchesScore(player, override.getConditionScoreboard());
        boolean effects = ScriptParseHelper.hasEffects(player, override.getConditionEffects());
        return achievement && gamemode && gamestage && position && xp && scoreboard && effects;
    }

    @Nullable
    public static CarryOnOverride getOverride(Player player) {
        CompoundTag tag = player.getPersistentData();
        if (tag != null && tag.m_128441_("overrideKey")) {
            int key = tag.m_128451_("overrideKey");
            return ScriptReader.OVERRIDES.get(key);
        }
        return null;
    }

    public static void setCarryOnOverride(Player player, int i) {
        CompoundTag tag = player.getPersistentData();
        if (tag != null) {
            tag.m_128405_("overrideKey", i);
        }
    }
}

