/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.client;

import com.mrcrayfish.furniture.client.ImageCache;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.IOUtils;

public class ImageDownloadThread
extends Thread {
    private static final String[] SUPPORTED_FORMATS = new String[]{"image/png", "image/jpeg", "image/gif", "image/bmp"};
    private static final Set<String> LOADING_URLS = new HashSet<String>();
    private static final long MAX_FILE_SIZE = 0x200000L;
    private String url;
    private ResponseProcessor processor;
    private int tryCount;

    public ImageDownloadThread(String url, ResponseProcessor processor) {
        super("Image Download Thread");
        this.url = url;
        this.processor = processor;
    }

    @Override
    public void run() {
        if (ImageCache.INSTANCE.loadCached(this.url)) {
            this.processor.process(ImageDownloadResult.SUCCESS, "Successfully processed image");
            return;
        }
        if (ImageDownloadThread.isLoading(this.url)) {
            do {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (!ImageCache.INSTANCE.isCached(this.url)) continue;
                this.processor.process(ImageDownloadResult.SUCCESS, "Successfully processed image");
                return;
            } while (this.tryCount++ != 10);
            this.processor.process(ImageDownloadResult.FAILED, "Unable to process image");
            return;
        }
        try {
            URLConnection connection = new URL(this.url).openConnection();
            connection.addRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)");
            boolean failed = true;
            for (String format : SUPPORTED_FORMATS) {
                if (!format.equals(connection.getContentType())) continue;
                failed = false;
                break;
            }
            if (failed) {
                this.processor.process(ImageDownloadResult.UNKNOWN_FILE, "The file is not a image");
                return;
            }
            long length = Long.parseLong(connection.getHeaderField("Content-Length"));
            if (length > 0x200000L) {
                this.processor.process(ImageDownloadResult.TOO_LARGE, "The image is greater than 2048.0MB");
                return;
            }
            ImageDownloadThread.setLoading(this.url, true);
            byte[] data = IOUtils.toByteArray((URLConnection)connection);
            if (ImageCache.INSTANCE.add(this.url, data)) {
                ImageDownloadThread.setLoading(this.url, false);
                this.processor.process(ImageDownloadResult.SUCCESS, "Successfully processed image");
                return;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.processor.process(ImageDownloadResult.FAILED, "Unable to process image");
        ImageDownloadThread.setLoading(this.url, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLoading(String url, boolean loading) {
        Set<String> set = LOADING_URLS;
        synchronized (set) {
            if (loading) {
                LOADING_URLS.add(url);
            } else {
                LOADING_URLS.remove(url);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLoading(String url) {
        Set<String> set = LOADING_URLS;
        synchronized (set) {
            return LOADING_URLS.contains(url);
        }
    }

    public static enum ImageDownloadResult {
        SUCCESS("cfm.photo_frame.success"),
        FAILED("cfm.photo_frame.failed"),
        UNKNOWN_FILE("cfm.photo_frame.unknown_file"),
        TOO_LARGE("cfm.photo_frame.too_large");

        private String key;

        private ImageDownloadResult(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }

    public static interface ResponseProcessor {
        public void process(ImageDownloadResult var1, String var2);
    }
}

