/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.treecapitator.registry;

import bspkrs.treecapitator.config.TCConfigHandler;
import bspkrs.treecapitator.config.TCSettings;
import bspkrs.treecapitator.registry.ThirdPartyModConfig;
import bspkrs.treecapitator.registry.ToolRegistry;
import bspkrs.treecapitator.registry.TreeDefinition;
import bspkrs.treecapitator.registry.TreeRegistry;
import bspkrs.treecapitator.util.TCLog;
import bspkrs.util.BlockID;
import bspkrs.util.ItemID;
import bspkrs.util.ModulusBlockID;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;

public class ModConfigRegistry {
    private static ModConfigRegistry instance;
    private Map<String, ThirdPartyModConfig> userModCfgs;
    private Map<String, ThirdPartyModConfig> imcModCfgs;
    private Map<String, ThirdPartyModConfig> defaultModCfgs;
    private boolean isChanged = false;

    public static ModConfigRegistry instance() {
        if (instance == null) {
            new ModConfigRegistry();
        }
        return instance;
    }

    protected ModConfigRegistry() {
        instance = this;
        this.userModCfgs = new HashMap<String, ThirdPartyModConfig>();
        this.imcModCfgs = new HashMap<String, ThirdPartyModConfig>();
        this.initDefaultModConfigs();
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public void registerUserModConfig(ThirdPartyModConfig tpmc) {
        TCLog.debug("Registering user mod config %s", tpmc.modID());
        if (!this.userModCfgs.containsKey(tpmc.modID())) {
            this.userModCfgs.put(tpmc.modID(), tpmc);
        } else {
            TCLog.info("User config contains multiple 3rd party mod configs for mod %s. These entries will be merged.", tpmc.modID());
            this.userModCfgs.get(tpmc.modID()).merge(tpmc);
        }
        this.isChanged = true;
    }

    public void registerIMCModConfig(String sendingMod, ThirdPartyModConfig tpmc) {
        TCLog.debug("Registering IMC mod config %s sent by %s", tpmc.modID(), sendingMod);
        if (!this.imcModCfgs.containsKey(tpmc.modID())) {
            this.imcModCfgs.put(tpmc.modID(), tpmc.setOverrideIMC(false));
        } else {
            TCLog.info("Multiple IMC messages sent for mod %s. The new message will be merged with previous messages.", tpmc.modID());
            this.imcModCfgs.get(tpmc.modID()).merge(tpmc);
        }
        this.isChanged = true;
    }

    public void appendTreeToModConfig(String modID, String treeName, TreeDefinition treeDef) {
        if (this.userModCfgs.containsKey(modID)) {
            this.userModCfgs.get(modID).addTreeDef(treeName, treeDef);
        } else {
            ThirdPartyModConfig tpmc = new ThirdPartyModConfig(modID);
            tpmc.addTreeDef(treeName, treeDef);
            this.userModCfgs.put(modID, tpmc);
        }
        this.isChanged = true;
    }

    public void appendAxeToModConfig(String modID, ItemID axe) {
        if (this.userModCfgs.containsKey(modID)) {
            this.userModCfgs.get(modID).addAxe(axe);
        } else {
            ThirdPartyModConfig tpmc = new ThirdPartyModConfig(modID);
            tpmc.addAxe(axe);
            this.userModCfgs.put(modID, tpmc);
        }
        this.isChanged = true;
    }

    public void applyPrioritizedModConfigs() {
        LinkedList<ThirdPartyModConfig> finalList = new LinkedList<ThirdPartyModConfig>();
        TCLog.info("Prioritizing User and IMC mod configs...", new Object[0]);
        for (Map.Entry<String, ThirdPartyModConfig> e : this.imcModCfgs.entrySet()) {
            if (this.userModCfgs.containsKey(e.getKey()) && this.userModCfgs.get(e.getKey()).overrideIMC()) continue;
            finalList.add(e.getValue());
            TCLog.debug("IMC mod config loaded for %s.", e.getValue().modID());
            if (!TCSettings.saveIMCConfigsToFile) continue;
            this.writeToConfigFile(e.getValue());
        }
        for (Map.Entry<String, ThirdPartyModConfig> e : this.userModCfgs.entrySet()) {
            if (this.imcModCfgs.containsKey(e.getKey()) && !e.getValue().overrideIMC()) continue;
            finalList.add(e.getValue());
            TCLog.debug("User mod config loaded for %s.", e.getValue().modID());
        }
        TCLog.info("Registering items and trees...", new Object[0]);
        TreeRegistry.instance().initMapsAndLists();
        ToolRegistry.instance().initLists();
        for (ThirdPartyModConfig cfg : finalList) {
            cfg.registerTools().registerTrees();
        }
        this.isChanged = false;
        TCConfigHandler.instance().getConfig().save();
        TCConfigHandler.instance().setShouldRefreshRegistries(true);
    }

    public Map<String, ThirdPartyModConfig> defaultConfigs() {
        return new TreeMap<String, ThirdPartyModConfig>(this.defaultModCfgs);
    }

    public void writeChangesToConfig(Configuration config) {
        if (this.isChanged) {
            for (Map.Entry<String, ThirdPartyModConfig> entry : this.userModCfgs.entrySet()) {
                if (!entry.getValue().isChanged()) continue;
                this.writeToConfigFile(entry.getValue());
            }
        }
        this.isChanged = false;
        config.save();
    }

    public void syncConfig(Configuration config) {
        this.userModCfgs = new HashMap<String, ThirdPartyModConfig>();
        TCSettings.userConfigOverridesIMC = config.getBoolean("userConfigOverridesIMC", "tree_and_mod_configs", false, "This setting controls the default behavior when a mod is both configured manually (in the config file) and \nby the mod itself via IMC (inter-mod communication).", "bspkrs.tc.configgui.userConfigOverridesIMC");
        TCSettings.saveIMCConfigsToFile = config.getBoolean("saveIMCConfigsToFile", "tree_and_mod_configs", true, "This setting controls whether or not IMC config messages sent by other mods will be saved to the local\nconfig file when they are processed by Treecapitator. The message will only be saved if your local config\nfor a given mod is not set to override the IMC message.", "bspkrs.tc.configgui.saveIMCConfigsToFile");
        TCLog.configs(config, "tree_and_mod_configs");
        config.setCategoryComment("tree_and_mod_configs", "This category is where all your settings live that are related to trees, items that can chop trees, and mods.\nHow to add new mods: \n\nKeep in mind that you can also include settings marked with [PerTree] on a per-tree basis to override the global default values.\n\nFormat:\n    <section_name> { (typically same as modID)\n        S:modID=<modID> (this can be found on the Mods screen in game or in mcmod.info)\n        S:axeIDList=<unique_item_identifier>,<optional metadata>; minecraft:wooden_axe; minecraft:stone_axe\n        S:shearsIDList=<unique_item_identifier>,<optional metadata>\n        B:overrideIMC=<optional, defaults to false) whether or not a mod's user config (this file) should             override a mod's IMC config (IMC allows mods to send messages to each other for compatibility)\n\n        <tree_name> { (the tree name is just for organization and clarity)\n            # logs/leaves: list of unique block name values. \",\" separates name and metadata, \";\" separates block entries\n            S:logs=<unique block identifier>,<optional metadata>; <unique_block_identifier>,0; minecraft:log,0\n            S:leaves=<unique block identifier>,<optional metadata>; <unique_block_identifier>,0; minecraft:leaves,0\n            [optionally add per-tree settings here]\n\n        }\n    }");
        config.setCategoryLanguageKey("tree_and_mod_configs", "bspkrs.tc.configgui.ctgy.tree_and_mod_configs");
        if (!config.hasCategory("tree_and_mod_configs.1_vanilla_trees_and_items")) {
            for (Map.Entry<String, ThirdPartyModConfig> e : this.defaultConfigs().entrySet()) {
                e.getValue().writeToConfiguration(config, "tree_and_mod_configs." + e.getKey());
            }
            TCLog.info("Looks like a fresh config; default config loaded.", new Object[0]);
        } else {
            TCLog.info("Proceeding to load tree/mod configs from file.", new Object[0]);
        }
        config.setCategoryComment("tree_and_mod_configs.1_vanilla_trees_and_items", "This special category is the home of the vanilla tree block and item configurations. You can change the \nvalues in this category to suit your preferences.\n\nWARNING: This config category must not be removed! If this category is renamed or removed Treecapitator \nwill assume your config file is new and reload the default user mod config settings!");
        config.setCategoryLanguageKey("tree_and_mod_configs.1_vanilla_trees_and_items", "bspkrs.tc.configgui.ctgy.tree_and_mod_configs.1_vanilla_trees_and_items");
        for (String ctgy : config.getCategoryNames()) {
            ConfigCategory cc = config.getCategory(ctgy);
            if (ctgy.indexOf("tree_and_mod_configs.") == -1 || !cc.containsKey("modID") || !cc.get("modID").getString().equals("minecraft") && !Loader.isModLoaded((String)cc.get("modID").getString())) continue;
            TCLog.debug("Loading file config for mod %s (config category %s)...", cc.get("modID").getString(), ctgy);
            this.registerUserModConfig(ThirdPartyModConfig.readFromConfiguration(config, ctgy));
        }
    }

    public void writeToConfigFile(ThirdPartyModConfig tpmc) {
        Configuration config = TCConfigHandler.instance().getConfig();
        if (config == null) {
            throw new RuntimeException("Cannot write to a null config object!");
        }
        String modCtgy = "";
        for (String ctgy : config.getCategoryNames()) {
            ConfigCategory cc = config.getCategory(ctgy);
            if (ctgy.indexOf("tree_and_mod_configs.") == -1 || !cc.containsKey("modID") || !tpmc.modID().equals(cc.get("modID").getString())) continue;
            modCtgy = ctgy;
            break;
        }
        if (modCtgy.isEmpty()) {
            modCtgy = "tree_and_mod_configs." + tpmc.modID();
        } else if (config.hasCategory(modCtgy)) {
            config.removeCategory(config.getCategory(modCtgy));
        }
        tpmc.writeToConfiguration(config, modCtgy);
        config.setCategoryComment("tree_and_mod_configs.1_vanilla_trees_and_items", "This special category is the home of the vanilla tree block and item configurations. You can change the \nvalues in this category to suit your preferences.\n\nWARNING: This config category must not be removed! If this category is renamed or removed Treecapitator \nwill assume your config file is new and reload the default user mod config settings!");
        config.setCategoryLanguageKey("tree_and_mod_configs.1_vanilla_trees_and_items", "bspkrs.tc.configgui.ctgy.tree_and_mod_configs.1_vanilla_trees_and_items");
    }

    protected void initDefaultModConfigs() {
        this.defaultModCfgs = new TreeMap<String, ThirdPartyModConfig>();
        this.defaultModCfgs.put("1_vanilla_trees_and_items", new ThirdPartyModConfig());
        this.defaultModCfgs.put("BiomesOPlenty", new ThirdPartyModConfig("BiomesOPlenty").addAxe(new ItemID("BiomesOPlenty:axeMud")).addAxe(new ItemID("BiomesOPlenty:axeAmethyst")).addTreeDef("bop_cherry", new TreeDefinition().addLogID(new ModulusBlockID("BiomesOPlenty:logs1", 1, 4)).addLeafID(new ModulusBlockID("BiomesOPlenty:leaves3", 3, 8))).addTreeDef("bop_darkwood", new TreeDefinition().addLogID(new ModulusBlockID("BiomesOPlenty:logs1", 2, 4)).addLeafID(new ModulusBlockID("BiomesOPlenty:leaves1", 3, 8))).addTreeDef("bop_magic", new TreeDefinition().addLogID(new ModulusBlockID("BiomesOPlenty:logs2", 1, 4)).addLeafID(new ModulusBlockID("BiomesOPlenty:leaves1", 2, 8))));
        this.defaultModCfgs.put("IC2", new ThirdPartyModConfig("IC2").addAxe(new ItemID("IC2:itemToolBronzeAxe")).addAxe(new ItemID("IC2:itemToolChainsaw")).addShears(new ItemID("IC2:itemToolChainsaw")).setOverrideIMC(false).addTreeDef("ic2_rubber_tree", new TreeDefinition().addLogID(new BlockID("IC2:blockRubWood")).addLeafID(new BlockID("IC2:blockRubLeaves"))));
        this.defaultModCfgs.put("Natura", new ThirdPartyModConfig("Natura").addAxe(new ItemID("Natura:natura.axe.bloodwood")).addAxe(new ItemID("Natura:natura.axe.darkwood")).addAxe(new ItemID("Natura:natura.axe.fusewood")).addAxe(new ItemID("Natura:natura.axe.ghostwood")).addAxe(new ItemID("Natura:natura.axe.netherquartz")).setOverrideIMC(false).addTreeDef("eucalyptus", new TreeDefinition().addLogID(new ModulusBlockID("Natura:tree", 0, 4)).addLeafID(new ModulusBlockID("Natura:floraleaves", 1, 8))).addTreeDef("sakura", new TreeDefinition().addLogID(new ModulusBlockID("Natura:tree", 1, 4)).addLeafID(new ModulusBlockID("Natura:floraleavesnocolor", 0, 8))).addTreeDef("ghostwood", new TreeDefinition().addLogID(new ModulusBlockID("Natura:tree", 2, 4)).addLeafID(new ModulusBlockID("Natura:floraleavesnocolor", 1, 8))).addTreeDef("hopseed", new TreeDefinition().addLogID(new ModulusBlockID("Natura:tree", 3, 4)).addLeafID(new ModulusBlockID("Natura:floraleaves", 2, 8))));
        this.defaultModCfgs.put("Thaumcraft", new ThirdPartyModConfig("Thaumcraft").addAxe(new ItemID("Thaumcraft:ItemAxeThaumium")).addAxe(new ItemID("Thaumcraft:ItemAxeElemental")).setOverrideIMC(false).addTreeDef("greatwood", new TreeDefinition().addLogID(new ModulusBlockID("Thaumcraft:blockMagicalLog", 0, 4)).addLeafID(new ModulusBlockID("Thaumcraft:blockMagicalLeaves", 0, 8)).setMaxHorLeafBreakDist(7).setRequireLeafDecayCheck(false)).addTreeDef("silverwood", new TreeDefinition().addLogID(new ModulusBlockID("Thaumcraft:blockMagicalLog", 1, 4)).addLeafID(new ModulusBlockID("Thaumcraft:blockMagicalLeaves", 1, 8))));
        this.defaultModCfgs.put("TConstruct", new ThirdPartyModConfig("TConstruct").addAxe(new ItemID("TConstruct:hatchet")).addAxe(new ItemID("TConstruct:mattock")).addAxe(new ItemID("TConstruct:lumberaxe")).setOverrideIMC(false));
        this.defaultModCfgs.put("TwilightForest", new ThirdPartyModConfig("TwilightForest").addAxe(new ItemID("TwilightForest:item.ironwoodAxe")).addAxe(new ItemID("TwilightForest:item.knightlyAxe")).addAxe(new ItemID("TwilightForest:item.minotaurAxe")).addAxe(new ItemID("TwilightForest:item.steeleafAxe")).setOverrideIMC(false).addTreeDef("TF_oak", new TreeDefinition().addLogID(new ModulusBlockID("TwilightForest:tile.TFLog", 0, 4)).addLeafID(new ModulusBlockID("TwilightForest:tile.TFLeaves", 0, 8))).addTreeDef("TF_canopy", new TreeDefinition().addLogID(new ModulusBlockID("TwilightForest:tile.TFLog", 1, 4)).addLeafID(new ModulusBlockID("TwilightForest:tile.TFLeaves", 1, 8))).addTreeDef("TF_mangrove", new TreeDefinition().addLogID(new ModulusBlockID("TwilightForest:tile.TFLog", 2, 4)).addLeafID(new ModulusBlockID("TwilightForest:tile.TFLeaves", 2, 8))).addTreeDef("TF_darkwood", new TreeDefinition().addLogID(new ModulusBlockID("TwilightForest:tile.TFLog", 3, 4)).addLeafID(new BlockID("TwilightForest:tile.TFHedge", 1)).setMaxLeafIDDist(2).setRequireLeafDecayCheck(false).setMaxHorLeafBreakDist(5)).addTreeDef("TF_time", new TreeDefinition().addLogID(new ModulusBlockID("TwilightForest:tile.TFMagicLog", 0, 4)).addLogID(new ModulusBlockID("TwilightForest:tile.TFMagicLogSpecial", 0, 4)).addLeafID(new ModulusBlockID("TwilightForest:tile.TFMagicLeaves", 0, 8))).addTreeDef("TF_transformation", new TreeDefinition().addLogID(new ModulusBlockID("TwilightForest:tile.TFMagicLog", 1, 4)).addLogID(new ModulusBlockID("TwilightForest:tile.TFMagicLogSpecial", 1, 4)).addLeafID(new ModulusBlockID("TwilightForest:tile.TFMagicLeaves", 1, 8))).addTreeDef("TF_miner", new TreeDefinition().addLogID(new ModulusBlockID("TwilightForest:tile.TFMagicLog", 2, 4)).addLogID(new ModulusBlockID("TwilightForest:tile.TFMagicLogSpecial", 2, 4)).addLeafID(new ModulusBlockID("TwilightForest:tile.TFMagicLeaves", 2, 8))).addTreeDef("TF_sorting", new TreeDefinition().addLogID(new ModulusBlockID("TwilightForest:tile.TFMagicLog", 3, 4)).addLogID(new ModulusBlockID("TwilightForest:tile.TFMagicLogSpecial", 3, 4)).addLeafID(new ModulusBlockID("TwilightForest:tile.TFMagicLeaves", 3, 8))));
    }
}

