/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.blocks;

import java.util.Random;
import javax.annotation.Nonnull;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.state.PEStateProps;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.gameObjs.blocks.BlockDirection;
import moze_intel.projecte.gameObjs.tiles.DMFurnaceTile;
import moze_intel.projecte.gameObjs.tiles.RMFurnaceTile;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class MatterFurnace
extends BlockDirection {
    private final boolean isActive;
    private final boolean isHighTier;
    private static boolean isUpdating;

    public MatterFurnace(boolean active, boolean isRM) {
        super(Material.field_151576_e);
        this.func_149647_a(ObjHandler.cTab);
        this.isActive = active;
        this.isHighTier = isRM;
        this.func_149663_c("pe_" + (this.isHighTier ? "rm" : "dm") + "_furnace");
        this.func_149711_c(1000000.0f);
        if (this.isActive) {
            this.func_149647_a(null);
            this.func_149715_a(0.875f);
        }
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        return this.isHighTier ? 2000000.0f : 1000000.0f;
    }

    @Nonnull
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.isHighTier ? Item.func_150898_a((Block)ObjHandler.rmFurnaceOff) : Item.func_150898_a((Block)ObjHandler.dmFurnaceOff);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            if (this.isHighTier) {
                player.openGui((Object)PECore.instance, 4, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            } else {
                player.openGui((Object)PECore.instance, 5, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        }
        return true;
    }

    @Override
    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        if (!isUpdating) {
            super.func_180663_b(world, pos, state);
        }
    }

    public void updateFurnaceBlockState(boolean isActive, World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        TileEntity tile = world.func_175625_s(pos);
        isUpdating = true;
        if (isActive) {
            if (this.isHighTier) {
                world.func_180501_a(pos, ObjHandler.rmFurnaceOn.func_176223_P().func_177226_a(PEStateProps.FACING, state.func_177229_b(PEStateProps.FACING)), 3);
            } else {
                world.func_180501_a(pos, ObjHandler.dmFurnaceOn.func_176223_P().func_177226_a(PEStateProps.FACING, state.func_177229_b(PEStateProps.FACING)), 3);
            }
        } else if (this.isHighTier) {
            world.func_180501_a(pos, ObjHandler.rmFurnaceOff.func_176223_P().func_177226_a(PEStateProps.FACING, state.func_177229_b(PEStateProps.FACING)), 3);
        } else {
            world.func_180501_a(pos, ObjHandler.dmFurnaceOff.func_176223_P().func_177226_a(PEStateProps.FACING, state.func_177229_b(PEStateProps.FACING)), 3);
        }
        isUpdating = false;
        if (tile != null) {
            tile.func_145829_t();
            world.func_175690_a(pos, tile);
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entLiving, ItemStack stack) {
        world.func_175656_a(pos, state.func_177226_a(PEStateProps.FACING, (Comparable)entLiving.func_174811_aO().func_176734_d()));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (this.isActive) {
            EnumFacing facing = (EnumFacing)state.func_177229_b(PEStateProps.FACING);
            float f = (float)pos.func_177958_n() + 0.5f;
            float f1 = (float)pos.func_177956_o() + 0.0f + rand.nextFloat() * 6.0f / 16.0f;
            float f2 = (float)pos.func_177952_p() + 0.5f;
            float f3 = 0.52f;
            float f4 = rand.nextFloat() * 0.6f - 0.3f;
            switch (facing) {
                case WEST: {
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.FLAME, (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case EAST: {
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.FLAME, (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case NORTH: {
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.FLAME, (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case SOUTH: {
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.FLAME, (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        return this.isHighTier ? new ItemStack(Item.func_150898_a((Block)ObjHandler.rmFurnaceOff)) : new ItemStack(Item.func_150898_a((Block)ObjHandler.dmFurnaceOff));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return this.isHighTier ? new RMFurnaceTile() : new DMFurnaceTile();
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null) {
            IItemHandler inv = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            return ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)inv);
        }
        return 0;
    }
}

