/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.impl.KnowledgeImpl;
import moze_intel.projecte.utils.ItemHelper;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TransmutationOffline {
    private static final IKnowledgeProvider NOT_FOUND_PROVIDER = TransmutationOffline.immutableCopy((IKnowledgeProvider)ProjectEAPI.KNOWLEDGE_CAPABILITY.getDefaultInstance());
    private static final Map<UUID, IKnowledgeProvider> cachedKnowledgeProviders = new HashMap<UUID, IKnowledgeProvider>();

    public static void cleanAll() {
        cachedKnowledgeProviders.clear();
    }

    public static void clear(UUID playerUUID) {
        cachedKnowledgeProviders.remove(playerUUID);
    }

    static IKnowledgeProvider forPlayer(UUID playerUUID) {
        if (!cachedKnowledgeProviders.containsKey(playerUUID) && !TransmutationOffline.cacheOfflineData(playerUUID)) {
            cachedKnowledgeProviders.put(playerUUID, NOT_FOUND_PROVIDER);
        }
        return cachedKnowledgeProviders.get(playerUUID);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean cacheOfflineData(UUID playerUUID) {
        Preconditions.checkState((boolean)FMLCommonHandler.instance().getEffectiveSide().isServer(), (Object)"CRITICAL: Trying to read filesystem on client!!");
        File playerData = new File(DimensionManager.getCurrentSaveRootDirectory(), "playerdata");
        if (!playerData.exists()) return false;
        File player = new File(playerData, playerUUID.toString() + ".dat");
        if (!player.exists()) return false;
        if (!player.isFile()) return false;
        try (FileInputStream in = new FileInputStream(player);){
            NBTTagCompound playerDat = CompressedStreamTools.func_74796_a((InputStream)in);
            NBTTagCompound knowledgeProvider = playerDat.func_74775_l("ForgeCaps").func_74775_l(KnowledgeImpl.Provider.NAME.toString());
            IKnowledgeProvider provider = (IKnowledgeProvider)ProjectEAPI.KNOWLEDGE_CAPABILITY.getDefaultInstance();
            ProjectEAPI.KNOWLEDGE_CAPABILITY.readNBT((Object)provider, null, (NBTBase)knowledgeProvider);
            cachedKnowledgeProviders.put(playerUUID, TransmutationOffline.immutableCopy(provider));
            PECore.debugLog("Caching offline data for UUID: {}", playerUUID);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            PECore.LOGGER.warn("Failed to cache offline data for API calls for UUID: {}", (Object)playerUUID);
        }
        return false;
    }

    private static IKnowledgeProvider immutableCopy(final IKnowledgeProvider toCopy) {
        return new IKnowledgeProvider(){
            final List<ItemStack> immutableKnowledge;
            final IItemHandlerModifiable immutableInputLocks;
            {
                this.immutableKnowledge = ImmutableList.copyOf(toCopy.getKnowledge());
                this.immutableInputLocks = ItemHelper.immutableCopy(toCopy.getInputAndLocks());
            }

            @Override
            public boolean hasFullKnowledge() {
                return toCopy.hasFullKnowledge();
            }

            @Override
            public void setFullKnowledge(boolean fullKnowledge) {
            }

            @Override
            public void clearKnowledge() {
            }

            @Override
            public boolean hasKnowledge(@Nonnull ItemStack stack) {
                return toCopy.hasKnowledge(stack);
            }

            @Override
            public boolean addKnowledge(@Nonnull ItemStack stack) {
                return false;
            }

            @Override
            public boolean removeKnowledge(@Nonnull ItemStack stack) {
                return false;
            }

            @Override
            @Nonnull
            public List<ItemStack> getKnowledge() {
                return this.immutableKnowledge;
            }

            @Override
            @Nonnull
            public IItemHandler getInputAndLocks() {
                return this.immutableInputLocks;
            }

            @Override
            public long getEmc() {
                return toCopy.getEmc();
            }

            @Override
            public void setEmc(long emc) {
            }

            @Override
            public void sync(@Nonnull EntityPlayerMP player) {
                toCopy.sync(player);
            }

            public NBTTagCompound serializeNBT() {
                return (NBTTagCompound)toCopy.serializeNBT();
            }

            public void deserializeNBT(NBTTagCompound nbt) {
            }
        };
    }
}

