/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.vanilladeathchest.api.deathchest;

import com.therandomlabs.vanilladeathchest.config.VDCConfig;
import com.therandomlabs.vanilladeathchest.world.storage.VDCSavedData;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.management.UserListOpsEntry;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DeathChest {
    private final World world;
    private final UUID playerID;
    private final long creationTime;
    private final BlockPos pos;
    private final boolean isDoubleChest;
    private boolean unlocked;

    public DeathChest(World world, UUID playerID, long creationTime, BlockPos pos, boolean isDoubleChest, boolean unlocked) {
        this.world = world;
        this.playerID = playerID;
        this.creationTime = creationTime;
        this.pos = pos;
        this.isDoubleChest = isDoubleChest;
        this.unlocked = unlocked;
    }

    public World getWorld() {
        return this.world;
    }

    public UUID getPlayerID() {
        return this.playerID;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public boolean isDoubleChest() {
        return this.isDoubleChest;
    }

    public boolean isUnlocked() {
        return this.unlocked;
    }

    public void setUnlocked(boolean flag) {
        this.unlocked = flag;
        VDCSavedData.get(this.world).func_76185_a();
    }

    public boolean canInteract(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        if (!VDCConfig.Protection.enabled || this.playerID.equals(player.func_110124_au()) || VDCConfig.Protection.bypassIfCreative && player.field_71075_bZ.field_75098_d) {
            return true;
        }
        UserListOpsEntry entry = (UserListOpsEntry)player.func_184102_h().func_184103_al().func_152603_m().func_152683_b((Object)player.func_146103_bH());
        if (entry == null || entry.func_152644_a() < VDCConfig.Protection.bypassPermissionLevel) {
            if (VDCConfig.Protection.period == 0) {
                return false;
            }
            long timeElapsed = player.func_130014_f_().func_82737_E() - this.creationTime;
            return timeElapsed > (long)VDCConfig.Protection.period;
        }
        return true;
    }
}

