/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.vanilladeathchest.handler;

import com.google.common.collect.Queues;
import com.therandomlabs.vanilladeathchest.config.VDCConfig;
import com.therandomlabs.vanilladeathchest.util.DeathChestPlacer;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.DimensionType;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="vanilladeathchest")
public final class DeathChestPlaceHandler {
    private static final Map<DimensionType, Queue<DeathChestPlacer>> PLACERS = new EnumMap<DimensionType, Queue<DeathChestPlacer>>(DimensionType.class);

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerDrops(PlayerDropsEvent event) {
        List drops = event.getDrops();
        if (drops.isEmpty()) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        if (player instanceof FakePlayer) {
            return;
        }
        World world = player.func_130014_f_();
        GameRules gameRules = world.func_82736_K();
        if (gameRules.func_82766_b("keepInventory")) {
            return;
        }
        if (!VDCConfig.Misc.gameRuleName.isEmpty() && !gameRules.func_82766_b(VDCConfig.Misc.gameRuleName)) {
            return;
        }
        Queue<DeathChestPlacer> placers = DeathChestPlaceHandler.getPlacers(world);
        placers.add(new DeathChestPlacer(world, player, drops));
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void worldTick(TickEvent.WorldTickEvent event) {
        DeathChestPlacer placer;
        Queue<DeathChestPlacer> placers = DeathChestPlaceHandler.getPlacers(event.world);
        ArrayList<DeathChestPlacer> toReadd = new ArrayList<DeathChestPlacer>();
        while ((placer = placers.poll()) != null) {
            if (placer.run()) continue;
            toReadd.add(placer);
        }
        placers.addAll(toReadd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Queue<DeathChestPlacer> getPlacers(World world) {
        Map<DimensionType, Queue<DeathChestPlacer>> map = PLACERS;
        synchronized (map) {
            return PLACERS.computeIfAbsent(world.field_73011_w.func_186058_p(), key -> Queues.newConcurrentLinkedQueue());
        }
    }
}

