/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.vanilladeathchest.handler;

import com.therandomlabs.vanilladeathchest.config.VDCConfig;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="vanilladeathchest")
public final class DefenseEntityHandler {
    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        double maxDistanceSqFromPlayer;
        EntityLivingBase entity = event.getEntityLiving();
        World world = entity.func_130014_f_();
        if (world.field_72995_K) {
            return;
        }
        NBTTagCompound data = entity.getEntityData();
        if (!data.func_74764_b("DeathChestPlayer")) {
            return;
        }
        UUID playerUUID = NBTUtil.func_186860_b((NBTTagCompound)data.func_74775_l("DeathChestPlayer"));
        EntityPlayer player = world.func_152378_a(playerUUID);
        if (player != null) {
            entity.func_70604_c((EntityLivingBase)player);
        }
        if (VDCConfig.Defense.defenseEntityMaxDistanceSquared == 0.0) {
            return;
        }
        BlockPos pos = NBTUtil.func_186861_c((NBTTagCompound)data.func_74775_l("DeathChestPos"));
        BlockPos entityPos = entity.func_180425_c();
        double distanceSq = entityPos.func_177951_i((Vec3i)pos);
        double distanceSqFromPlayer = player == null ? Double.MAX_VALUE : entityPos.func_177951_i((Vec3i)player.func_180425_c());
        if (distanceSq > VDCConfig.Defense.defenseEntityMaxDistanceSquared && ((maxDistanceSqFromPlayer = VDCConfig.Defense.defenseEntityMaxDistanceSquaredFromPlayer) == 0.0 || distanceSqFromPlayer > maxDistanceSqFromPlayer)) {
            entity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingDrops(LivingDropsEvent event) {
        if (!VDCConfig.Defense.defenseEntityDropsItems && event.getEntity().getEntityData().func_74764_b("DeathChestPlayer")) {
            event.getDrops().clear();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingExperienceDrop(LivingExperienceDropEvent event) {
        if (!VDCConfig.Defense.defenseEntityDropsExperience && event.getEntity().getEntityData().func_74764_b("DeathChestPlayer")) {
            event.setCanceled(true);
        }
    }
}

