/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.vanilladeathchest.util;

import com.google.common.collect.ImmutableList;
import com.therandomlabs.vanilladeathchest.VanillaDeathChest;
import com.therandomlabs.vanilladeathchest.config.VDCConfig;
import com.therandomlabs.vanilladeathchest.repackage.com.therandomlabs.randomlib.BooleanWrapper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class DeathChestLocationFinder {
    private static SearchOrder searchOrder;

    public static Iterable<BlockPos> getSearchOrder(int size) {
        if (searchOrder == null || DeathChestLocationFinder.searchOrder.size != size) {
            searchOrder = new SearchOrder(size);
        }
        return searchOrder;
    }

    public static BlockPos findLocation(World world, EntityPlayer player, BlockPos pos, BooleanWrapper doubleChest) {
        int y = pos.func_177956_o();
        if (!VanillaDeathChest.CUBIC_CHUNKS_LOADED) {
            int actualHeight;
            if (y < 1) {
                y = 1;
            }
            if (y > (actualHeight = world.func_72940_L())) {
                y = actualHeight;
            }
        }
        boolean isDoubleChest = doubleChest.get();
        BlockPos searchPos = new BlockPos(pos.func_177958_n(), y, pos.func_177952_p());
        BlockPos singleChestPos = null;
        for (BlockPos translation : DeathChestLocationFinder.getSearchOrder(VDCConfig.Spawning.locationSearchRadius)) {
            BlockPos potentialPos = searchPos.func_177971_a((Vec3i)translation);
            if (!DeathChestLocationFinder.canPlace(world, player, potentialPos)) continue;
            if ((!isDoubleChest || DeathChestLocationFinder.canPlace(world, player, potentialPos.func_177974_f())) && DeathChestLocationFinder.isOnSolidBlocks(world, potentialPos, isDoubleChest)) {
                return potentialPos;
            }
            if (singleChestPos != null) continue;
            singleChestPos = potentialPos;
        }
        if (singleChestPos != null) {
            doubleChest.set(false);
            return singleChestPos;
        }
        return VDCConfig.Spawning.forcePlaceIfLocationNotFound ? pos : null;
    }

    public static boolean canPlace(World world, EntityPlayer player, BlockPos pos, boolean doubleChest) {
        if (doubleChest) {
            return DeathChestLocationFinder.canPlace(world, player, pos) && DeathChestLocationFinder.canPlace(world, player, pos.func_177974_f());
        }
        return DeathChestLocationFinder.canPlace(world, player, pos);
    }

    public static boolean canPlace(World world, EntityPlayer player, BlockPos pos) {
        if (!world.func_175667_e(pos) || !world.func_175660_a(player, pos)) {
            return false;
        }
        if (DeathChestLocationFinder.isReplaceable(world, pos) && DeathChestLocationFinder.isReplaceable(world, pos.func_177984_a())) {
            return DeathChestLocationFinder.isNotChest(world, pos.func_177978_c()) && DeathChestLocationFinder.isNotChest(world, pos.func_177974_f()) && DeathChestLocationFinder.isNotChest(world, pos.func_177968_d()) && DeathChestLocationFinder.isNotChest(world, pos.func_177976_e());
        }
        return false;
    }

    private static boolean isReplaceable(World world, BlockPos pos) {
        int y;
        if (!(VanillaDeathChest.CUBIC_CHUNKS_LOADED || (y = pos.func_177956_o()) >= 1 && y <= world.func_72940_L())) {
            return false;
        }
        return world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos);
    }

    private static boolean isNotChest(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() != Blocks.field_150486_ae;
    }

    private static boolean isOnSolidBlocks(World world, BlockPos pos, boolean isDoubleChest) {
        if (!VDCConfig.Spawning.mustBeOnSolidBlocks) {
            return true;
        }
        BlockPos down = pos.func_177977_b();
        if (!world.isSideSolid(down, EnumFacing.UP)) {
            return false;
        }
        return !isDoubleChest || world.isSideSolid(down.func_177974_f(), EnumFacing.UP);
    }

    private static class SearchOrder
    implements Iterable<BlockPos> {
        public final int size;
        private List<BlockPos> translations;

        public SearchOrder(int size) {
            this.size = size;
            this.translations = new ArrayList<BlockPos>();
            for (int x = 0; x <= size; ++x) {
                this.add(x);
                this.add(-x);
            }
            this.translations = ImmutableList.copyOf(this.translations);
        }

        @Override
        public Iterator<BlockPos> iterator() {
            return this.translations.iterator();
        }

        private void add(int x) {
            for (int y = 0; y <= this.size; ++y) {
                this.add(x, y);
                this.add(x, -y);
            }
        }

        private void add(int x, int y) {
            for (int z = 0; z <= this.size; ++z) {
                this.translations.add(new BlockPos(x, y, z));
                this.translations.add(new BlockPos(x, y, -z));
            }
        }
    }
}

