/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.vanilladeathchest.util;

import com.mojang.authlib.GameProfile;
import com.therandomlabs.vanilladeathchest.VanillaDeathChest;
import com.therandomlabs.vanilladeathchest.api.deathchest.DeathChestManager;
import com.therandomlabs.vanilladeathchest.config.VDCConfig;
import com.therandomlabs.vanilladeathchest.gamestages.VDCStageInfo;
import com.therandomlabs.vanilladeathchest.repackage.com.therandomlabs.randomlib.BooleanWrapper;
import com.therandomlabs.vanilladeathchest.repackage.com.therandomlabs.randomlib.TRLUtils;
import com.therandomlabs.vanilladeathchest.util.DeathChestLocationFinder;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;

public final class DeathChestPlacer {
    private static final Method BECOME_ANGRY_AT = TRLUtils.findMethod(EntityPigZombie.class, "becomeAngryAt", "func_70835_c", Entity.class);
    private final WeakReference<World> world;
    private final WeakReference<EntityPlayer> player;
    private final List<EntityItem> drops;
    private boolean alreadyCalled;

    public DeathChestPlacer(World world, EntityPlayer player, List<EntityItem> drops) {
        this.world = new WeakReference<World>(world);
        this.player = new WeakReference<EntityPlayer>(player);
        this.drops = drops;
    }

    public final boolean run() {
        if (!this.alreadyCalled) {
            this.alreadyCalled = true;
            return false;
        }
        World world = (World)this.world.get();
        if (world == null) {
            return true;
        }
        EntityPlayer player = (EntityPlayer)this.player.get();
        if (player == null) {
            return true;
        }
        this.place(world, player);
        for (EntityItem drop : this.drops) {
            world.func_72838_d((Entity)drop);
        }
        return true;
    }

    private void place(World world, EntityPlayer player) {
        TileEntity tile2;
        boolean useDoubleChest;
        DeathChestType type = VDCConfig.Spawning.chestType;
        GameProfile profile = player.func_146103_bH();
        BlockPos playerPos = player.func_180425_c();
        VDCStageInfo info = VDCStageInfo.get(player);
        Pattern pattern = Pattern.compile(info.getRegistryNameRegex());
        List filtered = this.drops.stream().filter(item -> pattern.matcher(item.func_92059_d().func_77973_b().getRegistryName().toString()).matches()).collect(Collectors.toList());
        boolean bl = useDoubleChest = (type == DeathChestType.SINGLE_OR_DOUBLE || type == DeathChestType.DOUBLE_SHULKER_BOX) && filtered.size() > 27;
        if (info.useContainerInInventory()) {
            ArrayList<EntityItem> empty = new ArrayList<EntityItem>();
            boolean foundOne = false;
            boolean foundAll = false;
            for (EntityItem item2 : this.drops) {
                ItemStack stack = item2.func_92059_d();
                if (type == DeathChestType.SINGLE_ONLY || type == DeathChestType.SINGLE_OR_DOUBLE) {
                    if (stack.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150486_ae)) {
                        continue;
                    }
                } else {
                    if (!(Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockShulkerBox)) continue;
                    NBTTagCompound compound = stack.func_77978_p();
                    if (compound != null) {
                        NonNullList inventory = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
                        ItemStackHelper.func_191283_b((NBTTagCompound)compound.func_74775_l("BlockEntityTag"), (NonNullList)inventory);
                        if (inventory.stream().anyMatch(itemStack -> !itemStack.func_190926_b())) continue;
                    }
                }
                if (!useDoubleChest) {
                    stack.func_190918_g(1);
                    if (stack.func_190926_b()) {
                        empty.add(item2);
                    }
                    foundAll = true;
                    break;
                }
                if (stack.func_190916_E() > 1) {
                    stack.func_190918_g(2);
                    if (stack.func_190926_b()) {
                        empty.add(item2);
                    }
                    foundAll = true;
                    break;
                }
                stack.func_190918_g(1);
                if (stack.func_190926_b()) {
                    empty.add(item2);
                }
                if (foundOne) {
                    foundAll = true;
                    break;
                }
                foundOne = true;
            }
            if (useDoubleChest) {
                if (!foundAll) {
                    if (!foundOne) {
                        return;
                    }
                    useDoubleChest = false;
                }
            } else if (!foundAll) {
                return;
            }
            this.drops.removeAll(empty);
            filtered.removeAll(empty);
        }
        BooleanWrapper doubleChest = new BooleanWrapper(useDoubleChest);
        BlockPos pos = DeathChestLocationFinder.findLocation(world, player, playerPos, doubleChest);
        useDoubleChest = doubleChest.get();
        if (pos == null) {
            VanillaDeathChest.LOGGER.warn("No death chest location found for player at [{}]", (Object)playerPos);
            return;
        }
        Object block = type == DeathChestType.SHULKER_BOX || type == DeathChestType.DOUBLE_SHULKER_BOX ? BlockShulkerBox.func_190952_a((EnumDyeColor)VDCConfig.Spawning.shulkerBoxColor.get()) : Blocks.field_150486_ae;
        IBlockState state = block.func_176223_P();
        BlockPos east = pos.func_177974_f();
        world.func_175656_a(pos, state);
        if (useDoubleChest) {
            world.func_175656_a(east, state);
        }
        TileEntity tile = world.func_175625_s(pos);
        TileEntity tileEntity = tile2 = useDoubleChest ? world.func_175625_s(east) : null;
        if (!(tile instanceof TileEntityLockableLoot) || useDoubleChest && !(tile2 instanceof TileEntityLockableLoot)) {
            VanillaDeathChest.LOGGER.warn("Failed to place death chest at [{}] due to invalid tile entity", (Object)pos);
            return;
        }
        TileEntityLockableLoot chest = (TileEntityLockableLoot)tile;
        for (int i = 0; i < 27 && !filtered.isEmpty(); ++i) {
            EntityItem item3 = (EntityItem)filtered.get(0);
            chest.func_70299_a(i, item3.func_92059_d());
            filtered.remove(0);
            this.drops.remove(item3);
        }
        String displayName = info.getContainerDisplayName();
        if (!displayName.isEmpty()) {
            chest.func_190575_a(displayName);
        }
        if (useDoubleChest) {
            chest = (TileEntityLockableLoot)tile2;
            for (int i = 0; i < 27 && !filtered.isEmpty(); ++i) {
                EntityItem item4 = (EntityItem)filtered.get(0);
                chest.func_70299_a(i, item4.func_92059_d());
                filtered.remove(0);
                this.drops.remove(item4);
            }
            if (!displayName.isEmpty()) {
                chest.func_190575_a(displayName);
            }
        }
        if (info.getDefenseEntity() != null) {
            double x = (double)pos.func_177958_n() + 0.5;
            double y = (double)pos.func_177956_o() + 1.0;
            double z = (double)pos.func_177952_p() + 0.5;
            int count = info.getDefenseEntitySpawnCount();
            String nbt = info.getDefenseEntityNBT();
            String registryName = info.getDefenseEntityRegistryName();
            for (int i = 0; i < count; ++i) {
                NBTTagCompound compound = null;
                try {
                    compound = JsonToNBT.func_180713_a((String)nbt);
                }
                catch (NBTException nBTException) {
                    // empty catch block
                }
                compound.func_74778_a("id", registryName);
                Entity entity = AnvilChunkLoader.func_186054_a((NBTTagCompound)compound, (World)world, (double)x, (double)y, (double)z, (boolean)true);
                if (!(entity instanceof EntityLiving)) continue;
                EntityLiving living = (EntityLiving)entity;
                living.func_110163_bv();
                living.func_180482_a(world.func_175649_E(pos), null);
                if (living instanceof EntityPigZombie) {
                    try {
                        BECOME_ANGRY_AT.invoke((Object)living, player);
                    }
                    catch (IllegalAccessException | InvocationTargetException ex) {
                        VanillaDeathChest.LOGGER.error("Failed to make zombie pigman angry", (Throwable)ex);
                    }
                }
                NBTTagCompound data = living.getEntityData();
                data.func_74782_a("DeathChestPlayer", (NBTBase)NBTUtil.func_186862_a((UUID)player.func_110124_au()));
                data.func_74782_a("DeathChestPos", (NBTBase)NBTUtil.func_186859_a((BlockPos)pos));
            }
        }
        DeathChestManager.addDeathChest(world, player, pos, useDoubleChest);
        VanillaDeathChest.LOGGER.info("Death chest for {} spawned at [{}]", (Object)profile.getName(), (Object)pos);
        String chatMessage = info.getChatMessage();
        if (!chatMessage.isEmpty()) {
            player.func_145747_a((ITextComponent)new TextComponentString(String.format(chatMessage, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())));
        }
    }

    public static enum DeathChestType {
        SINGLE_ONLY("singleOnly"),
        SINGLE_OR_DOUBLE("singleOrDouble"),
        SHULKER_BOX("shulkerBox"),
        DOUBLE_SHULKER_BOX("doubleShulkerBox");

        private final String translationKey;

        private DeathChestType(String translationKey) {
            this.translationKey = "vanilladeathchest.config.spawning.chestType." + translationKey;
        }

        public String toString() {
            return this.translationKey;
        }
    }
}

