/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.vanilladeathchest.world.storage;

import com.therandomlabs.vanilladeathchest.api.deathchest.DeathChest;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class VDCSavedData
extends WorldSavedData {
    public static final String ID = "vanilladeathchest";
    public static final String DEATH_CHESTS_KEY = "DeathChests";
    public static final String UUID_KEY = "UUID";
    public static final String CREATION_TIME_KEY = "CreationTime";
    public static final String POS_KEY = "Pos";
    public static final String IS_DOUBLE_CHEST_KEY = "IsDoubleChest";
    public static final String UNLOCKED_KEY = "Unlocked";
    private static World currentWorld;
    private final World world;
    private final Map<BlockPos, DeathChest> deathChests = new ConcurrentHashMap<BlockPos, DeathChest>();

    public VDCSavedData() {
        this(ID);
    }

    public VDCSavedData(String name) {
        super(name);
        this.world = currentWorld;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.deathChests.clear();
        NBTTagList list = nbt.func_150295_c(DEATH_CHESTS_KEY, 10);
        for (NBTBase tag : list) {
            NBTTagCompound compound = (NBTTagCompound)tag;
            UUID playerID = NBTUtil.func_186860_b((NBTTagCompound)compound.func_74775_l(UUID_KEY));
            long creationTime = compound.func_74763_f(CREATION_TIME_KEY);
            BlockPos pos = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l(POS_KEY));
            boolean isDoubleChest = compound.func_74767_n(IS_DOUBLE_CHEST_KEY);
            boolean unlocked = compound.func_74767_n(UNLOCKED_KEY);
            this.deathChests.put(pos, new DeathChest(this.world, playerID, creationTime, pos, isDoubleChest, unlocked));
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        NBTTagList tagList = new NBTTagList();
        for (Map.Entry<BlockPos, DeathChest> entry : this.deathChests.entrySet()) {
            DeathChest deathChest = entry.getValue();
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74782_a(UUID_KEY, (NBTBase)NBTUtil.func_186862_a((UUID)deathChest.getPlayerID()));
            compound.func_74772_a(CREATION_TIME_KEY, deathChest.getCreationTime());
            compound.func_74782_a(POS_KEY, (NBTBase)NBTUtil.func_186859_a((BlockPos)entry.getKey()));
            compound.func_74757_a(IS_DOUBLE_CHEST_KEY, deathChest.isDoubleChest());
            compound.func_74757_a(UNLOCKED_KEY, deathChest.isUnlocked());
            tagList.func_74742_a((NBTBase)compound);
        }
        nbt.func_74782_a(DEATH_CHESTS_KEY, (NBTBase)tagList);
        return nbt;
    }

    public Map<BlockPos, DeathChest> getDeathChests() {
        return this.deathChests;
    }

    public static VDCSavedData get(World world) {
        currentWorld = world;
        MapStorage storage = world.getPerWorldStorage();
        VDCSavedData instance = (VDCSavedData)storage.func_75742_a(VDCSavedData.class, ID);
        if (instance == null) {
            instance = new VDCSavedData();
            storage.func_75745_a(ID, (WorldSavedData)instance);
        }
        currentWorld = null;
        return instance;
    }
}

