/*
 * Decompiled with CFR 0.152.
 */
package invtweaks.forge;

import invtweaks.InvTweaks;
import invtweaks.InvTweaksConfigManager;
import invtweaks.api.IItemTreeCategory;
import invtweaks.api.IItemTreeItem;
import java.util.HashSet;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="inventorytweaks")
public class ToolTipEvent {
    @SubscribeEvent
    public static void tTipEvent(ItemTooltipEvent event) {
        ItemStack current = event.getItemStack();
        if (current.func_190926_b()) {
            return;
        }
        InvTweaksConfigManager cfgManager = InvTweaks.getConfigManager();
        if (cfgManager == null) {
            return;
        }
        if (cfgManager.getConfig().getProperty("enableToolTipTreePath").equals("true")) {
            List<IItemTreeItem> items = cfgManager.getConfig().getTree().getItems(current.func_77973_b().getRegistryName().toString(), current.func_77952_i(), current.func_77978_p());
            if (items.isEmpty()) {
                return;
            }
            HashSet<String> paths = new HashSet<String>();
            IItemTreeCategory root = cfgManager.getConfig().getTree().getRootCategory();
            int unsortedZone = cfgManager.getConfig().getTree().getLastTreeOrder();
            int minOrder = Integer.MAX_VALUE;
            for (IItemTreeItem item : items) {
                String path = item.getPath();
                String altPath = root.findKeywordPath(item.getName());
                int itemOrder = item.getOrder();
                if ((minOrder = Integer.min(minOrder, itemOrder)) <= unsortedZone && itemOrder > unsortedZone) break;
                if (path.equals(altPath) || itemOrder > unsortedZone) {
                    if (paths.contains(path)) continue;
                    event.getToolTip().add(TextFormatting.DARK_GRAY + path + " (" + item.getOrder() + ")");
                    paths.add(path);
                    continue;
                }
                if (!paths.contains(path)) {
                    event.getToolTip().add(TextFormatting.DARK_GRAY + "T:" + path + " (" + item.getOrder() + ")");
                    paths.add(path);
                }
                if (paths.contains(altPath)) continue;
                event.getToolTip().add(TextFormatting.DARK_GRAY + "M:" + altPath + " (" + item.getOrder() + ")");
                paths.add(altPath);
            }
        }
    }
}

