/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.transport.pipe;

import buildcraft.api.statements.containers.IRedstoneStatementContainer;
import buildcraft.api.transport.IWireManager;
import buildcraft.api.transport.pipe.IPipe;
import buildcraft.api.transport.pipe.PipeEvent;
import buildcraft.api.transport.pluggable.PipePluggable;
import com.mojang.authlib.GameProfile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public interface IPipeHolder
extends IRedstoneStatementContainer {
    public World getPipeWorld();

    public BlockPos getPipePos();

    public TileEntity getPipeTile();

    public IPipe getPipe();

    public boolean canPlayerInteract(EntityPlayer var1);

    @Nullable
    public PipePluggable getPluggable(EnumFacing var1);

    @Nullable
    public TileEntity getNeighbourTile(EnumFacing var1);

    @Nullable
    public IPipe getNeighbourPipe(EnumFacing var1);

    @Nullable
    public <T> T getCapabilityFromPipe(EnumFacing var1, @Nonnull Capability<T> var2);

    public IWireManager getWireManager();

    public GameProfile getOwner();

    public boolean fireEvent(PipeEvent var1);

    public void scheduleRenderUpdate();

    public void scheduleNetworkUpdate(PipeMessageReceiver ... var1);

    public void scheduleNetworkGuiUpdate(PipeMessageReceiver ... var1);

    public void sendMessage(PipeMessageReceiver var1, IWriter var2);

    public void sendGuiMessage(PipeMessageReceiver var1, IWriter var2);

    public void onPlayerOpen(EntityPlayer var1);

    public void onPlayerClose(EntityPlayer var1);

    public static interface IWriter {
        public void write(PacketBuffer var1);
    }

    public static enum PipeMessageReceiver {
        BEHAVIOUR(null),
        FLOW(null),
        PLUGGABLE_DOWN(EnumFacing.DOWN),
        PLUGGABLE_UP(EnumFacing.UP),
        PLUGGABLE_NORTH(EnumFacing.NORTH),
        PLUGGABLE_SOUTH(EnumFacing.SOUTH),
        PLUGGABLE_WEST(EnumFacing.WEST),
        PLUGGABLE_EAST(EnumFacing.EAST),
        WIRES(null);

        public static final PipeMessageReceiver[] VALUES;
        public static final PipeMessageReceiver[] PLUGGABLES;
        public final EnumFacing face;

        private PipeMessageReceiver(EnumFacing face) {
            this.face = face;
        }

        static {
            VALUES = PipeMessageReceiver.values();
            PLUGGABLES = new PipeMessageReceiver[6];
            for (PipeMessageReceiver type : VALUES) {
                if (type.face == null) continue;
                PipeMessageReceiver.PLUGGABLES[type.face.ordinal()] = type;
            }
        }
    }
}

