/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalcultivation.item;

import cofh.core.init.CoreEnchantments;
import cofh.core.item.ItemMultiRF;
import cofh.core.key.KeyBindingItemMultiMode;
import cofh.core.render.IModelRegister;
import cofh.core.util.core.IInitializer;
import cofh.core.util.helpers.ChatHelper;
import cofh.core.util.helpers.EnergyHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalcultivation.ThermalCultivation;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ItemScythe
extends ItemMultiRF
implements IInitializer {
    private static Int2ObjectOpenHashMap<TypeEntry> typeMap = new Int2ObjectOpenHashMap();
    public static final int CAPACITY_BASE = 20000;
    public static final int XFER_BASE = 1000;
    public static final int ENERGY_PER_USE = 50;
    public static final int[] ENCHANTABILITY = new int[]{10, 10, 15, 15, 20};
    public static final int[] CAPACITY = new int[]{1, 3, 6, 10, 15};
    public static final int[] XFER = new int[]{1, 4, 9, 16, 25};
    public static boolean enable = true;
    public static ItemStack scytheBasic;
    public static ItemStack scytheHardened;
    public static ItemStack scytheReinforced;
    public static ItemStack scytheSignalum;
    public static ItemStack scytheResonant;
    public static ItemStack scytheCreative;

    public ItemScythe() {
        super("thermalcultivation");
        this.func_77655_b("scythe");
        this.func_77637_a(ThermalCultivation.tabTools);
        this.func_77627_a(true);
        this.func_77625_d(1);
    }

    public ItemStack setDefaultTag(ItemStack stack, int energy) {
        EnergyHelper.setDefaultEnergyTag((ItemStack)stack, (int)energy);
        stack.func_77978_p().func_74768_a("Mode", this.getNumModes(stack) - 1);
        return stack;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flagIn) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        int radius = this.getRadius(stack) * 2 + 1;
        tooltip.add(StringHelper.getInfoText((String)"info.thermalcultivation.scythe.a.0"));
        tooltip.add(StringHelper.localize((String)"info.cofh.area") + ": " + radius + "x" + radius);
        if (this.getNumModes(stack) > 1) {
            tooltip.add(StringHelper.localizeFormat((String)"info.thermalcultivation.scythe.b.0", (Object[])new Object[]{StringHelper.getKeyName((int)KeyBindingItemMultiMode.INSTANCE.getKey())}));
        }
        if (ItemScythe.isCreative((ItemStack)stack)) {
            tooltip.add(StringHelper.localize((String)"info.cofh.charge") + ": 1.21G RF");
        } else {
            tooltip.add(StringHelper.localize((String)"info.cofh.charge") + ": " + StringHelper.getScaledNumber((long)this.getEnergyStored(stack)) + " / " + StringHelper.getScaledNumber((long)this.getMaxEnergyStored(stack)) + " RF");
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            Iterator iterator = this.itemList.iterator();
            while (iterator.hasNext()) {
                int metadata = (Integer)iterator.next();
                if (metadata != 32000) {
                    items.add((Object)this.setDefaultTag(new ItemStack((Item)this, 1, metadata), 0));
                    items.add((Object)this.setDefaultTag(new ItemStack((Item)this, 1, metadata), this.getBaseCapacity(metadata)));
                    continue;
                }
                items.add((Object)this.setDefaultTag(new ItemStack((Item)this, 1, metadata), this.getBaseCapacity(metadata)));
            }
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (EnumEnchantmentType.BREAKABLE.equals((Object)enchantment.field_77351_y)) {
            return enchantment.equals(Enchantments.field_185307_s);
        }
        if (EnumEnchantmentType.DIGGER.equals((Object)enchantment.field_77351_y)) {
            return enchantment.equals(Enchantments.field_185308_t);
        }
        return !EnumEnchantmentType.BREAKABLE.equals((Object)enchantment.field_77351_y) && super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        World world = player.field_70170_p;
        IBlockState state = world.func_180495_p(pos);
        if (player.func_70093_af()) {
            if (!player.field_71075_bZ.field_75098_d) {
                this.useEnergy(stack, 1, false);
            }
            return false;
        }
        int count = 0;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int radius = this.getRadius(stack);
        block0: for (int i = x - radius; i <= x + radius; ++i) {
            for (int k = z - radius; k <= z + radius; ++k) {
                BlockPos adjPos = new BlockPos(i, y, k);
                if (this.getEnergyStored(stack) < 50 * count + 1) break block0;
                if (!this.harvestBlock(world, adjPos, player)) continue;
                ++count;
            }
        }
        if (count > 0 && !player.field_71075_bZ.field_75098_d) {
            this.useEnergy(stack, count, false);
            return true;
        }
        return false;
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.getEnchantability(stack);
    }

    protected boolean harvestBlock(World world, BlockPos pos, EntityPlayer player) {
        IBlockState state;
        Block block;
        if (world.func_175623_d(pos)) {
            return false;
        }
        EntityPlayerMP playerMP = null;
        if (player instanceof EntityPlayerMP) {
            playerMP = (EntityPlayerMP)player;
        }
        if (!((block = (state = world.func_180495_p(pos)).func_177230_c()) instanceof IGrowable)) {
            return false;
        }
        IGrowable grow = (IGrowable)block;
        if (grow.func_176473_a(world, pos, state, world.field_72995_K)) {
            return false;
        }
        if (!ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (IBlockAccess)world, (BlockPos)pos)) {
            return false;
        }
        int xpToDrop = 0;
        if (playerMP != null && (xpToDrop = ForgeHooks.onBlockBreakEvent((World)world, (GameType)playerMP.field_71134_c.func_73081_b(), (EntityPlayerMP)playerMP, (BlockPos)pos)) == -1) {
            return false;
        }
        if (player.field_71075_bZ.field_75098_d) {
            if (!world.field_72995_K) {
                if (block.removedByPlayer(state, world, pos, player, false)) {
                    block.func_176206_d(world, pos, state);
                }
                playerMP.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
            } else {
                if (block.removedByPlayer(state, world, pos, player, false)) {
                    block.func_176206_d(world, pos, state);
                }
                Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new CPacketPlayerDigging(CPacketPlayerDigging.Action.START_DESTROY_BLOCK, pos, Minecraft.func_71410_x().field_71476_x.field_178784_b));
            }
        }
        if (!world.field_72995_K) {
            if (block.removedByPlayer(state, world, pos, player, true)) {
                block.func_176206_d(world, pos, state);
                block.func_180657_a(world, player, pos, state, world.func_175625_s(pos), player.func_184614_ca());
                if (xpToDrop > 0) {
                    block.func_180637_b(world, pos, xpToDrop);
                }
            }
            playerMP.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
        } else {
            if (block.removedByPlayer(state, world, pos, player, true)) {
                block.func_176206_d(world, pos, state);
            }
            Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new CPacketPlayerDigging(CPacketPlayerDigging.Action.START_DESTROY_BLOCK, pos, Minecraft.func_71410_x().field_71476_x.field_178784_b));
        }
        return true;
    }

    protected int getCapacity(ItemStack stack) {
        if (!typeMap.containsKey(ItemHelper.getItemDamage((ItemStack)stack))) {
            return 0;
        }
        int capacity = ((TypeEntry)ItemScythe.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).capacity;
        int enchant = EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.holding, (ItemStack)stack);
        return capacity + capacity * enchant / 2;
    }

    protected int getReceive(ItemStack stack) {
        if (!typeMap.containsKey(ItemHelper.getItemDamage((ItemStack)stack))) {
            return 0;
        }
        return ((TypeEntry)ItemScythe.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).recv;
    }

    protected int useEnergy(ItemStack stack, int count, boolean simulate) {
        if (ItemScythe.isCreative((ItemStack)stack)) {
            return 0;
        }
        int unbreakingLevel = MathHelper.clamp((int)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)stack), (int)0, (int)10);
        if (MathHelper.RANDOM.nextInt(2 + unbreakingLevel) >= 2) {
            return 0;
        }
        return this.extractEnergy(stack, count * 50, simulate);
    }

    public int getBaseCapacity(int metadata) {
        if (!typeMap.containsKey(metadata)) {
            return 0;
        }
        return ((TypeEntry)ItemScythe.typeMap.get((int)metadata)).capacity;
    }

    public int getEnchantability(ItemStack stack) {
        if (!typeMap.containsKey(ItemHelper.getItemDamage((ItemStack)stack))) {
            return 0;
        }
        return ((TypeEntry)ItemScythe.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).enchantability;
    }

    public int getMaxRadius(int metadata) {
        if (!typeMap.containsKey(metadata)) {
            return 0;
        }
        return ((TypeEntry)ItemScythe.typeMap.get((int)metadata)).radius;
    }

    public int getRadius(ItemStack stack) {
        return 1 + this.getMode(stack);
    }

    public int getNumModes(ItemStack stack) {
        return this.getMaxRadius(ItemHelper.getItemDamage((ItemStack)stack));
    }

    public void onModeChange(EntityPlayer player, ItemStack stack) {
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187730_dW, SoundCategory.PLAYERS, 0.6f, 1.0f - 0.1f * (float)this.getMode(stack));
        int radius = this.getRadius(stack) * 2 + 1;
        ChatHelper.sendIndexedChatMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentTranslation("info.cofh.area", new Object[0]).func_150258_a(": " + radius + "x" + radius));
    }

    public boolean preInit() {
        ForgeRegistries.ITEMS.register(this.setRegistryName("scythe"));
        ThermalCultivation.proxy.addIModelRegister((IModelRegister)this);
        ItemScythe.config();
        scytheBasic = this.addEntryItem(0, "standard0", ENCHANTABILITY[0], CAPACITY[0], XFER[0], 1, EnumRarity.COMMON);
        scytheHardened = this.addEntryItem(1, "standard1", ENCHANTABILITY[1], CAPACITY[1], XFER[1], 2, EnumRarity.COMMON);
        scytheReinforced = this.addEntryItem(2, "standard2", ENCHANTABILITY[2], CAPACITY[2], XFER[2], 3, EnumRarity.UNCOMMON);
        scytheSignalum = this.addEntryItem(3, "standard3", ENCHANTABILITY[3], CAPACITY[3], XFER[3], 4, EnumRarity.UNCOMMON);
        scytheResonant = this.addEntryItem(4, "standard4", ENCHANTABILITY[4], CAPACITY[4], XFER[4], 5, EnumRarity.RARE);
        scytheCreative = this.addEntryItem(32000, "creative", ENCHANTABILITY[4], CAPACITY[4], 0, 5, EnumRarity.EPIC);
        return true;
    }

    public boolean initialize() {
        return enable;
    }

    private static void config() {
        String category = "Item.Scythe";
        enable = ThermalCultivation.CONFIG.get(category, "Enable", true);
        int capacity = 20000;
        String comment = "Adjust this value to change the amount of Energy (in RF) stored by a Basic Harvest Scythe. This base value will scale with item level.";
        capacity = ThermalCultivation.CONFIG.getConfiguration().getInt("BaseCapacity", category, capacity, 10000, 10000000, comment);
        int xfer = 1000;
        comment = "Adjust this value to change the amount of Energy (in RF/t) that can be received by a Basic Harvest Scythe. This base value will scale with item level.";
        xfer = ThermalCultivation.CONFIG.getConfiguration().getInt("BaseReceive", category, xfer, 100, 1000000, comment);
        int i = 0;
        while (i < CAPACITY.length) {
            int n = i;
            CAPACITY[n] = CAPACITY[n] * capacity;
            int n2 = i++;
            XFER[n2] = XFER[n2] * xfer;
        }
    }

    private void addEntry(int metadata, String name, int enchantability, int capacity, int xfer, int radius) {
        typeMap.put(metadata, (Object)new TypeEntry(name, enchantability, capacity, xfer, radius));
    }

    private ItemStack addEntryItem(int metadata, String name, int enchantability, int capacity, int xfer, int radius, EnumRarity rarity) {
        this.addEntry(metadata, name, enchantability, capacity, xfer, radius);
        return this.addItem(metadata, name, rarity);
    }

    public class TypeEntry {
        public final String name;
        public final int enchantability;
        public final int capacity;
        public final int recv;
        public final int radius;

        TypeEntry(String name, int enchantability, int capacity, int recv, int radius) {
            this.name = name;
            this.enchantability = enchantability;
            this.capacity = capacity;
            this.recv = recv;
            this.radius = radius;
        }
    }
}

