/*
 * Decompiled with CFR 0.152.
 */
package T145.metalchests.client.render.blocks;

import T145.metalchests.api.BlocksMC;
import T145.metalchests.api.immutable.ChestType;
import T145.metalchests.client.render.blocks.RenderMetalChest;
import T145.metalchests.tiles.TileSortingMetalChest;
import javax.annotation.Nullable;
import net.blay09.mods.refinedrelocation.RefinedRelocationConfig;
import net.blay09.mods.refinedrelocation.client.render.ModelLidOverlay;
import net.blay09.mods.refinedrelocation.client.render.SafeTESR;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.model.ModelChest;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderSortingMetalChest
extends SafeTESR<TileSortingMetalChest> {
    private final ModelChest model = new ModelChest();
    private final ModelLidOverlay chestLid = new ModelLidOverlay();

    public RenderSortingMetalChest(Block block) {
        super(block);
    }

    public RenderSortingMetalChest() {
        super(BlocksMC.SORTING_METAL_CHEST);
    }

    protected ResourceLocation getActiveResource(ChestType type) {
        return new ResourceLocation("metalchests", "textures/entity/chest/" + type.func_176610_l() + ".png");
    }

    protected ResourceLocation getActiveOverlay(ChestType type) {
        return new ResourceLocation("metalchests", "textures/entity/chest/overlay/" + type.func_176610_l() + ".png");
    }

    public void renderTileEntityAt(TileSortingMetalChest chest, double x, double y, double z, float partialTicks, int destroyStage, @Nullable IBlockState state) {
        GlStateManager.func_179126_j();
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179132_a((boolean)true);
        if (destroyStage >= 0) {
            this.func_147499_a(field_178460_a[destroyStage]);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)4.0f, (float)4.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GlStateManager.func_179128_n((int)5888);
        } else {
            this.func_147499_a(this.getActiveResource(chest.getChestType()));
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179091_B();
        if (destroyStage < 0) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GlStateManager.func_179137_b((double)x, (double)(y + 1.0), (double)(z + 1.0));
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.func_179114_b((float)RenderMetalChest.getFrontAngle(chest.getFront()), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
        float f = chest.prevLidAngle + (chest.lidAngle - chest.prevLidAngle) * partialTicks;
        f = 1.0f - f;
        f = 1.0f - f * f * f;
        this.model.field_78234_a.field_78795_f = (float)(-((double)f * 1.5707963267948966));
        this.model.func_78231_a();
        if (destroyStage == -1) {
            this.func_147499_a(this.getActiveOverlay(chest.getChestType()));
            GlStateManager.func_179109_b((float)0.0f, (float)-0.001f, (float)0.0f);
            this.chestLid.chestLid.field_78795_f = this.model.field_78234_a.field_78795_f;
            this.chestLid.renderAll();
        }
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (destroyStage >= 0) {
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
        }
    }

    protected boolean shouldRenderNameTag(TileSortingMetalChest chest) {
        return chest.hasCustomName() && RefinedRelocationConfig.renderChestNameTags;
    }
}

